/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.util.BitSet;
import java.util.HashMap;
import java.util.logging.Level;

public class SpriteHelper {
    private static HashMap<String, BitSet> spriteInfo = new HashMap();

    private static void initMCSpriteMaps() {
        BitSet slots = SpriteHelper.toBitSet("0000000000000000000000000011000000000000001000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110000000000000000000000000111110000000000011110000000000000000000");
        spriteInfo.put("/terrain.png", slots);
        slots = SpriteHelper.toBitSet("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110000000000111111101000000001111111100000000111111111111001111111111111111100000111111111110000000000000000");
        spriteInfo.put("/gui/items.png", slots);
    }

    public static void registerSpriteMapForFile(String file, String spriteMap) {
        if (spriteInfo.size() == 0) {
            SpriteHelper.initMCSpriteMaps();
        }
        if (spriteInfo.containsKey(file)) {
            FMLLog.log("fml.TextureManager", Level.FINE, "Duplicate attempt to register a sprite file %s for overriding -- ignoring", file);
            return;
        }
        spriteInfo.put(file, SpriteHelper.toBitSet(spriteMap));
    }

    public static int getUniqueSpriteIndex(String path) {
        int ret;
        BitSet slots;
        if (!spriteInfo.containsKey("/terrain.png")) {
            SpriteHelper.initMCSpriteMaps();
        }
        if ((slots = spriteInfo.get(path)) == null) {
            Exception ex2 = new Exception(String.format("Invalid getUniqueSpriteIndex call for texture: %s", path));
            FMLLog.log("fml.TextureManager", Level.SEVERE, ex2, "A critical error has been detected with sprite overrides", new Object[0]);
            FMLCommonHandler.instance().raiseException(ex2, "Invalid request to getUniqueSpriteIndex", true);
        }
        if ((ret = SpriteHelper.getFreeSlot(slots)) == -1) {
            Exception ex3 = new Exception(String.format("No more sprite indicies left for: %s", path));
            FMLLog.log("fml.TextureManager", Level.SEVERE, ex3, "There are no sprite indicies left for %s", path);
            FMLCommonHandler.instance().raiseException(ex3, "No more sprite indicies left", true);
        }
        return ret;
    }

    public static BitSet toBitSet(String data) {
        BitSet ret = new BitSet(data.length());
        for (int x2 = 0; x2 < data.length(); ++x2) {
            ret.set(x2, data.charAt(x2) == '1');
        }
        return ret;
    }

    public static int getFreeSlot(BitSet slots) {
        int next = slots.nextSetBit(0);
        slots.clear(next);
        return next;
    }

    public static int freeSlotCount(String textureToOverride) {
        return spriteInfo.get(textureToOverride).cardinality();
    }
}

