/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.Event;

public class ForgeChunkManager {
    private static int defaultMaxCount;
    private static int defaultMaxChunks;
    private static boolean overridesEnabled;
    private static Map<yc, Multimap<String, Ticket>> tickets;
    private static Map<String, Integer> ticketConstraints;
    private static Map<String, Integer> chunkConstraints;
    private static SetMultimap<String, Ticket> playerTickets;
    private static Map<String, LoadingCallback> callbacks;
    private static Map<yc, ImmutableSetMultimap<xv, Ticket>> forcedChunks;
    private static BiMap<UUID, Ticket> pendingEntities;
    private static Map<yc, Cache<Long, zz>> dormantChunkCache;
    private static File cfgFile;
    private static Configuration config;
    private static int playerTicketLength;
    private static int dormantChunkCacheSize;
    private static Set<String> warnedMods;

    public static boolean savedWorldHasForcedChunkTickets(File chunkDir) {
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        if (chunkLoaderData.exists() && chunkLoaderData.isFile()) {
            try {
                bq forcedChunkData = ca.a(chunkLoaderData);
                return forcedChunkData.m("TicketList").c() > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static void loadWorld(yc world) {
        ArrayListMultimap newTickets = ArrayListMultimap.create();
        tickets.put(world, (Multimap<String, Ticket>)newTickets);
        forcedChunks.put(world, (ImmutableSetMultimap<xv, Ticket>)ImmutableSetMultimap.of());
        if (!(world instanceof in)) {
            return;
        }
        dormantChunkCache.put(world, (Cache<Long, zz>)CacheBuilder.newBuilder().maximumSize((long)dormantChunkCacheSize).build());
        in worldServer = (in)world;
        File chunkDir = worldServer.getChunkSaveLocation();
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        if (chunkLoaderData.exists() && chunkLoaderData.isFile()) {
            LoadingCallback loadingCallback;
            List<Ticket> tickets;
            bq forcedChunkData;
            ArrayListMultimap loadedTickets = ArrayListMultimap.create();
            HashMap playerLoadedTickets = Maps.newHashMap();
            try {
                forcedChunkData = ca.a(chunkLoaderData);
            }
            catch (IOException e2) {
                FMLLog.log(Level.WARNING, e2, "Unable to read forced chunk data at %s - it will be ignored", chunkLoaderData.getAbsolutePath());
                return;
            }
            by ticketList = forcedChunkData.m("TicketList");
            for (int i2 = 0; i2 < ticketList.c(); ++i2) {
                bq ticketHolder = (bq)ticketList.b(i2);
                String modId = ticketHolder.i("Owner");
                boolean isPlayer = "Forge".equals(modId);
                if (!isPlayer && !Loader.isModLoaded(modId)) {
                    FMLLog.warning("Found chunkloading data for mod %s which is currently not available or active - it will be removed from the world save", modId);
                    continue;
                }
                if (!isPlayer && !callbacks.containsKey(modId)) {
                    FMLLog.warning("The mod %s has registered persistent chunkloading data but doesn't seem to want to be called back with it - it will be removed from the world save", modId);
                    continue;
                }
                tickets = ticketHolder.m("Tickets");
                for (int j2 = 0; j2 < ((by)((Object)tickets)).c(); ++j2) {
                    bq ticket = (bq)((by)((Object)tickets)).b(j2);
                    modId = ticket.b("ModId") ? ticket.i("ModId") : modId;
                    Type type = Type.values()[ticket.c("Type")];
                    byte ticketChunkDepth = ticket.c("ChunkListDepth");
                    Ticket tick = new Ticket(modId, type, world);
                    if (ticket.b("ModData")) {
                        tick.modData = ticket.l("ModData");
                    }
                    if (ticket.b("Player")) {
                        tick.player = ticket.i("Player");
                        if (!playerLoadedTickets.containsKey(tick.modId)) {
                            playerLoadedTickets.put(modId, ArrayListMultimap.create());
                        }
                        ((ListMultimap)playerLoadedTickets.get(tick.modId)).put((Object)tick.player, (Object)tick);
                    } else {
                        loadedTickets.put((Object)modId, (Object)tick);
                    }
                    if (type != Type.ENTITY) continue;
                    tick.entityChunkX = ticket.e("chunkX");
                    tick.entityChunkZ = ticket.e("chunkZ");
                    UUID uuid = new UUID(ticket.f("PersistentIDMSB"), ticket.f("PersistentIDLSB"));
                    pendingEntities.put((Object)uuid, (Object)tick);
                }
            }
            for (Ticket tick : ImmutableSet.copyOf((Collection)pendingEntities.values())) {
                if (tick.ticketType != Type.ENTITY || tick.entity != null) continue;
                world.e(tick.entityChunkX, tick.entityChunkZ);
            }
            for (Ticket tick : ImmutableSet.copyOf((Collection)pendingEntities.values())) {
                if (tick.ticketType != Type.ENTITY || tick.entity != null) continue;
                FMLLog.warning("Failed to load persistent chunkloading entity %s from store.", pendingEntities.inverse().get((Object)tick));
                loadedTickets.remove((Object)tick.modId, (Object)tick);
            }
            pendingEntities.clear();
            for (String modId : loadedTickets.keySet()) {
                loadingCallback = callbacks.get(modId);
                int maxTicketLength = ForgeChunkManager.getMaxTicketLengthFor(modId);
                tickets = loadedTickets.get((Object)modId);
                if (loadingCallback instanceof OrderedLoadingCallback) {
                    OrderedLoadingCallback orderedLoadingCallback = (OrderedLoadingCallback)loadingCallback;
                    tickets = orderedLoadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets), world, maxTicketLength);
                }
                if (tickets.size() > maxTicketLength) {
                    FMLLog.warning("The mod %s has too many open chunkloading tickets %d. Excess will be dropped", modId, tickets.size());
                    tickets.subList(maxTicketLength, tickets.size()).clear();
                }
                ForgeChunkManager.tickets.get(world).putAll((Object)modId, tickets);
                loadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf(tickets), world);
            }
            for (String modId : playerLoadedTickets.keySet()) {
                loadingCallback = callbacks.get(modId);
                ListMultimap<String, Ticket> tickets2 = (ListMultimap<String, Ticket>)playerLoadedTickets.get(modId);
                if (loadingCallback instanceof PlayerOrderedLoadingCallback) {
                    PlayerOrderedLoadingCallback orderedLoadingCallback = (PlayerOrderedLoadingCallback)loadingCallback;
                    tickets2 = orderedLoadingCallback.playerTicketsLoaded((ListMultimap<String, Ticket>)ImmutableListMultimap.copyOf((Multimap)tickets2), world);
                    playerTickets.putAll(tickets2);
                }
                ForgeChunkManager.tickets.get(world).putAll((Object)"Forge", (Iterable)tickets2.values());
                loadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets2.values()), world);
            }
        }
    }

    static void unloadWorld(yc world) {
        if (!(world instanceof in)) {
            return;
        }
        forcedChunks.remove(world);
        dormantChunkCache.remove(world);
        if (!MinecraftServer.D().m()) {
            playerTickets.clear();
            tickets.clear();
        }
    }

    public static void setForcedChunkLoadingCallback(Object mod, LoadingCallback callback) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container == null) {
            FMLLog.warning("Unable to register a callback for an unknown mod %s (%s : %x)", mod, mod.getClass().getName(), System.identityHashCode(mod));
            return;
        }
        callbacks.put(container.getModId(), callback);
    }

    public static int ticketCountAvailableFor(Object mod, yc world) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            String modId = container.getModId();
            int allowedCount = ForgeChunkManager.getMaxTicketLengthFor(modId);
            return allowedCount - tickets.get(world).get((Object)modId).size();
        }
        return 0;
    }

    private static ModContainer getContainer(Object mod) {
        ModContainer container = (ModContainer)Loader.instance().getModObjectList().inverse().get(mod);
        return container;
    }

    public static int getMaxTicketLengthFor(String modId) {
        int allowedCount = ticketConstraints.containsKey(modId) && overridesEnabled ? ticketConstraints.get(modId) : defaultMaxCount;
        return allowedCount;
    }

    public static int getMaxChunkDepthFor(String modId) {
        int allowedCount = chunkConstraints.containsKey(modId) && overridesEnabled ? chunkConstraints.get(modId) : defaultMaxChunks;
        return allowedCount;
    }

    public static int ticketCountAvailableFor(String username) {
        return playerTicketLength - playerTickets.get((Object)username).size();
    }

    public static Ticket requestPlayerTicket(Object mod, String player, yc world, Type type) {
        ModContainer mc2 = ForgeChunkManager.getContainer(mod);
        if (mc2 == null) {
            FMLLog.log(Level.SEVERE, "Failed to locate the container for mod instance %s (%s : %x)", mod, mod.getClass().getName(), System.identityHashCode(mod));
            return null;
        }
        if (playerTickets.get((Object)player).size() > playerTicketLength) {
            FMLLog.warning("Unable to assign further chunkloading tickets to player %s (on behalf of mod %s)", player, mc2.getModId());
            return null;
        }
        Ticket ticket = new Ticket(mc2.getModId(), type, world, player);
        playerTickets.put((Object)player, (Object)ticket);
        tickets.get(world).put((Object)"Forge", (Object)ticket);
        return ticket;
    }

    public static Ticket requestTicket(Object mod, yc world, Type type) {
        int allowedCount;
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container == null) {
            FMLLog.log(Level.SEVERE, "Failed to locate the container for mod instance %s (%s : %x)", mod, mod.getClass().getName(), System.identityHashCode(mod));
            return null;
        }
        String modId = container.getModId();
        if (!callbacks.containsKey(modId)) {
            FMLLog.severe("The mod %s has attempted to request a ticket without a listener in place", modId);
            throw new RuntimeException("Invalid ticket request");
        }
        int n2 = allowedCount = ticketConstraints.containsKey(modId) ? ticketConstraints.get(modId) : defaultMaxCount;
        if (tickets.get(world).get((Object)modId).size() >= allowedCount) {
            if (!warnedMods.contains(modId)) {
                FMLLog.info("The mod %s has attempted to allocate a chunkloading ticket beyond it's currently allocated maximum : %d", modId, allowedCount);
                warnedMods.add(modId);
            }
            return null;
        }
        Ticket ticket = new Ticket(modId, type, world);
        tickets.get(world).put((Object)modId, (Object)ticket);
        return ticket;
    }

    public static void releaseTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (ticket.isPlayerTicket() ? !playerTickets.containsValue((Object)ticket) : !tickets.get(ticket.world).containsEntry((Object)ticket.modId, (Object)ticket)) {
            return;
        }
        if (ticket.requestedChunks != null) {
            for (xv chunk : ImmutableSet.copyOf((Collection)ticket.requestedChunks)) {
                ForgeChunkManager.unforceChunk(ticket, chunk);
            }
        }
        if (ticket.isPlayerTicket()) {
            playerTickets.remove((Object)ticket.player, (Object)ticket);
            tickets.get(ticket.world).remove((Object)"Forge", (Object)ticket);
        } else {
            tickets.get(ticket.world).remove((Object)ticket.modId, (Object)ticket);
        }
    }

    public static void forceChunk(Ticket ticket, xv chunk) {
        if (ticket == null || chunk == null) {
            return;
        }
        if (ticket.ticketType == Type.ENTITY && ticket.entity == null) {
            throw new RuntimeException("Attempted to use an entity ticket to force a chunk, without an entity");
        }
        if (ticket.isPlayerTicket() ? !playerTickets.containsValue((Object)ticket) : !tickets.get(ticket.world).containsEntry((Object)ticket.modId, (Object)ticket)) {
            FMLLog.severe("The mod %s attempted to force load a chunk with an invalid ticket. This is not permitted.", ticket.modId);
            return;
        }
        ticket.requestedChunks.add(chunk);
        MinecraftForge.EVENT_BUS.post(new ForceChunkEvent(ticket, chunk));
        ImmutableSetMultimap newMap = ImmutableSetMultimap.builder().putAll((Multimap)forcedChunks.get(ticket.world)).put((Object)chunk, (Object)ticket).build();
        forcedChunks.put(ticket.world, (ImmutableSetMultimap<xv, Ticket>)newMap);
        if (ticket.maxDepth > 0 && ticket.requestedChunks.size() > ticket.maxDepth) {
            xv removed = (xv)ticket.requestedChunks.iterator().next();
            ForgeChunkManager.unforceChunk(ticket, removed);
        }
    }

    public static void reorderChunk(Ticket ticket, xv chunk) {
        if (ticket == null || chunk == null || !ticket.requestedChunks.contains(chunk)) {
            return;
        }
        ticket.requestedChunks.remove(chunk);
        ticket.requestedChunks.add(chunk);
    }

    public static void unforceChunk(Ticket ticket, xv chunk) {
        if (ticket == null || chunk == null) {
            return;
        }
        ticket.requestedChunks.remove(chunk);
        MinecraftForge.EVENT_BUS.post(new UnforceChunkEvent(ticket, chunk));
        LinkedHashMultimap copy = LinkedHashMultimap.create((Multimap)((Multimap)forcedChunks.get(ticket.world)));
        copy.remove((Object)chunk, (Object)ticket);
        ImmutableSetMultimap newMap = ImmutableSetMultimap.copyOf((Multimap)copy);
        forcedChunks.put(ticket.world, (ImmutableSetMultimap<xv, Ticket>)newMap);
    }

    static void loadConfiguration() {
        for (String mod : ForgeChunkManager.config.categories.keySet()) {
            if (mod.equals("Forge") || mod.equals("defaults")) continue;
            Property modTC = config.get(mod, "maximumTicketCount", 200);
            Property modCPT = config.get(mod, "maximumChunksPerTicket", 25);
            ticketConstraints.put(mod, modTC.getInt(200));
            chunkConstraints.put(mod, modCPT.getInt(25));
        }
        config.save();
    }

    public static ImmutableSetMultimap<xv, Ticket> getPersistentChunksFor(yc world) {
        return forcedChunks.containsKey(world) ? forcedChunks.get(world) : ImmutableSetMultimap.of();
    }

    static void saveWorld(yc world) {
        if (!(world instanceof in)) {
            return;
        }
        in worldServer = (in)world;
        File chunkDir = worldServer.getChunkSaveLocation();
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        bq forcedChunkData = new bq();
        by ticketList = new by();
        forcedChunkData.a("TicketList", ticketList);
        Multimap<String, Ticket> ticketSet = tickets.get(worldServer);
        for (String modId : ticketSet.keySet()) {
            bq ticketHolder = new bq();
            ticketList.a(ticketHolder);
            ticketHolder.a("Owner", modId);
            by tickets = new by();
            ticketHolder.a("Tickets", tickets);
            for (Ticket tick : ticketSet.get((Object)modId)) {
                bq ticket = new bq();
                ticket.a("Type", (byte)tick.ticketType.ordinal());
                ticket.a("ChunkListDepth", (byte)tick.maxDepth);
                if (tick.isPlayerTicket()) {
                    ticket.a("ModId", tick.modId);
                    ticket.a("Player", tick.player);
                }
                if (tick.modData != null) {
                    ticket.a("ModData", tick.modData);
                }
                if (tick.ticketType == Type.ENTITY && tick.entity != null && tick.entity.c(new bq())) {
                    ticket.a("chunkX", ke.c((double)((Ticket)tick).entity.ai));
                    ticket.a("chunkZ", ke.c((double)((Ticket)tick).entity.ak));
                    ticket.a("PersistentIDMSB", tick.entity.getPersistentID().getMostSignificantBits());
                    ticket.a("PersistentIDLSB", tick.entity.getPersistentID().getLeastSignificantBits());
                    tickets.a(ticket);
                    continue;
                }
                if (tick.ticketType == Type.ENTITY) continue;
                tickets.a(ticket);
            }
        }
        try {
            ca.b(forcedChunkData, chunkLoaderData);
        }
        catch (IOException e2) {
            FMLLog.log(Level.WARNING, e2, "Unable to write forced chunk data to %s - chunkloading won't work", chunkLoaderData.getAbsolutePath());
            return;
        }
    }

    static void loadEntity(lq entity) {
        UUID id = entity.getPersistentID();
        Ticket tick = (Ticket)pendingEntities.get((Object)id);
        if (tick != null) {
            tick.bindEntity(entity);
            pendingEntities.remove((Object)id);
        }
    }

    public static void putDormantChunk(long coords, zz chunk) {
        Cache<Long, zz> cache = dormantChunkCache.get(chunk.e);
        if (cache != null) {
            cache.put((Object)coords, (Object)chunk);
        }
    }

    public static zz fetchDormantChunk(long coords, yc world) {
        Cache<Long, zz> cache = dormantChunkCache.get(world);
        if (cache == null) {
            return null;
        }
        zz chunk = (zz)cache.getIfPresent((Object)coords);
        if (chunk != null) {
            for (List eList : chunk.j) {
                for (lq e2 : eList) {
                    e2.resetEntityId();
                }
            }
        }
        return chunk;
    }

    static void captureConfig(File configDir) {
        cfgFile = new File(configDir, "forgeChunkLoading.cfg");
        config = new Configuration(cfgFile, true);
        try {
            config.load();
        }
        catch (Exception e2) {
            File dest = new File(cfgFile.getParentFile(), "forgeChunkLoading.cfg.bak");
            if (dest.exists()) {
                dest.delete();
            }
            cfgFile.renameTo(dest);
            FMLLog.log(Level.SEVERE, e2, "A critical error occured reading the forgeChunkLoading.cfg file, defaults will be used - the invalid file is backed up at forgeChunkLoading.cfg.bak", new Object[0]);
        }
        config.addCustomCategoryComment("defaults", "Default configuration for forge chunk loading control");
        Property maxTicketCount = config.get("defaults", "maximumTicketCount", 200);
        maxTicketCount.comment = "The default maximum ticket count for a mod which does not have an override\nin this file. This is the number of chunk loading requests a mod is allowed to make.";
        defaultMaxCount = maxTicketCount.getInt(200);
        Property maxChunks = config.get("defaults", "maximumChunksPerTicket", 25);
        maxChunks.comment = "The default maximum number of chunks a mod can force, per ticket, \nfor a mod without an override. This is the maximum number of chunks a single ticket can force.";
        defaultMaxChunks = maxChunks.getInt(25);
        Property playerTicketCount = config.get("defaults", "playerTicketCount", 500);
        playerTicketCount.comment = "The number of tickets a player can be assigned instead of a mod. This is shared across all mods and it is up to the mods to use it.";
        playerTicketLength = playerTicketCount.getInt(500);
        Property dormantChunkCacheSizeProperty = config.get("defaults", "dormantChunkCacheSize", 0);
        dormantChunkCacheSizeProperty.comment = "Unloaded chunks can first be kept in a dormant cache for quicker\nloading times. Specify the size of that cache here";
        dormantChunkCacheSize = dormantChunkCacheSizeProperty.getInt(0);
        FMLLog.info("Configured a dormant chunk cache size of %d", dormantChunkCacheSizeProperty.getInt(0));
        Property modOverridesEnabled = config.get("defaults", "enabled", true);
        modOverridesEnabled.comment = "Are mod overrides enabled?";
        overridesEnabled = modOverridesEnabled.getBoolean(true);
        config.addCustomCategoryComment("Forge", "Sample mod specific control section.\nCopy this section and rename the with the modid for the mod you wish to override.\nA value of zero in either entry effectively disables any chunkloading capabilities\nfor that mod");
        Property sampleTC = config.get("Forge", "maximumTicketCount", 200);
        sampleTC.comment = "Maximum ticket count for the mod. Zero disables chunkloading capabilities.";
        sampleTC = config.get("Forge", "maximumChunksPerTicket", 25);
        sampleTC.comment = "Maximum chunks per ticket for the mod.";
        for (String mod : ForgeChunkManager.config.categories.keySet()) {
            if (mod.equals("Forge") || mod.equals("defaults")) continue;
            Property modTC = config.get(mod, "maximumTicketCount", 200);
            Property modCPT = config.get(mod, "maximumChunksPerTicket", 25);
        }
    }

    public static Map<String, Property> getConfigMapFor(Object mod) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            return config.getCategory(container.getModId()).getValues();
        }
        return null;
    }

    public static void addConfigProperty(Object mod, String propertyName, String value, Property.Type type) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            Map<String, Property> props = config.getCategory(container.getModId()).getValues();
            props.put(propertyName, new Property(propertyName, value, type));
        }
    }

    static {
        tickets = new MapMaker().weakKeys().makeMap();
        ticketConstraints = Maps.newHashMap();
        chunkConstraints = Maps.newHashMap();
        playerTickets = HashMultimap.create();
        callbacks = Maps.newHashMap();
        forcedChunks = new MapMaker().weakKeys().makeMap();
        pendingEntities = HashBiMap.create();
        dormantChunkCache = new MapMaker().weakKeys().makeMap();
        warnedMods = Sets.newHashSet();
    }

    public static class UnforceChunkEvent
    extends Event {
        public final Ticket ticket;
        public final xv location;

        public UnforceChunkEvent(Ticket ticket, xv location) {
            this.ticket = ticket;
            this.location = location;
        }
    }

    public static class ForceChunkEvent
    extends Event {
        public final Ticket ticket;
        public final xv location;

        public ForceChunkEvent(Ticket ticket, xv location) {
            this.ticket = ticket;
            this.location = location;
        }
    }

    public static class Ticket {
        private String modId;
        private Type ticketType;
        private LinkedHashSet<xv> requestedChunks;
        private bq modData;
        public final yc world;
        private int maxDepth;
        private String entityClazz;
        private int entityChunkX;
        private int entityChunkZ;
        private lq entity;
        private String player;

        Ticket(String modId, Type type, yc world) {
            this.modId = modId;
            this.ticketType = type;
            this.world = world;
            this.maxDepth = ForgeChunkManager.getMaxChunkDepthFor(modId);
            this.requestedChunks = Sets.newLinkedHashSet();
        }

        Ticket(String modId, Type type, yc world, String player) {
            this(modId, type, world);
            if (player == null) {
                FMLLog.log(Level.SEVERE, "Attempt to create a player ticket without a valid player", new Object[0]);
                throw new RuntimeException();
            }
            this.player = player;
        }

        public void setChunkListDepth(int depth) {
            if (depth > ForgeChunkManager.getMaxChunkDepthFor(this.modId) || depth <= 0 && ForgeChunkManager.getMaxChunkDepthFor(this.modId) > 0) {
                FMLLog.warning("The mod %s tried to modify the chunk ticket depth to: %d, its allowed maximum is: %d", this.modId, depth, ForgeChunkManager.getMaxChunkDepthFor(this.modId));
            } else {
                this.maxDepth = depth;
            }
        }

        public int getChunkListDepth() {
            return this.maxDepth;
        }

        public int getMaxChunkListDepth() {
            return ForgeChunkManager.getMaxChunkDepthFor(this.modId);
        }

        public void bindEntity(lq entity) {
            if (this.ticketType != Type.ENTITY) {
                throw new RuntimeException("Cannot bind an entity to a non-entity ticket");
            }
            this.entity = entity;
        }

        public bq getModData() {
            if (this.modData == null) {
                this.modData = new bq();
            }
            return this.modData;
        }

        public lq getEntity() {
            return this.entity;
        }

        public boolean isPlayerTicket() {
            return this.player != null;
        }

        public String getPlayerName() {
            return this.player;
        }

        public String getModId() {
            return this.modId;
        }

        public Type getType() {
            return this.ticketType;
        }

        public ImmutableSet getChunkList() {
            return ImmutableSet.copyOf(this.requestedChunks);
        }
    }

    public static enum Type {
        NORMAL,
        ENTITY;

    }

    public static interface PlayerOrderedLoadingCallback
    extends LoadingCallback {
        public ListMultimap<String, Ticket> playerTicketsLoaded(ListMultimap<String, Ticket> var1, yc var2);
    }

    public static interface OrderedLoadingCallback
    extends LoadingCallback {
        public List<Ticket> ticketsLoaded(List<Ticket> var1, yc var2, int var3);
    }

    public static interface LoadingCallback {
        public void ticketsLoaded(List<Ticket> var1, yc var2);
    }
}

