/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    public static final String DUNGEON_CHEST = "dungeonChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    ArrayList<kw> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ChestGenHooks.addInfo(MINESHAFT_CORRIDOR, acp.a, 3, 7);
        ChestGenHooks.addInfo(PYRAMID_DESERT_CHEST, adt.i, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_CHEST, adu.l, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_DISPENSER, adu.m, 2, 2);
        ChestGenHooks.addInfo(STRONGHOLD_CORRIDOR, aee.a, 2, 4);
        ChestGenHooks.addInfo(STRONGHOLD_LIBRARY, aei.b, 1, 5);
        ChestGenHooks.addInfo(STRONGHOLD_CROSSING, aen.c, 1, 5);
        ChestGenHooks.addInfo(VILLAGE_BLACKSMITH, afo.a, 3, 9);
        ChestGenHooks.addInfo(BONUS_CHEST, in.S, 10, 10);
        ur book = new ur(up.bW, 1, 0);
        kw tmp = new kw(book, 1, 1, 1);
        ChestGenHooks.getInfo(MINESHAFT_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_DESERT_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_JUNGLE_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_LIBRARY).addItem(new kw(book, 1, 5, 2));
        ChestGenHooks.getInfo(STRONGHOLD_CROSSING).addItem(tmp);
        ChestGenHooks d2 = new ChestGenHooks(DUNGEON_CHEST);
        d2.countMin = 8;
        d2.countMax = 8;
        chestInfo.put(DUNGEON_CHEST, d2);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.aA), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.o), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.U), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.T), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.M), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.K), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.aw), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.at), 1, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.aC), 50, 1, 4);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.bX), 5, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.bY), 5, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, new ur(up.aW, 1, 3), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d2, book, 100, 1, 1);
    }

    static void addDungeonLoot(ChestGenHooks dungeon, ur item, int weight, int min, int max) {
        dungeon.addItem(new kw(item, min, max, weight));
    }

    private static void addInfo(String category, kw[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static ur[] generateStacks(Random rand, ur source, int min, int max) {
        ur[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new ur[]{};
        } else if (count > source.b().k()) {
            ret = new ur[count];
            for (int x2 = 0; x2 < count; ++x2) {
                ret[x2] = source.l();
                ret[x2].a = 1;
            }
        } else {
            ret = new ur[]{source.l()};
            ret[0].a = count;
        }
        return ret;
    }

    public static kw[] getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, kw item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ur item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static ur getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, kw[] items, int min, int max) {
        this(category);
        for (kw item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(kw item) {
        this.contents.add(item);
    }

    public void removeItem(ur item) {
        Iterator<kw> itr = this.contents.iterator();
        while (itr.hasNext()) {
            kw cont = itr.next();
            if (!item.a(cont.b) && (item.j() != -1 || item.c != cont.b.c)) continue;
            itr.remove();
        }
    }

    public kw[] getItems(Random rnd) {
        ArrayList<kw> ret = new ArrayList<kw>();
        for (kw orig : this.contents) {
            kw n2;
            up item = orig.b.b();
            if (item == null || (n2 = item.getChestGenBase(this, rnd, orig)) == null) continue;
            ret.add(n2);
        }
        return ret.toArray(new kw[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public ur getOneItem(Random rand) {
        kv[] items = this.getItems(rand);
        kw item = (kw)ku.a(rand, items);
        ur[] stacks = ChestGenHooks.generateStacks(rand, item.b, item.c, item.d);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

