/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ConfigFile;
import codechicken.core.ConfigTag;
import codechicken.core.PacketCustom;
import codechicken.core.ServerUtils;
import codechicken.nei.ItemHash;
import codechicken.nei.PlayerSave;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class NEIServerConfig {
    public static HashMap playerSaves = new HashMap();
    public static HashMap bannedblocks = new HashMap();
    public static ConfigFile serverConfig = new ConfigFile(new File(CommonUtils.getMinecraftDir(), "config/NEIServer.cfg")).setComment("NEI Server Permissions : Names are Comma (,) separated : ALL, OP and NONE are special names");
    public static File worldSaveFile;
    public static File worldSaveDir;
    public static bq worldCompound;
    private static MinecraftServer server;

    public static void load(yc world) {
        if (MinecraftServer.D() == server) {
            return;
        }
        System.out.println("Loading NEI");
        server = MinecraftServer.D();
        NEIServerConfig.initDefaults();
        NEIServerConfig.loadBannedBlocks();
        NEIServerConfig.loadSavedConfig(world);
    }

    private static void loadSavedConfig(yc world) {
        try {
            worldSaveDir = CommonUtils.getWorldBaseSaveLocation((yc)world);
            worldSaveFile = new File(worldSaveDir, "NEI.dat");
            if (!worldSaveFile.getParentFile().exists()) {
                worldSaveFile.getParentFile().mkdirs();
            }
            if (!worldSaveFile.exists()) {
                worldSaveFile.createNewFile();
            }
            if (worldSaveFile.length() == 0L) {
                worldCompound = new bq();
            } else {
                DataInputStream din = new DataInputStream(new FileInputStream(worldSaveFile));
                worldCompound = (bq)cd.b((DataInput)din);
                din.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDefaults() {
        serverConfig.setNewLineMode(1);
        serverConfig.getTag("permissions").useBraces();
        serverConfig.getTag("permissions").setComment("List of players who can use these features. :Eg. time=CodeChicken, Friend1");
        serverConfig.getTag("BannedBlocks").useBraces();
        serverConfig.getTag("BannedBlocks").setComment("List of players who can use these blocks. :Anyone not listed here will not have these blocks appear in their item panel.:format is {itemID}::{itemDamage}:Eg. 12::5=CodeChicken, Friend1");
        NEIServerConfig.setDefaultFeature("time", new String[0]);
        NEIServerConfig.setDefaultFeature("rain", new String[0]);
        NEIServerConfig.setDefaultFeature("heal", new String[0]);
        NEIServerConfig.setDefaultFeature("magnet", new String[0]);
        NEIServerConfig.setDefaultFeature("creative", new String[0]);
        NEIServerConfig.setDefaultFeature("enchant", new String[0]);
        NEIServerConfig.setDefaultFeature("save-state", new String[0]);
        NEIServerConfig.setDefaultFeature("item", new String[0]);
        NEIServerConfig.setDefaultFeature("delete", new String[0]);
        NEIServerConfig.setDefaultFeature("notify-item", "CONSOLE, OP");
        serverConfig.getTag("BannedBlocks." + amq.C.cm + ":0").setDefaultValue("NONE");
    }

    private static void setDefaultFeature(String featurename, String ... names) {
        if (names.length == 0) {
            names = new String[]{"OP"};
        }
        String list = "";
        int i = 0;
        while (i < names.length) {
            if (i >= 1) {
                list = String.valueOf(list) + ", ";
            }
            list = String.valueOf(list) + names[i];
            ++i;
        }
        serverConfig.getTag("permissions." + featurename).setDefaultValue(list);
    }

    public static boolean canPlayerUseFeature(String playername, String featurename) {
        return NEIServerConfig.isPlayerInList(playername, NEIServerConfig.getPlayerList("permissions." + featurename), true);
    }

    public static boolean isPlayerInList(String playername, HashSet list, boolean allowCards) {
        if (playername.equals("CONSOLE")) {
            return list.contains(playername);
        }
        playername = playername.toLowerCase();
        if (allowCards) {
            if (list.contains("ALL")) {
                return true;
            }
            if ((ServerUtils.isPlayerOP((String)playername) || ServerUtils.isPlayerOwner((String)playername)) && list.contains("OP")) {
                return true;
            }
        }
        return list.contains(playername);
    }

    public static boolean isPropertyDisabled(int dim, String name) {
        return NEIServerConfig.getDimCompound(dim).n("disabled" + name);
    }

    private static bq getDimCompound(int dim) {
        if (!worldCompound.b("dim" + dim)) {
            worldCompound.a("dim" + dim, new bq());
        }
        return worldCompound.l("dim" + dim);
    }

    public static void setPropertyDisabled(int dim, String name, boolean disable) {
        NEIServerConfig.getDimCompound(dim).a("disabled" + name, disable);
        NEIServerConfig.saveWorldCompound();
    }

    private static void saveWorldCompound() {
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(worldSaveFile));
            cd.a((cd)worldCompound, (DataOutput)dout);
            dout.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HashSet getPlayerList(String tag) {
        String[] list = serverConfig.getTag(tag).getValue("").replace(" ", "").split(",");
        return new HashSet<String>(Arrays.asList(list));
    }

    public static void addPlayerToList(String playername, String tag) {
        HashSet list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.add(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    public static void remPlayerFromList(String playername, String tag) {
        HashSet list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.remove(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    private static void savePlayerList(String tag, Collection list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append((String)iterator.next());
            ++i;
        }
        serverConfig.getTag(tag).setValue(sb.toString());
    }

    private static void loadBannedBlocks() {
        ConfigTag banTag = serverConfig.getTag("BannedBlocks");
        for (Map.Entry entry : banTag.childtags.entrySet()) {
            String ident = (String)entry.getKey();
            String[] num = ident.split(":");
            ItemHash hash = num.length == 1 ? new ItemHash(Integer.parseInt(num[0]), -1) : new ItemHash(Integer.parseInt(num[0]), Integer.parseInt(num[1]));
            bannedblocks.put(hash, NEIServerConfig.getPlayerList(((ConfigTag)entry.getValue()).qualifiedname));
        }
    }

    public static PlayerSave forPlayer(String username) {
        return (PlayerSave)playerSaves.get(username);
    }

    public static void loadPlayer(qx player) {
        System.out.println("Loading Player: " + player.bR);
        playerSaves.put(player.bR, new PlayerSave(player.bR, new File(worldSaveDir, "NEI/players")));
    }

    public static void unloadPlayer(qx player) {
        System.out.println("Unloading Player: " + player.bR);
        PlayerSave playerSave = (PlayerSave)playerSaves.remove(player.bR);
        if (playerSave != null) {
            playerSave.save();
        }
    }

    public static boolean authenticatePacket(iq sender, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "item");
            }
            case 10: 
            case 11: {
                return true;
            }
            case 5: 
            case 12: {
                return true;
            }
            case 6: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "magnet");
            }
            case 7: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "time");
            }
            case 4: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "delete");
            }
            case 8: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "heal");
            }
            case 9: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "rain");
            }
            case 14: 
            case 23: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "creative");
            }
            case 21: 
            case 22: {
                return NEIServerConfig.canPlayerUseFeature(sender.bR, "creative");
            }
        }
        return true;
    }
}

