/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class SimpleProperties {
    public HashMap propertyMap = new HashMap();
    public File propertyFile;
    public boolean saveOnChange = false;
    private boolean loading = false;

    public SimpleProperties(File file, boolean saveOnChange) {
        this.propertyFile = file;
        this.saveOnChange = saveOnChange;
    }

    public void load() {
        this.clear();
        this.loading = true;
        try {
            String read;
            BufferedReader reader = new BufferedReader(new FileReader(this.propertyFile));
            while ((read = reader.readLine()) != null) {
                int equalIndex = read.indexOf(61);
                if (equalIndex == -1) continue;
                this.setProperty(read.substring(0, equalIndex), read.substring(equalIndex + 1));
            }
            reader.close();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
        }
        this.loading = false;
    }

    public void save() {
        try {
            PrintStream writer = new PrintStream(this.propertyFile);
            for (Map.Entry entry : this.propertyMap.entrySet()) {
                writer.println(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
            }
            writer.close();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
        }
    }

    public void clear() {
        this.propertyMap.clear();
    }

    public boolean hasProperty(String key) {
        return this.propertyMap.containsKey(key);
    }

    public void removeProperty(String key) {
        if (this.propertyMap.remove(key) != null && this.saveOnChange && !this.loading) {
            this.save();
        }
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setProperty(String key, String value) {
        this.propertyMap.put(key, value);
        if (this.saveOnChange && !this.loading) {
            this.save();
        }
    }

    public int getProperty(String property, int defaultvalue) {
        try {
            return Integer.parseInt(this.getProperty(property, Integer.toString(defaultvalue)));
        }
        catch (NumberFormatException nfe) {
            return defaultvalue;
        }
    }

    public boolean getProperty(String property, boolean defaultvalue) {
        try {
            return Boolean.parseBoolean(this.getProperty(property, Boolean.toString(defaultvalue)));
        }
        catch (NumberFormatException nfe) {
            return defaultvalue;
        }
    }

    public String getProperty(String property, String defaultvalue) {
        String value = (String)this.propertyMap.get(property);
        if (value == null) {
            this.setProperty(property, defaultvalue);
            return defaultvalue;
        }
        return value;
    }

    public String getProperty(String property) {
        return (String)this.propertyMap.get(property);
    }
}

