/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.ConfigFile;
import codechicken.core.ConfigTag;
import codechicken.core.asm.ASMHelper;
import codechicken.core.asm.CodeChickenCorePlugin;
import codechicken.core.asm.InstructionComparator;
import codechicken.core.asm.ObfuscationMappings;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.File;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TweakTransformer
implements IClassTransformer,
Opcodes {
    private static HashMultimap altercators = HashMultimap.create();
    public static ConfigTag tweaks;

    public static void load() {
        ConfigFile config;
        File cfgDir = new File(CodeChickenCorePlugin.minecraftDir + "/config");
        if (!cfgDir.exists()) {
            cfgDir.mkdirs();
        }
        if (!(tweaks = (config = new ConfigFile(new File(cfgDir, "CodeChickenCore.cfg")).setComment("CodeChickenCore configuration file.")).getTag("tweaks").setComment("Various tweaks that can be applied to game mechanics.").useBraces()).getTag("persistantLava").setComment("Set to false to make lava fade away like water if all the source blocks are destroyed").getBooleanValue(true)) {
            ObfuscationMappings.ClassMapping blockFlowing = new ObfuscationMappings.ClassMapping("aky");
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping(blockFlowing.s_class, new ObfuscationMappings.DescriptorMapping("amq", "b", "(Lyc;IIILjava/util/Random;)V"))){

                @Override
                public void alter(MethodNode mv) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new VarInsnNode(21, 6));
                    needle.add((AbstractInsnNode)new VarInsnNode(54, -1));
                    needle.add((AbstractInsnNode)new InsnNode(3));
                    needle.add((AbstractInsnNode)new VarInsnNode(54, 8));
                    List lists = InstructionComparator.insnListFindL(mv.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    System.out.println("Removing\n" + ASMHelper.printInsnList(subsection));
                    AbstractInsnNode insn = subsection.first;
                    while (true) {
                        AbstractInsnNode next = insn.getNext();
                        mv.instructions.remove(insn);
                        if (insn == subsection.last) break;
                        insn = next;
                    }
                }
            });
        }
        if (tweaks.getTag("environmentallyFriendlyCreepers").setComment("If set to true, creepers will not destroy landscape. (A version of mobGreifing setting just for creepers)").getBooleanValue(false)) {
            final ObfuscationMappings.ClassMapping entityCreeper = new ObfuscationMappings.ClassMapping("qc");
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping(entityCreeper.s_class, new ObfuscationMappings.DescriptorMapping("lq", "j_", "()V"))){

                @Override
                public void alter(MethodNode mv) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    needle.add((AbstractInsnNode)new ObfuscationMappings.DescriptorMapping(entityCreeper.s_class, new ObfuscationMappings.DescriptorMapping("lq", "p", "Lyc;")).toFieldInsn(180));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "yc", "L", "()Lxz;"));
                    needle.add((AbstractInsnNode)new LdcInsnNode((Object)"mobGriefing"));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "xz", "b", "(Ljava/lang/String;)Z"));
                    List lists = InstructionComparator.insnListFindL(mv.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    System.out.println("Replacing\n" + ASMHelper.printInsnList(subsection) + "with ICONST_0 ");
                    mv.instructions.insertBefore(subsection.first, (AbstractInsnNode)new InsnNode(3));
                    AbstractInsnNode insn = subsection.first;
                    while (true) {
                        AbstractInsnNode next = insn.getNext();
                        mv.instructions.remove(insn);
                        if (insn == subsection.last) break;
                        insn = next;
                    }
                }
            });
        }
    }

    private static void alterMethod(ASMHelper.MethodAltercator ma) {
        altercators.put((Object)ma.method.javaClass(), (Object)ma);
    }

    public byte[] transform(String name, byte[] bytes) {
        bytes = ASMHelper.alterMethods(name, bytes, altercators);
        return bytes;
    }
}

