/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.BlockCoord;
import codechicken.core.inventory.InventoryCopy;
import codechicken.core.inventory.InventoryRange;
import codechicken.core.inventory.InventoryUtils;
import net.minecraftforge.common.ForgeDirection;

public class InventorySensor {
    public static int[] adjacent;
    private InventoryHash[] invs;
    private yc world;
    private BlockCoord pos;
    private boolean changed;

    static {
        int[] nArray = new int[7];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 5;
        adjacent = nArray;
    }

    public InventorySensor(yc world, int x2, int y2, int z2, int[] sides) {
        this.world = world;
        this.pos = new BlockCoord(x2, y2, z2);
        this.invs = new InventoryHash[sides.length];
        int i = 0;
        while (i < this.invs.length) {
            this.invs[i] = new InventoryHash(sides[i]);
            ++i;
        }
    }

    public boolean changed() {
        if (this.changed) {
            return true;
        }
        if (this.checkChange()) {
            this.changed = true;
        }
        return this.changed;
    }

    private boolean checkChange() {
        int i = 0;
        while (i < this.invs.length) {
            InventoryHash hash = this.invs[i];
            la inv = InventorySensor.getInventory(this.world, this.pos.x, this.pos.y, this.pos.z, hash.side);
            if (hash.inv == null ? inv != null : !InventoryUtils.inventoriesEqual(inv, hash.inv.inv)) {
                return true;
            }
            if (inv != null) {
                InventoryCopy copyInv = hash.inv;
                int j = 0;
                while (j < copyInv.items.length) {
                    if (hash.inv.accessible[j] && !InventoryUtils.areStacksIdentical(copyInv.a(j), inv.a(j))) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public void reset() {
        int i = 0;
        while (i < this.invs.length) {
            InventoryHash hash = this.invs[i];
            la inv = InventorySensor.getInventory(this.world, this.pos.x, this.pos.y, this.pos.z, hash.side);
            if (hash.inv == null ? inv != null : inv != hash.inv.inv) {
                if (inv == null) {
                    hash.inv = null;
                } else {
                    hash.inv = new InventoryCopy(inv);
                    if (hash.side >= 0) {
                        hash.inv.open(new InventoryRange(inv, ForgeDirection.getOrientation((int)hash.side).getOpposite()));
                    } else {
                        hash.inv.open(new InventoryRange(inv, 0, inv.k_()));
                    }
                }
            }
            if (hash.inv != null) {
                InventoryCopy copyInv = hash.inv;
                int j = 0;
                while (j < copyInv.items.length) {
                    ur stack = inv.a(j);
                    if (stack != null) {
                        stack = stack.l();
                    }
                    copyInv.a(j, stack);
                    ++j;
                }
            }
            ++i;
        }
        this.changed = false;
    }

    private static la getInventory(yc world, int x2, int y2, int z2, int side) {
        if (side >= 0) {
            ForgeDirection fside = ForgeDirection.getOrientation((int)side);
            x2 += fside.offsetX;
            y2 += fside.offsetY;
            z2 += fside.offsetZ;
        }
        return InventoryUtils.getInventory(world, x2, y2, z2);
    }

    private static class InventoryHash {
        public InventoryCopy inv;
        public int side;

        public InventoryHash(int loc) {
            this.side = loc;
        }
    }
}

