/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.Quat;
import codechicken.core.Vector3;
import codechicken.core.vec.ITransformation;
import codechicken.core.vec.Matrix4;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class Rotation
implements ITransformation {
    private double angle;
    private Vector3 axis;
    private Vector3 point;
    private Vector3 negate;
    private Quat quat;

    public Rotation(double angle, Vector3 axis, Vector3 point) {
        this.angle = angle;
        this.axis = axis;
        this.point = point;
    }

    public Rotation(double angle, Vector3 axis) {
        this(angle, axis, null);
    }

    @Override
    public void transform(Vector3 vec) {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(vec, this.angle);
        }
        if (this.point == null) {
            vec.rotate(this.quat);
        } else {
            vec.subtract(this.point).rotate(this.quat).add(this.point);
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        if (this.point == null) {
            mat.rotate(this.angle, this.axis);
        } else {
            if (this.negate == null) {
                this.negate = this.point.copy().negate();
            }
            mat.translate(this.point);
            mat.rotate(this.angle, this.axis);
            mat.translate(this.negate);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void glRotate() {
        if (this.point == null) {
            GL11.glRotatef((float)((float)this.angle * 57.2958f), (float)((float)this.axis.x), (float)((float)this.axis.y), (float)((float)this.axis.z));
        } else {
            GL11.glTranslated((double)this.point.x, (double)this.point.y, (double)this.point.z);
            GL11.glRotatef((float)((float)this.angle * 57.2958f), (float)((float)this.axis.x), (float)((float)this.axis.y), (float)((float)this.axis.z));
            GL11.glTranslated((double)(-this.point.x), (double)(-this.point.y), (double)(-this.point.z));
        }
    }
}

