/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.Vector3;
import codechicken.core.vec.ITransformation;
import codechicken.core.vec.Matrix4;

public class Scale
implements ITransformation {
    private Vector3 factor;
    private Vector3 point;
    private Vector3 negate;

    public Scale(Vector3 factor, Vector3 point) {
        this.factor = factor;
        this.point = point;
    }

    public Scale(Vector3 factor) {
        this(factor, null);
    }

    @Override
    public void transform(Vector3 vec) {
        if (this.point == null) {
            vec.multiply(this.factor);
        } else {
            vec.subtract(this.point).multiply(this.factor).add(this.point);
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        if (this.point == null) {
            mat.scale(this.factor);
        } else {
            if (this.negate == null) {
                this.negate = this.point.copy().negate();
            }
            mat.translate(this.point);
            mat.scale(this.factor);
            mat.translate(this.negate);
        }
    }
}

