/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.plugins.redpower;

import codechicken.nei.ItemRange;
import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.plugins.redpower.AlloyFurnaceOverlayHandler;
import codechicken.nei.plugins.redpower.AlloyFurnaceRecipeHandler;
import codechicken.nei.plugins.redpower.MicroRecipeHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.packager.Packager;
import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.RedPowerCompat;
import com.eloraam.redpower.RedPowerControl;
import com.eloraam.redpower.RedPowerLighting;
import com.eloraam.redpower.RedPowerLogic;
import com.eloraam.redpower.RedPowerMachine;
import com.eloraam.redpower.RedPowerWorld;
import com.eloraam.redpower.base.GuiAdvBench;
import com.eloraam.redpower.base.GuiAlloyFurnace;
import com.eloraam.redpower.base.ItemHandsaw;
import com.eloraam.redpower.machine.GuiBlueFurnace;
import java.util.ArrayList;

@Packager(getName="NEI_RedPowerPlugin", getVersion="1.4.3.1", getClasses={"codechicken.nei.plugins.redpower"}, getBaseDirectories={"NEI_Plugins"})
public class NEIRedPowerConfig
implements IConfigureNEI {
    public static boolean wiring;
    public static boolean logic;
    public static boolean control;
    public static boolean lighting;
    public static boolean world;
    public static boolean machine;
    public static boolean base;
    public static boolean compat;
    final int id;
    private ArrayList validmicrotypes;

    public NEIRedPowerConfig() {
        this.id = RedPowerBase.blockMicro.cm;
        this.validmicrotypes = new ArrayList();
    }

    public void loadConfig() {
        this.checkInstalled();
        if (!base) {
            return;
        }
        this.loadDamageRanges();
        this.loadCoverSubSets();
        this.loadSaws();
        this.loadSubSets();
        API.registerRecipeHandler((ICraftingHandler)new AlloyFurnaceRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AlloyFurnaceRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MicroRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MicroRecipeHandler());
        API.registerGuiOverlay(GuiAlloyFurnace.class, (String)"alloy");
        API.registerGuiOverlay(GuiAdvBench.class, (String)"crafting", (int)23, (int)12);
        API.registerGuiOverlayHandler(GuiAlloyFurnace.class, (IOverlayHandler)new AlloyFurnaceOverlayHandler(), (String)"alloy");
        API.registerGuiOverlayHandler(GuiAdvBench.class, (IOverlayHandler)new DefaultOverlayHandler(23, 12), (String)"crafting");
        if (machine) {
            weakDependancy_Machine.registerGuiOverlay();
        }
    }

    private void loadSaws() {
        ArrayList<up> saws = new ArrayList<up>();
        up[] upArray = up.e;
        int n = up.e.length;
        int n2 = 0;
        while (n2 < n) {
            up item = upArray[n2];
            if (item instanceof ItemHandsaw) {
                saws.add(item);
            }
            ++n2;
        }
        MicroRecipeHandler.saws = new ItemHandsaw[saws.size()];
        int i = 0;
        while (i < saws.size()) {
            MicroRecipeHandler.saws[i] = (ItemHandsaw)saws.get(i);
            ++i;
        }
        API.addSetRange((String)"RedPower.Tools.Saws", (MultiItemRange)new MultiItemRange().add(saws));
        API.addSetRange((String)"Items.Tools.Saws", (MultiItemRange)new MultiItemRange().add(saws));
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("net.minecraft.src." + name);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
    }

    private void checkInstalled() {
        wiring = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerWiring");
        logic = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerLogic");
        control = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerControl");
        lighting = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerLighting");
        world = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerWorld");
        machine = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerMachine");
        base = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerBase");
        compat = NEIRedPowerConfig.classExists("com.eloraam.redpower.RedPowerCompat");
    }

    private void loadSubSets() {
        MultiItemRange allitems = new MultiItemRange();
        MultiItemRange allblocks = new MultiItemRange();
        if (wiring) {
            allitems.add(RedPowerBase.itemHandsawDiamond);
            allitems.add(RedPowerBase.itemHandsawIron);
            API.addSetRange((String)"RedPower.Wiring", (MultiItemRange)new MultiItemRange().add((amq)RedPowerBase.blockMicro, 256, 256));
            API.addSetRange((String)"RedPower.Wiring.Insulated Wire", (MultiItemRange)new MultiItemRange().add((amq)RedPowerBase.blockMicro, 512, 527));
            API.addSetRange((String)"RedPower.Wiring.Bundled Cable", (MultiItemRange)new MultiItemRange().add((amq)RedPowerBase.blockMicro, 768, 784));
        }
        if (wiring || machine) {
            MultiItemRange alloys = new MultiItemRange();
            if (wiring) {
                alloys.add((up)RedPowerBase.itemAlloy, 0, 0);
            }
            if (machine) {
                alloys.add((up)RedPowerBase.itemAlloy, 1, 2);
            }
            alloys.add((up)RedPowerBase.itemAlloy, 3, 4);
            if (machine) {
                alloys.add((up)RedPowerBase.itemAlloy, 5, 5);
            }
            if (wiring) {
                alloys.add((up)RedPowerBase.itemAlloy, 6, 6);
            }
            if (machine) {
                alloys.add((up)RedPowerBase.itemAlloy, 7, 7);
            }
            API.addSetRange((String)"RedPower.Alloys", (MultiItemRange)alloys);
            allitems.add(alloys);
            allblocks.add((amq)RedPowerBase.blockMicro);
        }
        if (logic || machine) {
            API.addToRange((String)"RedPower.Tools.Other", (MultiItemRange)new MultiItemRange().add((up)RedPowerBase.itemScrewdriver));
            API.addToRange((String)"Items.Tools.Other", (MultiItemRange)new MultiItemRange().add((up)RedPowerBase.itemScrewdriver));
            allitems.add((up)RedPowerBase.itemScrewdriver);
        }
        if (world) {
            weakDependancy_World.loadSubsetsWorld(allitems, allblocks);
        }
        if (lighting) {
            weakDependancy_Lighting.loadSubsetsLighting(allitems, allblocks);
        }
        if (machine) {
            weakDependancy_Machine.loadSubsetsMachine(allitems, allblocks);
        }
        if (logic) {
            weakDependancy_Logic.loadSubsetsLogic(allitems, allblocks);
        }
        if (control) {
            weakDependancy_Control.loadSubsetsControl(allitems, allblocks);
        }
        if (compat) {
            weakDependancy_Compat.loadSubsetsCompat(allitems, allblocks);
        }
        if (base) {
            MultiItemRange appliances = new MultiItemRange();
            appliances.add((amq)RedPowerBase.blockAppliance, 0, 0);
            appliances.add((amq)RedPowerBase.blockAppliance, 2, 3);
            API.addSetRange((String)"RedPower.Appliances", (MultiItemRange)appliances);
            allblocks.add(appliances);
            allitems.add(RedPowerBase.itemCanvas);
            allitems.add(RedPowerBase.itemBag);
            allitems.add(RedPowerBase.itemNuggetCopper);
            allitems.add(RedPowerBase.itemNuggetIron);
            allitems.add(RedPowerBase.itemNuggetSilver);
            allitems.add(RedPowerBase.itemNuggetTin);
            allitems.add(RedPowerBase.itemPlanBlank);
            allitems.add(RedPowerBase.itemPlanFull);
            API.addSetRange((String)"RedPower.Items", (MultiItemRange)allitems);
            allblocks.add((amq)RedPowerBase.blockMultiblock);
            API.addSetRange((String)"RedPower.Blocks", (MultiItemRange)allblocks);
        }
    }

    private void loadDamageRanges() {
        if (!wiring && !machine) {
            return;
        }
        up item = up.e[this.id];
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int startrange = -1;
        int i = 0;
        while (i < 32000) {
            ur itemstack = new ur(item, item.k(), i);
            String name = GuiContainerManager.itemDisplayNameShort((ur)itemstack);
            if (!name.endsWith("Unnamed") && !name.endsWith("null")) {
                if (startrange == -1) {
                    startrange = i;
                }
            } else if (startrange != -1) {
                ranges.add(new int[]{startrange, i - 1});
                startrange = -1;
            }
            ++i;
        }
        API.setItemDamageVariants((int)RedPowerBase.blockMicro.cm, ranges);
    }

    private void loadCoverSubSets() {
        if (!wiring) {
            return;
        }
        int startrange = -1;
        int i = 0;
        while (i < 256) {
            ur itemstack = new ur(this.id, 1, i);
            String name = GuiContainerManager.itemDisplayNameShort((ur)itemstack);
            if (!name.endsWith("Unnamed")) {
                if (startrange == -1) {
                    startrange = i;
                }
            } else if (startrange != -1) {
                this.validmicrotypes.add(new ItemRange(this.id, startrange, i - 1));
                startrange = -1;
            }
            ++i;
        }
        this.registerMicroSet("MicroBlocks.Cover", 0);
        this.registerMicroSet("MicroBlocks.Panel", 16);
        this.registerMicroSet("MicroBlocks.Slab", 17);
        this.registerMicroSet("MicroBlocks.Hollow Cover", 24);
        this.registerMicroSet("MicroBlocks.Hollow Panel", 25);
        this.registerMicroSet("MicroBlocks.Hollow Slab", 26);
        this.registerMicroSet("MicroBlocks.Cover Corner", 18);
        this.registerMicroSet("MicroBlocks.Panel Corner", 19);
        this.registerMicroSet("MicroBlocks.Slab Corner", 20);
        this.registerMicroSet("MicroBlocks.Cover Strip", 21);
        this.registerMicroSet("MicroBlocks.Panel Strip", 22);
        this.registerMicroSet("MicroBlocks.Slab Strip", 23);
        this.registerMicroSet("MicroBlocks.Triple Cover", 27);
        this.registerMicroSet("MicroBlocks.Cover Slab", 28);
        this.registerMicroSet("MicroBlocks.Triple Panel", 29);
        this.registerMicroSet("MicroBlocks.Anticover", 30);
        this.registerMicroSet("MicroBlocks.Hollow Triple Cover", 31);
        this.registerMicroSet("MicroBlocks.Hollow Cover Slab", 32);
        this.registerMicroSet("MicroBlocks.Hollow Triple Panel", 33);
        this.registerMicroSet("MicroBlocks.Hollow Anticover", 34);
        this.registerMicroSet("MicroBlocks.Triple Cover Corner", 35);
        this.registerMicroSet("MicroBlocks.Cover Slab Corner", 36);
        this.registerMicroSet("MicroBlocks.Triple Panel Corner", 37);
        this.registerMicroSet("MicroBlocks.Anticover Corner", 38);
        this.registerMicroSet("MicroBlocks.Triple Cover Strip", 39);
        this.registerMicroSet("MicroBlocks.Cover Slab Strip", 40);
        this.registerMicroSet("MicroBlocks.Triple Panel Strip", 41);
        this.registerMicroSet("MicroBlocks.Anticover Strip", 42);
        this.registerMicroSet("MicroBlocks.Post", 43);
        this.registerMicroSet("MicroBlocks.Pillar", 44);
        this.registerMicroSet("MicroBlocks.Column", 45);
        this.registerMicroSet("Wiring.Jacketed Wire", 64);
        this.registerMicroSet("Wiring.Jacketed Cable", 65);
        this.registerMicroSet("Bluetricity.Jacketed Bluewire", 66);
    }

    private void registerMicroSet(String RPName, int microID) {
        MultiItemRange shiftedmicrotypes = new MultiItemRange();
        for (ItemRange range : this.validmicrotypes) {
            shiftedmicrotypes.add(this.id, range.firstDamage + microID * 256, range.lastDamage + microID * 256);
        }
        API.addSetRange((String)("RedPower." + RPName), (MultiItemRange)shiftedmicrotypes);
        API.getRangeTag((String)("RedPower." + RPName)).setPosition(microID);
    }

    public String getName() {
        return "RedPower";
    }

    public String getVersion() {
        return "1.1";
    }

    private static class weakDependancy_Compat {
        private weakDependancy_Compat() {
        }

        public static void loadSubsetsCompat(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange compatitems = new MultiItemRange();
            MultiItemRange compatblocks = new MultiItemRange();
            compatblocks.add((amq)RedPowerCompat.blockMachineCompat);
            compatitems.add((up)RedPowerCompat.itemCompatParts);
            API.addSetRange((String)"RedPower.Compatibility", (MultiItemRange)new MultiItemRange().add(compatblocks).add(compatitems));
            allblocks.add(compatblocks);
            allitems.add(compatitems);
        }
    }

    private static class weakDependancy_Control {
        private weakDependancy_Control() {
        }

        public static void loadSubsetsControl(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange controlitems = new MultiItemRange();
            MultiItemRange controlblocks = new MultiItemRange();
            controlblocks.add((amq)RedPowerControl.blockBackplane);
            controlblocks.add((amq)RedPowerControl.blockFlatPeripheral);
            controlblocks.add((amq)RedPowerControl.blockPeripheral);
            controlblocks.add((amq)RedPowerControl.blockPeripheral);
            controlitems.add((up)RedPowerControl.itemDisk);
            controlblocks.add((amq)RedPowerBase.blockMicro, 3072, 3072);
            API.addSetRange((String)"RedPower.Control", (MultiItemRange)new MultiItemRange().add(controlblocks).add(controlitems));
            allblocks.add(controlblocks);
            allitems.add(controlitems);
        }
    }

    private static class weakDependancy_Lighting {
        private weakDependancy_Lighting() {
        }

        public static void loadSubsetsLighting(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange lightingBlocks = new MultiItemRange();
            lightingBlocks.add((amq)RedPowerLighting.blockLampOff);
            lightingBlocks.add((amq)RedPowerLighting.blockInvLampOn);
            lightingBlocks.add((amq)RedPowerLighting.blockShapedLamp);
            API.addSetRange((String)"RedPower.Lighting", (MultiItemRange)lightingBlocks);
            allblocks.add(lightingBlocks);
            API.addSetRange((String)"RedPower.Lumar", (MultiItemRange)new MultiItemRange().add((up)RedPowerBase.itemLumar));
            allitems.add((up)RedPowerBase.itemLumar);
            API.hideItem((int)RedPowerLighting.blockLampOn.cm);
            API.hideItem((int)RedPowerLighting.blockInvLampOff.cm);
        }
    }

    private static class weakDependancy_Logic {
        private weakDependancy_Logic() {
        }

        public static void loadSubsetsLogic(MultiItemRange allitems, MultiItemRange allblocks) {
            allblocks.add((amq)RedPowerLogic.blockLogic);
            allitems.add((up)RedPowerLogic.itemParts);
            MultiItemRange basic = new MultiItemRange();
            MultiItemRange timed = new MultiItemRange();
            MultiItemRange advanced = new MultiItemRange();
            MultiItemRange array = new MultiItemRange();
            MultiItemRange bundled = new MultiItemRange();
            basic.add((amq)RedPowerLogic.blockLogic, 256, 268);
            timed.add((amq)RedPowerLogic.blockLogic, 0, 2);
            timed.add((amq)RedPowerLogic.blockLogic, 768, 768);
            advanced.add((amq)RedPowerLogic.blockLogic, 269, 272);
            array.add((amq)RedPowerLogic.blockLogic, 512, 514);
            bundled.add((amq)RedPowerLogic.blockLogic, 1024, 1024);
            API.addSetRange((String)"RedPower.Logic.Basic", (MultiItemRange)basic);
            API.addSetRange((String)"RedPower.Logic.Timed", (MultiItemRange)timed);
            API.addSetRange((String)"RedPower.Logic.Advanced", (MultiItemRange)advanced);
            API.addSetRange((String)"RedPower.Logic.Array", (MultiItemRange)array);
            API.addSetRange((String)"RedPower.Logic.Bundled", (MultiItemRange)bundled);
            API.addSetRange((String)"RedPower.Logic.Parts", (MultiItemRange)new MultiItemRange().add((up)RedPowerLogic.itemParts));
        }
    }

    private static class weakDependancy_Machine {
        private weakDependancy_Machine() {
        }

        public static void loadSubsetsMachine(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange itemtransfer = new MultiItemRange();
            MultiItemRange fluidtransfer = new MultiItemRange();
            MultiItemRange tubes = new MultiItemRange();
            MultiItemRange pipes = new MultiItemRange();
            MultiItemRange machineparts = new MultiItemRange();
            itemtransfer.add((amq)RedPowerMachine.blockMachine, 0, 5);
            itemtransfer.add((amq)RedPowerMachine.blockMachine, 8, 10);
            itemtransfer.add((amq)RedPowerMachine.blockMachine, 12, 15);
            itemtransfer.add((amq)RedPowerMachine.blockMachine2, 0, 1);
            itemtransfer.add((amq)RedPowerMachine.blockMachinePanel, 2, 2);
            fluidtransfer.add((amq)RedPowerMachine.blockMachinePanel, 1, 1);
            fluidtransfer.add((amq)RedPowerMachine.blockMachinePanel, 3, 3);
            pipes.add((amq)RedPowerBase.blockMicro, 1792, 1792);
            tubes.add((amq)RedPowerBase.blockMicro, 2048, 2048);
            tubes.add((amq)RedPowerBase.blockMicro, 2304, 2304);
            tubes.add((amq)RedPowerBase.blockMicro, 2560, 2560);
            tubes.add((amq)RedPowerBase.blockMicro, 2816, 2816);
            machineparts.add(RedPowerBase.itemDrawplateDiamond);
            machineparts.add(RedPowerBase.itemFineCopper);
            machineparts.add(RedPowerBase.itemFineIron);
            machineparts.add(RedPowerBase.itemCopperCoil);
            machineparts.add(RedPowerBase.itemMotor);
            machineparts.add(RedPowerMachine.itemWoodSail);
            machineparts.add(RedPowerMachine.itemWoodTurbine);
            machineparts.add(RedPowerMachine.itemWoodWindmill);
            MultiItemRange bluetricity = new MultiItemRange();
            bluetricity.add((amq)RedPowerBase.blockMicro, 1280, 1280);
            bluetricity.add((amq)RedPowerBase.blockAppliance, 1, 1);
            bluetricity.add((amq)RedPowerBase.blockAppliance, 4, 4);
            bluetricity.add((amq)RedPowerMachine.blockMachine, 5, 8);
            bluetricity.add((amq)RedPowerMachine.blockMachine, 11, 11);
            bluetricity.add((amq)RedPowerMachine.blockMachinePanel, 0, 2);
            bluetricity.add((up)RedPowerMachine.itemVoltmeter);
            allitems.add((up)RedPowerMachine.itemVoltmeter);
            bluetricity.add(RedPowerMachine.itemBatteryEmpty);
            allitems.add(RedPowerMachine.itemBatteryEmpty);
            allitems.add(RedPowerMachine.itemBatteryPowered);
            MultiItemRange sonic = new MultiItemRange();
            sonic.add((up)RedPowerMachine.itemSonicDriver);
            API.addToRange((String)"RedPower.Tools.Other", (MultiItemRange)sonic);
            API.addToRange((String)"Items.Tools.Other", (MultiItemRange)sonic);
            allitems.add(sonic);
            bluetricity.add(sonic);
            MultiItemRange frames = new MultiItemRange();
            frames.add((amq)RedPowerMachine.blockMachine, 7, 7);
            frames.add((amq)RedPowerMachine.blockFrame);
            API.addSetRange((String)"RedPower.Machine.Frames", (MultiItemRange)frames);
            API.addSetRange((String)"RedPower.Machine.Item Transfer", (MultiItemRange)itemtransfer);
            API.addSetRange((String)"RedPower.Machine.Liquid Transfer", (MultiItemRange)fluidtransfer);
            API.addSetRange((String)"RedPower.Machine.Tubes", (MultiItemRange)tubes);
            API.addSetRange((String)"RedPower.Machine.Pipes", (MultiItemRange)pipes);
            API.addSetRange((String)"RedPower.Machine.Parts", (MultiItemRange)machineparts);
            API.addSetRange((String)"RedPower.Bluetricity", (MultiItemRange)bluetricity);
            allblocks.add((amq)RedPowerBase.blockAppliance);
            allblocks.add((amq)RedPowerMachine.blockMachinePanel);
            allblocks.add((amq)RedPowerMachine.blockMachine);
            MultiItemRange paintclean = new MultiItemRange();
            paintclean.add(RedPowerWorld.itemBrushDry);
            paintclean.add(RedPowerWorld.itemPaintCanEmpty);
            MultiItemRange brushes = new MultiItemRange();
            MultiItemRange cans = new MultiItemRange();
            brushes.add(RedPowerWorld.itemBrushDry);
            cans.add(RedPowerWorld.itemPaintCanEmpty);
            int i = 0;
            while (i < 16) {
                brushes.add(RedPowerWorld.itemBrushPaint[i]);
                cans.add((up)RedPowerWorld.itemPaintCanPaint[i]);
                ++i;
            }
            allitems.add(cans);
            allitems.add(brushes);
            API.addSetRange((String)"RedPower.Paint.Base", (MultiItemRange)paintclean);
            API.addSetRange((String)"RedPower.Paint.Cans", (MultiItemRange)cans);
            API.addSetRange((String)"RedPower.Paint.Brushes", (MultiItemRange)brushes);
        }

        public static void registerGuiOverlay() {
            API.registerGuiOverlay(GuiBlueFurnace.class, (String)"smelting", (int)11, (int)29);
        }
    }

    private static class weakDependancy_World {
        private weakDependancy_World() {
        }

        public static void loadSubsetsWorld(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange worlditems = new MultiItemRange();
            MultiItemRange sickles = new MultiItemRange();
            MultiItemRange picks = new MultiItemRange();
            MultiItemRange shovel = new MultiItemRange();
            MultiItemRange axe = new MultiItemRange();
            MultiItemRange hoe = new MultiItemRange();
            MultiItemRange sword = new MultiItemRange();
            sickles.add((up)RedPowerWorld.itemSickleWood);
            sickles.add((up)RedPowerWorld.itemSickleStone);
            sickles.add((up)RedPowerWorld.itemSickleIron);
            sickles.add((up)RedPowerWorld.itemSickleDiamond);
            sickles.add((up)RedPowerWorld.itemSickleGold);
            sickles.add((up)RedPowerWorld.itemSickleRuby);
            sickles.add((up)RedPowerWorld.itemSickleGreenSapphire);
            sickles.add((up)RedPowerWorld.itemSickleSapphire);
            worlditems.add(sickles);
            picks.add((up)RedPowerWorld.itemPickaxeRuby);
            picks.add((up)RedPowerWorld.itemPickaxeGreenSapphire);
            picks.add((up)RedPowerWorld.itemPickaxeSapphire);
            worlditems.add(picks);
            shovel.add((up)RedPowerWorld.itemShovelRuby);
            shovel.add((up)RedPowerWorld.itemShovelGreenSapphire);
            shovel.add((up)RedPowerWorld.itemShovelSapphire);
            worlditems.add(shovel);
            axe.add((up)RedPowerWorld.itemAxeRuby);
            axe.add((up)RedPowerWorld.itemAxeGreenSapphire);
            axe.add((up)RedPowerWorld.itemAxeSapphire);
            worlditems.add(axe);
            sword.add((up)RedPowerWorld.itemSwordRuby);
            sword.add((up)RedPowerWorld.itemSwordGreenSapphire);
            sword.add((up)RedPowerWorld.itemSwordSapphire);
            worlditems.add(sword);
            hoe.add((up)RedPowerWorld.itemHoeRuby);
            hoe.add((up)RedPowerWorld.itemHoeGreenSapphire);
            hoe.add((up)RedPowerWorld.itemHoeSapphire);
            worlditems.add(RedPowerWorld.itemHandsawGreenSapphire);
            worlditems.add(RedPowerWorld.itemHandsawRuby);
            worlditems.add(RedPowerWorld.itemHandsawSapphire);
            worlditems.add(hoe);
            MultiItemRange othertools = new MultiItemRange();
            othertools.add(RedPowerWorld.itemWoolCard);
            othertools.add((up)RedPowerWorld.itemAthame);
            worlditems.add(othertools);
            API.addToRange((String)"RedPower.Tools.Other", (MultiItemRange)othertools);
            API.addToRange((String)"Items.Tools.Other", (MultiItemRange)othertools);
            API.addSetRange((String)"RedPower.Tools.Sickles", (MultiItemRange)sickles);
            API.addSetRange((String)"Items.Tools.Sickles", (MultiItemRange)sickles);
            API.addSetRange((String)"RedPower.Tools.Pickaxes", (MultiItemRange)picks);
            API.addSetRange((String)"RedPower.Tools.Shovels", (MultiItemRange)shovel);
            API.addSetRange((String)"RedPower.Tools.Axes", (MultiItemRange)axe);
            API.addSetRange((String)"RedPower.Tools.Hoes", (MultiItemRange)hoe);
            API.addSetRange((String)"RedPower.Tools.Swords", (MultiItemRange)sword);
            MultiItemRange worldblocks = new MultiItemRange();
            worldblocks.add((amq)RedPowerWorld.blockPlants);
            worldblocks.add((amq)RedPowerWorld.blockLeaves);
            worldblocks.add((amq)RedPowerWorld.blockLogs);
            worldblocks.add((amq)RedPowerWorld.blockOres);
            worldblocks.add((amq)RedPowerWorld.blockStone);
            worldblocks.add((amq)RedPowerWorld.blockCrops);
            worldblocks.add((amq)RedPowerWorld.blockStorage);
            worlditems.add((up)RedPowerBase.itemResource);
            worlditems.add((up)RedPowerWorld.itemSeeds);
            worlditems.add(RedPowerBase.itemDyeIndigo);
            allblocks.add(worldblocks);
            allitems.add(worlditems);
            API.addSetRange((String)"RedPower.World.Blocks", (MultiItemRange)worldblocks);
            API.addSetRange((String)"RedPower.World.Items", (MultiItemRange)worlditems);
        }
    }
}

