/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.logging.Level;
import mistaqur.nei.NEIPlugins;
import mistaqur.nei.buildcraft.AssemblyRecipeHandler;
import mistaqur.nei.buildcraft.BuildcraftFuelHelper;
import mistaqur.nei.buildcraft.IronEngineFuelsHandler;
import mistaqur.nei.buildcraft.ItemPanelConfig;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.IPlugin;

public class NEIPlugins_Buildcraft
implements IPlugin {
    public static final String PLUGIN_NAME = "BuildCraft";
    public static final String PLUGIN_VERSION = "1.3.2.1";
    public static final String REQUIRED_MOD = "BuildCraft|Core";
    public static final String REQUIRED_MOD1 = "BuildCraft|Builders";
    public static final String REQUIRED_MOD2 = "BuildCraft|Energy";
    public static final String REQUIRED_MOD3 = "BuildCraft|Factory";
    public static final String REQUIRED_MOD4 = "BuildCraft|Silicon";
    public static final String REQUIRED_MOD5 = "BuildCraft|Transport";
    public static boolean buildersLoaded;
    public static boolean energyLoaded;
    public static boolean factoryLoaded;
    public static boolean siliconLoaded;
    public static boolean transportLoaded;

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod(REQUIRED_MOD);
    }

    @Override
    public void init() {
        buildersLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD1);
        energyLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD2);
        factoryLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD3);
        siliconLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD4);
        transportLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD5);
        this.addHandlers();
        this.configureItemPanel();
    }

    private void addHandlers() {
        if (energyLoaded) {
            API.registerRecipeHandler((ICraftingHandler)new IronEngineFuelsHandler());
            API.registerUsageHandler((IUsageHandler)new IronEngineFuelsHandler());
        } else {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Energy not found", new Object[0]);
        }
        if (siliconLoaded) {
            API.registerRecipeHandler((ICraftingHandler)new AssemblyRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new AssemblyRecipeHandler());
        } else {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Silicon not found", new Object[0]);
        }
        FuelTooltipHandler.addFuelHelper(new BuildcraftFuelHelper());
    }

    private void configureItemPanel() {
        ItemPanelConfig.addItemPanel();
    }
}

