/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei;

import codechicken.nei.GuiNEISettings;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import ic2.api.IElectricItem;
import ic2.api.IReactorComponent;
import ic2.api.ITerraformingBP;
import ic2.api.Items;
import java.util.logging.Level;
import mistaqur.nei.NEIPlugins;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.GuiNEIPluginsTooltipFuel;
import mistaqur.nei.common.IPlugin;
import mistaqur.nei.common.ItemApiHelper;
import mistaqur.nei.ic2.IC2FuelHelper;
import mistaqur.nei.ic2.MassFabricatorRecipeHandler;

public class NEIPlugins_IC2
implements IPlugin {
    public static final String PLUGIN_NAME = "IC2";
    public static final String PLUGIN_VERSION = "1.0.2.8";
    public static final String REQUIRED_MOD = "IC2";

    @Override
    public String getPluginName() {
        return "IC2";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("IC2");
    }

    @Override
    public void init() {
        this.initHandlers();
        this.configureItemPanel();
    }

    private void initHandlers() {
        NEIClientConfig.globalConfig.getTag("mistaqur.showIC2BurnEU").setDefaultValue("true");
        API.addSetting(GuiNEIPluginsTooltipFuel.class, (GuiNEISettings.NEIOption)new GuiNEISettings.NEIOption("mistaqur.showIC2BurnEU"){

            public String updateText() {
                return "Show burn EU: " + (this.enabled() ? "Shown" : "Hidden");
            }
        });
        try {
            MassFabricatorRecipeHandler.guiclass = Class.forName("ic2.common.GuiMatter");
            IC2FuelHelper.guiGenerator = Class.forName("ic2.common.GuiGenerator");
            IC2FuelHelper.guiIronFurnace = Class.forName("ic2.common.GuiIronFurnace");
        }
        catch (ClassNotFoundException ex) {
            NEIPlugins.log(Level.FINE, "Failed to detect GUIS from IC2", new Object[0]);
        }
        MassFabricatorRecipeHandler.addEmptyScrap = true;
        API.registerRecipeHandler((ICraftingHandler)new MassFabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MassFabricatorRecipeHandler());
        FuelTooltipHandler.addFuelHelper(new IC2FuelHelper());
    }

    private void configureItemPanel() {
        MultiItemRange electricItems = new MultiItemRange();
        MultiItemRange reactorComponents = new MultiItemRange();
        MultiItemRange tfbp = new MultiItemRange();
        MultiItemRange painters = new MultiItemRange();
        ItemApiHelper.hideItem(Items.getItem((String)"reinforcedDoorBlock"));
        ItemApiHelper.hideItem(Items.getItem((String)"activeLuminator"));
        ItemApiHelper.hideItem(Items.getItem((String)"miningPipeTip"));
        ItemApiHelper.hideItem(Items.getItem((String)"dynamiteStick"));
        ItemApiHelper.hideItem(Items.getItem((String)"dynamiteStickWithRemote"));
        ItemApiHelper.hideItem(Items.getItem((String)"constructionFoamWall"));
        ItemApiHelper.hideItem(Items.getItem((String)"blockBarrel"));
        ItemApiHelper.hideItem(Items.getItem((String)"enabledNanoSaber"));
        ItemApiHelper.hideItem(Items.getItem((String)"copperCableBlock"));
        for (up i : up.e) {
            if (i instanceof IElectricItem) {
                electricItems.add(i.cj);
            }
            if (i instanceof IReactorComponent) {
                reactorComponents.add(i.cj);
            }
            if (!(i instanceof ITerraformingBP)) continue;
            tfbp.add(i.cj);
        }
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"blackPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"redPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"greenPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"brownPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"bluePainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"purplePainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"cyanPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"lightGreyPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"darkGreyPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"pinkPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"limePainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"yellowPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"cloudPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"magentaPainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"orangePainter"));
        ItemApiHelper.addItemStackToRange(painters, Items.getItem((String)"whitePainter"));
        API.addSetRange((String)"IC2.Electric Items", (MultiItemRange)electricItems);
        API.addSetRange((String)"IC2.Reactor Components", (MultiItemRange)reactorComponents);
        API.addSetRange((String)"IC2.TFBP", (MultiItemRange)tfbp);
        API.addSetRange((String)"IC2.Tools.Painters", (MultiItemRange)painters);
    }
}

