/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.Map;
import java.util.logging.Level;
import mistaqur.nei.NEIPlugins;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.IPlugin;
import mistaqur.nei.railcraft.BlastFurnaceRecipeHandler;
import mistaqur.nei.railcraft.CokeOvenRecipeHandler;
import mistaqur.nei.railcraft.RCFuelHelper;
import mistaqur.nei.railcraft.RockCrusherRecipeHandler;
import mistaqur.nei.railcraft.RollingMachineRecipeHandler;
import mistaqur.nei.railcraft.RollingMachineShapelessRecipeHandler;
import railcraft.common.api.core.items.IMinecartItem;
import railcraft.common.api.core.items.ITrackItem;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.util.misc.BallastRegistry;
import railcraft.common.util.misc.BlockKey;

public class NEIPlugins_Railcraft
implements IPlugin {
    public static final String PLUGIN_NAME = "Railcraft";
    public static final String PLUGIN_VERSION = "1.6.2.1";
    public static final String REQUIRED_MOD = "Railcraft";

    @Override
    public String getPluginName() {
        return "Railcraft";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Railcraft");
    }

    @Override
    public void init() {
        this.addHandlers();
        this.configureItemPanel();
    }

    private void addHandlers() {
        try {
            RockCrusherRecipeHandler.guiclass = Class.forName("railcraft.client.gui.GuiRockCrusher");
            BlastFurnaceRecipeHandler.guiclass = Class.forName("railcraft.client.gui.GuiBlastFurnace");
            CokeOvenRecipeHandler.guiclass = Class.forName("railcraft.client.gui.GuiCokeOven");
            RollingMachineRecipeHandler.guiclass = Class.forName("railcraft.client.gui.GuiRollingMachine");
            RollingMachineShapelessRecipeHandler.guiclass = Class.forName("railcraft.client.gui.GuiRollingMachine");
            RCFuelHelper.guiCartBore = Class.forName("railcraft.client.gui.GuiCartBore");
            RCFuelHelper.guiBoilerSolid = Class.forName("railcraft.client.gui.GuiBoilerSolid");
            RCFuelHelper.guiEngineSteamHobby = Class.forName("railcraft.client.gui.GuiEngineSteamHobby");
        }
        catch (ClassNotFoundException ex) {
            NEIPlugins.log(Level.FINE, "Failed to detect GUIS from Railcraft", new Object[0]);
        }
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineShapelessRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineShapelessRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CokeOvenRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CokeOvenRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BlastFurnaceRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BlastFurnaceRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RockCrusherRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RockCrusherRecipeHandler());
        FuelTooltipHandler.addFuelHelper(new RCFuelHelper());
    }

    private void configureItemPanel() {
        try {
            this.hideObsoletes();
            this.addSubsets();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void addTag(String tag, MultiItemRange items) {
        ur item = ItemRegistry.getItem((String)tag, (int)1);
        if (item != null) {
            items.add(item);
        }
    }

    private void hideObsoletes() {
    }

    private void addSubsets() {
        MultiItemRange rails = new MultiItemRange();
        rails.add(amq.aJ.cm);
        rails.add(amq.X.cm);
        rails.add(amq.W.cm);
        MultiItemRange allcarts = new MultiItemRange();
        MultiItemRange allrails = new MultiItemRange();
        MultiItemRange woodenrails = new MultiItemRange();
        MultiItemRange speedrails = new MultiItemRange();
        MultiItemRange reinforcedrails = new MultiItemRange();
        MultiItemRange structure = new MultiItemRange();
        MultiItemRange signals = new MultiItemRange();
        MultiItemRange detectors = new MultiItemRange();
        MultiItemRange machines = new MultiItemRange();
        MultiItemRange parts = new MultiItemRange();
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange steeltools = new MultiItemRange();
        MultiItemRange armors = new MultiItemRange();
        MultiItemRange creosoteliquid = new MultiItemRange();
        MultiItemRange liquids = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange carts = new MultiItemRange();
        MultiItemRange dusts = new MultiItemRange();
        MultiItemRange ballasts = new MultiItemRange();
        carts.add(up.az.cj);
        carts.add(up.aN.cj);
        carts.add(up.aO.cj);
        for (up i : up.e) {
            if (i instanceof ITrackItem) {
                allrails.add(i.cj);
            }
            if (!(i instanceof IMinecartItem)) continue;
            allcarts.add(i.cj);
        }
        try {
            for (BlockKey blockKey : BallastRegistry.getRegisteredBallasts()) {
                ballasts.add(new ur(blockKey.blockID, 1, blockKey.metadata));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Map.Entry entry : ItemRegistry.getItems().entrySet()) {
            if (((String)entry.getKey()).startsWith("track.slow")) {
                woodenrails.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("track.speed")) {
                speedrails.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("track.reinforced")) {
                reinforcedrails.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("post")) {
                structure.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("structure.signal") || ((String)entry.getKey()).startsWith("structure.switch") || ((String)entry.getKey()).startsWith("structure.box")) {
                signals.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("detector.")) {
                detectors.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("machine.")) {
                machines.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("part.")) {
                parts.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("liquid.creosote.")) {
                creosoteliquid.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("liquid.")) {
                liquids.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("tool.steel.")) {
                steeltools.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("armor.steel.")) {
                armors.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("tool.")) {
                tools.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("dust.")) {
                dusts.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("cart.")) {
                carts.add((ur)entry.getValue());
            } else if (((String)entry.getKey()).startsWith("cube.")) {
                other.add((ur)entry.getValue());
            } else if (!((String)entry.getKey()).startsWith("track.")) {
                other.add((ur)entry.getValue());
            }
            if (!((String)entry.getKey()).startsWith("track.")) continue;
            rails.add((ur)entry.getValue());
        }
        NEIPlugins_Railcraft.addTag("tool.signal.tuner", signals);
        NEIPlugins_Railcraft.addTag("tool.surveyor", signals);
        NEIPlugins_Railcraft.addTag("fuel.coke", other);
        NEIPlugins_Railcraft.addTag("ic2.upgrade.lapotron", other);
        MultiItemRange crowbar = new MultiItemRange();
        NEIPlugins_Railcraft.addTag("tool.crowbar", crowbar);
        API.addSetRange((String)"RailCraft.Rails", (MultiItemRange)rails);
        API.addSetRange((String)"RailCraft.Rails.Wooden", (MultiItemRange)woodenrails);
        API.addSetRange((String)"RailCraft.Rails.HighSpeed", (MultiItemRange)speedrails);
        API.addSetRange((String)"RailCraft.Rails.Reinforced", (MultiItemRange)reinforcedrails);
        API.addSetRange((String)"RailCraft.Detectors", (MultiItemRange)detectors);
        API.addSetRange((String)"RailCraft.Structure", (MultiItemRange)structure);
        API.addSetRange((String)"RailCraft.Carts", (MultiItemRange)carts);
        API.addSetRange((String)"RailCraft.Signals", (MultiItemRange)signals);
        API.addSetRange((String)"RailCraft.Parts", (MultiItemRange)parts);
        API.addSetRange((String)"RailCraft.Machines", (MultiItemRange)machines);
        API.addSetRange((String)"RailCraft.Tools", (MultiItemRange)tools);
        API.addSetRange((String)"RailCraft.Ballasts", (MultiItemRange)ballasts);
        API.addSetRange((String)"RailCraft.Liquids.Creosote", (MultiItemRange)creosoteliquid);
        API.addSetRange((String)"RailCraft.Liquids", (MultiItemRange)liquids);
        API.addSetRange((String)"RailCraft.Other.Dusts", (MultiItemRange)dusts);
        API.addSetRange((String)"RailCraft.Other", (MultiItemRange)other);
        API.addSetRange((String)"RailCraft.Other.Armor", (MultiItemRange)armors);
        API.addSetRange((String)"RailCraft.Other.SteelTools", (MultiItemRange)steeltools);
        API.addSetRange((String)"RailCraft", (MultiItemRange)crowbar);
        API.addToRange((String)"Items.Tools.Other", (MultiItemRange)crowbar);
    }
}

