/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.common;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public abstract class LiquidHelper {
    private static Map mapFilledContainersFromLiquid = new HashMap();
    private static Map mapEmptyContainersFromLiquid = new HashMap();

    public static int bindLiquidTexture(LiquidStack liquid) {
        String textureFile;
        if (liquid == null || liquid.amount <= 0 || liquid.itemID == 0) {
            return 0;
        }
        int textureIndex = 0;
        if (liquid.itemID < amq.p.length && amq.p[liquid.itemID] != null) {
            textureFile = amq.p[liquid.itemID].getTextureFile();
            textureIndex = amq.p[liquid.itemID].a(1, liquid.itemMeta);
        } else {
            textureFile = up.e[liquid.itemID].getTextureFile();
            textureIndex = up.e[liquid.itemID].b(liquid.itemMeta);
        }
        ForgeHooksClient.bindTexture((String)textureFile, (int)0);
        return textureIndex;
    }

    public static LiquidStack getLiquidStack(ur item) {
        if (item == null) {
            return null;
        }
        LiquidStack result = LiquidContainerRegistry.getLiquidForFilledItem((ur)item);
        if (result == null && LiquidContainerRegistry.isLiquid((ur)item)) {
            result = new LiquidStack(item.c, 1000, item.j());
        }
        return result;
    }

    public static PositionedStack[] generateStacksForLiquid(LiquidStack liquid, int x1, int y1, int x2, int y2) {
        List<Integer> key;
        if (mapFilledContainersFromLiquid.isEmpty()) {
            LiquidHelper.generateLiquidCache();
        }
        if (!mapFilledContainersFromLiquid.containsKey(key = Arrays.asList(liquid.itemID, liquid.itemMeta))) {
            return new PositionedStack[]{null, new PositionedStack((Object)liquid.asItemStack(), x2, y2)};
        }
        return new PositionedStack[]{new PositionedStack(mapEmptyContainersFromLiquid.get(key), x1, y1), new PositionedStack(mapFilledContainersFromLiquid.get(key), x2, y2)};
    }

    public static boolean areSameLiquid(LiquidStack liquid, LiquidStack liquid2) {
        if (liquid == null || liquid2 == null) {
            return false;
        }
        return liquid.isLiquidEqual(liquid2);
    }

    public static PositionedStack getSeqCycledStack(int cycle, PositionedStack origstack) {
        PositionedStack stack = origstack.copy();
        if (stack.items.length > 1) {
            stack.setPermutationToRender(cycle % stack.items.length);
        } else if (stack.item.j() == -1) {
            int maxDamage = 0;
            do {
                stack.item.b(++maxDamage);
            } while (NEIClientUtils.isValidItem((ur)stack.item));
            stack.item.b(cycle % maxDamage);
        }
        return stack;
    }

    public static void generateLiquidCache() {
        mapFilledContainersFromLiquid.clear();
        mapEmptyContainersFromLiquid.clear();
        for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            List<Integer> key = Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta);
            if (!mapFilledContainersFromLiquid.containsKey(key)) {
                mapFilledContainersFromLiquid.put(key, new ArrayList());
                mapEmptyContainersFromLiquid.put(key, new ArrayList());
            }
            ((ArrayList)mapFilledContainersFromLiquid.get(key)).add(data.filled.l());
            ((ArrayList)mapEmptyContainersFromLiquid.get(key)).add(data.container.l());
        }
    }
}

