/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.common;

import codechicken.nei.forge.GuiContainerManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.List;
import mistaqur.nei.common.LiquidHelper;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LiquidTank {
    public LiquidStack liquid;
    public Rectangle position;
    public Point overlay;
    public int capacity;
    public boolean showCapacity = true;
    public boolean showAmount = true;
    public String overrideTitle = null;
    public static DecimalFormat liquidAmountFormat = new DecimalFormat("0.000");

    public LiquidTank(LiquidStack liquid, int capacity, Rectangle position) {
        this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
        this.capacity = capacity;
        this.position = position;
        this.overlay = null;
    }

    public LiquidTank(LiquidStack liquid, int capacity, Rectangle position, Point overlay) {
        this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
        this.capacity = capacity;
        this.position = position;
        this.overlay = overlay;
    }

    public void draw(GuiContainerManager gui, String guiTexture) {
        this.drawLiquidTank(gui, this.position, this.liquid, this.capacity, this.overlay, guiTexture);
    }

    public List handleTooltip(List currenttip) {
        if (this.liquid.itemID > 0) {
            if (this.overrideTitle != null) {
                currenttip.add(this.overrideTitle);
            } else {
                currenttip.add(up.e[this.liquid.itemID].l(this.liquid.asItemStack()));
            }
            if (this.showAmount) {
                currenttip.add("\u00a77Amount: " + liquidAmountFormat.format((double)this.liquid.amount * 1.0 / 1000.0));
            }
            if (this.showCapacity) {
                currenttip.add("\u00a77Capacity: " + liquidAmountFormat.format((double)this.capacity * 1.0 / 1000.0));
            }
            this.additionalHandleTooltip(currenttip);
        } else {
            currenttip.add("Empty");
        }
        return currenttip;
    }

    public List additionalHandleTooltip(List currenttip) {
        return currenttip;
    }

    public void drawLiquidTank(GuiContainerManager gui, Rectangle position, LiquidStack liquid, int capacity, Point overlay, String guiTexture) {
        if (liquid == null) {
            return;
        }
        int scale = liquid.amount * position.height / capacity;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int liquidImgIndex = LiquidHelper.bindLiquidTexture(liquid);
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        for (int col = 0; col < position.width / 16; ++col) {
            int x;
            int start = 0;
            int s = scale;
            do {
                x = 0;
                if (s > 16) {
                    x = 16;
                    s -= 16;
                } else {
                    x = s;
                    s = 0;
                }
                gui.drawTexturedModalRect(position.x + col * 16, position.y + position.height - x - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && s != 0);
        }
        if (overlay != null) {
            gui.bindTextureByName(guiTexture);
            gui.drawTexturedModalRect(position.x, position.y, overlay.x, overlay.y, position.width, position.height);
        }
    }
}

