/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.common;

import codechicken.nei.NEIClientConfig;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import mistaqur.nei.NEIPlugins;
import mistaqur.nei.common.IPlugin;
import mistaqur.nei.common.TickHandlerVersion;

public class VersionCheck {
    private static final String VERSION_URL = "https://dl.dropbox.com/u/53845448/minecraft/neiplugins/version.txt";
    private static boolean checkUpdate;
    private static boolean checkAllUpdates;
    private static String latestModVersion;
    private static String description;
    private static boolean newVersionAvailable;
    private static boolean versionCheckCompleted;
    public static TickHandlerVersion tickHandler;

    public static void checkForNewVersion() {
        checkUpdate = NEIClientConfig.getBooleanSetting((String)"mistaqur.checkUpdate");
        checkAllUpdates = NEIClientConfig.getBooleanSetting((String)"mistaqur.checkAllUpdates");
        if (!checkUpdate) {
            return;
        }
        if (tickHandler == null) {
            tickHandler = new TickHandlerVersion();
            TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)tickHandler, (Side)Side.CLIENT);
        } else {
            tickHandler.reset();
        }
        VersionCheckThread versionCheckThread = new VersionCheckThread();
        versionCheckThread.start();
    }

    public static boolean isNewVersionAvailable() {
        return newVersionAvailable;
    }

    public static String getLatestVersion() {
        return latestModVersion;
    }

    public static String getVersionDescription() {
        return description;
    }

    public static boolean isVersionCheckComplete() {
        return versionCheckCompleted;
    }

    static {
        latestModVersion = "";
        description = "";
    }

    private static class VersionCheckThread
    extends Thread {
        @Override
        public void run() {
            Map modVersions = NEIPlugins.getMod().modVersions;
            try {
                URL versionFile = new URL(VersionCheck.VERSION_URL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
                latestModVersion = reader.readLine();
                boolean invalidFile = false;
                newVersionAvailable = false;
                String line = reader.readLine();
                while (line != null && !line.equals("")) {
                    String[] parts = line.trim().split("\t");
                    if (parts.length != 2) {
                        invalidFile = true;
                        break;
                    }
                    ArtifactVersion modVersion = VersionParser.parseVersionReference((String)parts[1]);
                    if (!NEIPlugins.getMod().hasMod(modVersion)) {
                        NEIPlugins.log(Level.FINE, "Update for mod \"{0}\" is ignored", new Object[]{modVersion.getLabel()});
                    } else {
                        String[] part0 = parts[0].trim().split("@");
                        if (part0.length == 2) {
                            DefaultArtifactVersion latestPluginVersion = new DefaultArtifactVersion(part0[0], part0[1]);
                            IPlugin plugin = (IPlugin)NEIPlugins.getMod().plugins.get(part0[0]);
                            if (plugin == null) {
                                NEIPlugins.log(Level.INFO, "New plugin for \"{0}\" is available: {1} ({2})", new Object[]{modVersion.getLabel(), latestPluginVersion.getLabel(), latestPluginVersion.getVersionString()});
                                newVersionAvailable = true;
                            } else {
                                DefaultArtifactVersion currentPluginVersion = new DefaultArtifactVersion(part0[0], plugin.getPluginVersion());
                                if (latestPluginVersion.compareTo((Object)currentPluginVersion) > 0) {
                                    NEIPlugins.log(Level.INFO, "New version of plugin for \"{0}\" is available: {1} ({2})", new Object[]{modVersion.getLabel(), latestPluginVersion.getLabel(), latestPluginVersion.getVersionString()});
                                    newVersionAvailable = true;
                                }
                            }
                        }
                    }
                    line = reader.readLine();
                }
                DefaultArtifactVersion latestVersion = new DefaultArtifactVersion(latestModVersion);
                DefaultArtifactVersion currentVersion = new DefaultArtifactVersion("1.0.4.5");
                NEIPlugins.log(Level.FINE, "Latest and current version of NEIPlugins: {0} and {1}", new Object[]{latestVersion.getVersionString(), currentVersion.getVersionString()});
                if (checkAllUpdates && latestVersion.compareTo((Object)currentVersion) > 0 || invalidFile) {
                    newVersionAvailable = true;
                }
                if (!invalidFile) {
                    description = reader.readLine();
                }
                reader.close();
                if (newVersionAvailable) {
                    NEIPlugins.log(Level.INFO, "An updated version of NEIPlugins is available: {0} {1}", new Object[]{latestModVersion, description});
                }
            }
            catch (Exception ex) {
                NEIPlugins.log(Level.WARNING, "Latest Version Check Failed: {0}", new Object[]{ex.getMessage()});
            }
            versionCheckCompleted = true;
        }
    }
}

