/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import mistaqur.nei.forestry.ForestryRecipeHandler;
import net.minecraftforge.liquids.LiquidStack;

public class BiogasFuelHandler
extends ForestryRecipeHandler {
    static Rectangle fuelTank = new Rectangle(84, 8, 16, 58);
    static Rectangle heatingTank = new Rectangle(102, 8, 16, 58);
    static Rectangle currentFuelTank = new Rectangle(25, 36, 16, 16);
    static Point overlayTank = new Point(176, 0);

    public String getRecipeName() {
        return "Biogas Engine Fuel";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(28, 22, 12, 8), "forestry.biogas.fuel", new Object[0]));
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            EngineBronzeFuel fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(t.itemID);
            if (fuel != null) {
                this.arecipes.add(new CachedBiogasFuel(fuel));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        EngineBronzeFuel fuel;
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        if (t != null && (fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(t.itemID)) != null) {
            this.arecipes.add(new CachedBiogasFuel(fuel));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.biogas.fuel") && ((Object)((Object)this)).getClass() == BiogasFuelHandler.class) {
            for (EngineBronzeFuel fuel : FuelManager.bronzeEngineFuel.values()) {
                this.arecipes.add(new CachedBiogasFuel(fuel));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/bioengine.png";
    }

    public class BiogasFuelLiquidTank
    extends LiquidTank {
        public EngineBronzeFuel fuel;

        public BiogasFuelLiquidTank(EngineBronzeFuel fuel, int capacity, Rectangle position) {
            super(new LiquidStack(fuel.liquid.c, capacity), capacity, position);
            this.fuel = fuel;
        }

        @Override
        public List additionalHandleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                currenttip.add("\u00a77Stats per bucket:");
                currenttip.add("\u00a77Output: " + this.fuel.powerPerCycle + " MJ/t");
                currenttip.add("\u00a77Duration: " + this.fuel.burnDuration + " t");
                if (this.fuel.dissipationMultiplier > 2) {
                    currenttip.add("\u00a7cConstantly consume lava");
                }
            }
            return currenttip;
        }
    }

    public class CachedBiogasFuel
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList slot_input;
        LiquidTank fueltank;
        LiquidTank heatingtank;
        LiquidTank currentfueltank;

        public CachedBiogasFuel(EngineBronzeFuel fuel) {
            super((TemplateRecipeHandler)BiogasFuelHandler.this);
            this.fueltank = new LiquidTank(new LiquidStack(fuel.liquid.c, 10000), 10000, fuelTank, overlayTank);
            this.heatingtank = new LiquidTank(new LiquidStack(amq.G.cm, 10000), 10000, heatingTank, overlayTank);
            this.currentfueltank = new BiogasFuelLiquidTank(fuel, 1000, currentFuelTank);
            this.fueltank.showAmount = false;
            this.heatingtank.showAmount = false;
            this.currentfueltank.showAmount = false;
            this.currentfueltank.showCapacity = false;
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.currentfueltank.liquid, 138, 11, 138, 29);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(BiogasFuelHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.fueltank);
            res.add(this.heatingtank);
            res.add(this.currentfueltank);
            return res;
        }
    }
}

