/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineCentrifuge;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CentrifugeRecipeHandler
extends TemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    public String getRecipeName() {
        return "Centrifuge";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(49, 8, 20, 52), "forestry.centrifuge", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.centrifuge") && ((Object)((Object)this)).getClass() == CentrifugeRecipeHandler.class) {
            MachineCentrifuge.RecipeManager cfr_ignored_0 = (MachineCentrifuge.RecipeManager)RecipeManagers.centrifugeManager;
            ArrayList recipes = MachineCentrifuge.RecipeManager.recipes;
            for (MachineCentrifuge.Recipe irecipe : recipes) {
                if (irecipe.products.size() <= 0) continue;
                this.arecipes.add(new CachedCentrifugeRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        MachineCentrifuge.RecipeManager cfr_ignored_0 = (MachineCentrifuge.RecipeManager)RecipeManagers.centrifugeManager;
        ArrayList recipes = MachineCentrifuge.RecipeManager.recipes;
        for (MachineCentrifuge.Recipe irecipe : recipes) {
            CachedCentrifugeRecipe recipe;
            if (irecipe.products.size() <= 0 || !(recipe = new CachedCentrifugeRecipe(irecipe)).canProduce(result)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        MachineCentrifuge.RecipeManager cfr_ignored_0 = (MachineCentrifuge.RecipeManager)RecipeManagers.centrifugeManager;
        ArrayList recipes = MachineCentrifuge.RecipeManager.recipes;
        for (MachineCentrifuge.Recipe irecipe : recipes) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)irecipe.resource, (ur)ingredient) || irecipe.products.size() <= 0) continue;
            CachedCentrifugeRecipe recipe = new CachedCentrifugeRecipe(irecipe);
            recipe.setIngredientPermutation(recipe.resources, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public Rectangle getRectangleFromPositionedStack(PositionedStack stack) {
        return new Rectangle(stack.relx - 1, stack.rely - 1, 18, 18);
    }

    public List handleItemTooltip(GuiRecipe guiRecipe, ur itemStack, List currenttip, int recipe) {
        CachedCentrifugeRecipe crecipe = (CachedCentrifugeRecipe)((Object)this.arecipes.get(recipe));
        Point mousepos = guiRecipe.manager.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
        for (PositionedStack stack : crecipe.products) {
            if (!this.getRectangleFromPositionedStack(stack).contains(relMouse)) continue;
            int chance = crecipe.getProductChance(stack.item);
            if (chance < 1) {
                currenttip.add("Chance: never");
                continue;
            }
            if (chance >= 99) continue;
            currenttip.add("Chance: " + Integer.toString(chance) + "%");
        }
        return currenttip;
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 57, 25, 176, 0, 4, 17, ((CachedCentrifugeRecipe)((Object)this.arecipes.get((int)recipe))).timePerItem * 5, 3);
    }

    public boolean hasOverlay(avf gui, rq container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/centrifuge.png";
    }

    public class CachedCentrifugeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList products;
        ArrayList resources;
        HashMap iproducts;
        int timePerItem;

        public CachedCentrifugeRecipe(MachineCentrifuge.Recipe recipe) {
            super((TemplateRecipeHandler)CentrifugeRecipeHandler.this);
            this.resources = new ArrayList();
            this.resources.add(new PositionedStack((Object)recipe.resource, 29, 26));
            this.timePerItem = recipe.timePerItem;
            this.setProducts(recipe.products);
        }

        public int getProductChance(ur item) {
            for (Map.Entry product : this.iproducts.entrySet()) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ur)((ur)product.getKey()), (ur)item)) continue;
                return (Integer)product.getValue();
            }
            return 0;
        }

        public void setProducts(HashMap iproducts) {
            this.iproducts = iproducts;
            this.products = new ArrayList();
            int i = 0;
            for (ur product : iproducts.keySet()) {
                if (i > 8) break;
                this.products.add(new PositionedStack((Object)product.l(), 93 + stackorder[i][0] * 18, 8 + stackorder[i][1] * 18));
                ++i;
            }
        }

        public ArrayList getOtherStacks() {
            ArrayList stacks = new ArrayList();
            for (int i = 1; i < this.products.size(); ++i) {
                stacks.add(this.products.get(i));
            }
            return stacks;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(CentrifugeRecipeHandler.this.cycleticks / 20, this.resources);
        }

        public boolean canProduce(ur product) {
            for (PositionedStack stack : this.products) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ur)stack.item, (ur)product)) continue;
                return true;
            }
            return false;
        }

        public PositionedStack getResult() {
            return (PositionedStack)this.products.get(0);
        }
    }
}

