/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineStill;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import mistaqur.nei.forestry.ForestryRecipeHandler;
import net.minecraftforge.liquids.LiquidStack;

public class StillRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 4, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 4, 16, 58);
    static Point overlayTank = new Point(176, 0);

    public String getRecipeName() {
        return "Still";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 6, 15, 15), "forestry.still", new Object[0]));
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.input)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.still") && ((Object)((Object)this)).getClass() == StillRecipeHandler.class) {
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                this.arecipes.add(new CachedStillRecipe(irecipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)results[0];
            MachineStill.RecipeManager cfr_ignored_1 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        if (t != null) {
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe).replaceMetaOnBottlerSlots(result));
            }
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        if (t != null) {
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.input)) continue;
                CachedStillRecipe recipe = new CachedStillRecipe(irecipe);
                recipe.setIngredientPermutation(recipe.slot_input, ingredient);
                this.arecipes.add(recipe);
            }
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/still.png";
    }

    public class CachedStillRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        int timePerUnit;
        ArrayList slot_input;
        PositionedStack slot_output;
        PositionedStack slot_can;
        LiquidTank input;
        LiquidTank output;

        public CachedStillRecipe(MachineStill.Recipe recipe) {
            super((TemplateRecipeHandler)StillRecipeHandler.this);
            this.input = new LiquidTank(recipe.input.copy(), 10000, inputTank, overlayTank);
            this.output = new LiquidTank(recipe.output.copy(), 10000, outputTank, overlayTank);
            int multiply = 1;
            if (this.input.liquid.amount < 1000 && this.output.liquid.amount < 1000) {
                multiply = (int)Math.ceil(1000.0f / (float)this.input.liquid.amount);
            }
            this.input.liquid.amount *= multiply;
            this.output.liquid.amount *= multiply;
            this.timePerUnit = recipe.timePerUnit;
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.input.liquid, 15, 25, 5, 25);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.output.liquid, 145, 7, 145, 43);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
            this.slot_can = output_cont[0];
            this.slot_output = output_cont[1];
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(StillRecipeHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(StillRecipeHandler.this.cycleticks / 20, this.slot_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(StillRecipeHandler.this.cycleticks / 20, this.slot_can));
            }
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedStillRecipe replaceMetaOnBottlerSlots(ur ingredient) {
            if (this.slot_output.items.length == 1 && this.slot_can == null) {
                return this;
            }
            for (int i = 0; i < this.slot_output.items.length; ++i) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ur)ingredient, (ur)this.slot_output.items[i])) continue;
                this.slot_output.item = this.slot_output.items[i];
                this.slot_output.item.b(ingredient.j());
                this.slot_output.items = new ur[]{this.slot_output.item};
                this.slot_output.setPermutationToRender(0);
                this.slot_can.item = this.slot_can.items[i];
                this.slot_can.items = new ur[]{this.slot_can.item};
                this.slot_can.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

