/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forge;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidDictionaryList
extends TemplateRecipeHandler {
    static Rectangle liquidTank = new Rectangle(22, 8, 48, 47);

    public String getRecipeName() {
        return "Liquid Registry";
    }

    public String getRecipeId() {
        return "forge.liquiddictionary";
    }

    public String getGuiTexture() {
        return "/mistaqur/nei/gfx/LiquidDictionaryList.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawLiquidTanks(gui, recipe);
        gui.drawTextCentered(((CachedLiquidDictionaryEntry)this.arecipes.get((int)recipe)).name, 85, 9, -8355712, false);
    }

    public void drawLiquidTanks(GuiContainerManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui, this.getGuiTexture());
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    protected ArrayList getAllRecipes() {
        ArrayList<CachedLiquidDictionaryEntry> result = new ArrayList<CachedLiquidDictionaryEntry>();
        HashMap<List<Integer>, CachedLiquidDictionaryEntry> liquids = new HashMap<List<Integer>, CachedLiquidDictionaryEntry>();
        for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (liquids.containsKey(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta))) continue;
            CachedLiquidDictionaryEntry entry = new CachedLiquidDictionaryEntry(data.stillLiquid);
            liquids.put(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta), entry);
            result.add(entry);
        }
        Map definedLiquids = LiquidDictionary.getLiquids();
        if (definedLiquids != null) {
            String[] names;
            for (String name : names = definedLiquids.keySet().toArray(new String[0])) {
                LiquidStack liquid = (LiquidStack)definedLiquids.get(name);
                CachedLiquidDictionaryEntry entry = (CachedLiquidDictionaryEntry)liquids.get(Arrays.asList(liquid.itemID, liquid.itemMeta));
                if (entry == null) {
                    entry = new CachedLiquidDictionaryEntry(liquid);
                    liquids.put(Arrays.asList(liquid.itemID, liquid.itemMeta), entry);
                    result.add(entry);
                }
                entry.tank.dictionaryNames.add(name);
            }
        }
        return result;
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            for (CachedLiquidDictionaryEntry recipe : this.getAllRecipes()) {
                if (!recipe.sameLiquid(t)) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object[] results) {
        if (outputId.equals(this.getRecipeId())) {
            for (CachedLiquidDictionaryEntry recipe : this.getAllRecipes()) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        for (CachedLiquidDictionaryEntry recipe : this.getAllRecipes()) {
            if (!recipe.sameLiquid(t)) continue;
            this.arecipes.add(recipe);
        }
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (guiRecipe.manager.shouldShowTooltip() && crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    protected boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public class LiquidDictionaryTank
    extends LiquidTank {
        public List dictionaryNames;

        public LiquidDictionaryTank(LiquidStack liquid, int capacity, Rectangle position) {
            super(liquid, capacity, position);
            this.dictionaryNames = new ArrayList();
        }

        @Override
        public List additionalHandleTooltip(List currenttip) {
            List fuelTooltip;
            if (NEIClientConfig.getBooleanSetting((String)"mistaqur.enableDebug") && this.dictionaryNames.size() > 0) {
                currenttip.add("\u00a77Liquid dictionary names:");
                for (String name : this.dictionaryNames) {
                    currenttip.add("\u00a73" + name);
                }
            }
            if (NEIClientConfig.getBooleanSetting((String)"mistaqur.showLiquidDictionaryFuelTooltip") && (fuelTooltip = FuelTooltipHandler.getLiquidStackFuelTooltip(this.liquid)) != null && fuelTooltip.size() > 0) {
                currenttip.add("\u00a77Can produce (per bucket):");
                currenttip.addAll(fuelTooltip);
            }
            return currenttip;
        }
    }

    public class CachedLiquidDictionaryEntry
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        LiquidDictionaryTank tank;
        PositionedStack liquidInput;
        PositionedStack liquidOutput;
        String name;

        public CachedLiquidDictionaryEntry(LiquidStack liquid) {
            super((TemplateRecipeHandler)LiquidDictionaryList.this);
            this.name = this.name;
            this.tank = new LiquidDictionaryTank(liquid.copy(), 1000, liquidTank);
            this.tank.liquid.amount = 1000;
            this.tank.showAmount = false;
            this.tank.showCapacity = false;
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.tank.liquid, 104, 6, 104, 42);
            this.liquidInput = output_cont[0];
            this.liquidOutput = output_cont[1];
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.liquidInput != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(LiquidDictionaryList.this.cycleticks / 20, this.liquidInput));
                stacks.add(LiquidHelper.getSeqCycledStack(LiquidDictionaryList.this.cycleticks / 20, this.liquidOutput));
            }
            return stacks;
        }

        public boolean sameLiquid(LiquidStack liquid) {
            return LiquidHelper.areSameLiquid(this.tank.liquid, liquid);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidDictionaryTank> res = new ArrayList<LiquidDictionaryTank>();
            res.add(this.tank);
            return res;
        }
    }
}

