/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.gregtech;

import gregtechmod.api.GT_Recipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.IFuelHelper;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class GregTechFuelHelper
implements IFuelHelper {
    public static HashMap sDieselFuels = new HashMap();
    public static HashMap sTurbineFuels = new HashMap();
    public static HashMap sHotFuels = new HashMap();
    public static HashMap sDenseLiquidFuels = new HashMap();
    public static HashMap sPlasmaFuels = new HashMap();
    public static HashMap tooltipRemover = new HashMap();

    @Override
    public List getContextTooltip(avf gui, ur stack, List currenttip) {
        return currenttip;
    }

    @Override
    public List getBeforeTooltip(avf gui, ur stack, List currenttip) {
        List<Integer> key;
        GT_Recipe recipe;
        LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)stack);
        if (liquid != null && (recipe = (GT_Recipe)tooltipRemover.get(key = Arrays.asList(liquid.itemID, liquid.itemMeta))) != null) {
            String s = recipe.mStartEU * 1000 + " EU";
            for (int i = 0; i < currenttip.size(); ++i) {
                if (!((String)currenttip.get(i)).equals(s)) continue;
                currenttip.remove(s);
                break;
            }
        }
        return currenttip;
    }

    @Override
    public boolean haveContextTooltip(avf gui) {
        return false;
    }

    public List findFuelTooltip(List key, HashMap map, int amount, String suffix, List currenttip) {
        GT_Recipe recipe = (GT_Recipe)map.get(key);
        if (recipe != null) {
            currenttip.add("\u00a77" + FuelTooltipHandler.compactValue(recipe.mStartEU * amount) + " EU " + suffix);
        }
        return currenttip;
    }

    @Override
    public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
        List<Integer> key = Arrays.asList(liquid.itemID, liquid.itemMeta);
        this.findFuelTooltip(key, sDieselFuels, liquid.amount, "at 12 EU/t (Diesel Generator)", currenttip);
        this.findFuelTooltip(key, sTurbineFuels, liquid.amount, "at 16 EU/t (Gas Turbine)", currenttip);
        this.findFuelTooltip(key, sHotFuels, liquid.amount, "at 24 EU/t (Thermal Generator)", currenttip);
        this.findFuelTooltip(key, sDenseLiquidFuels, liquid.amount, "at 8 EU/t (Semi Fluid Generator)", currenttip);
        this.findFuelTooltip(key, sPlasmaFuels, liquid.amount, "(Plasma Generator)", currenttip);
        return currenttip;
    }

    @Override
    public List getItemStackFuelTooltip(ur stack, List currenttip) {
        List<Integer> key = Arrays.asList(stack.c, stack.j());
        this.findFuelTooltip(key, sDieselFuels, 1000, "at 12 EU/t (Diesel Generator)", currenttip);
        this.findFuelTooltip(key, sTurbineFuels, 1000, "at 16 EU/t (Gas Turbine)", currenttip);
        this.findFuelTooltip(key, sHotFuels, 1000, "at 24 EU/t (Thermal Generator)", currenttip);
        this.findFuelTooltip(key, sDenseLiquidFuels, 1000, "at 8 EU/t (Semi Fluid Generator)", currenttip);
        this.findFuelTooltip(key, sPlasmaFuels, 1000, "(Plasma Generator)", currenttip);
        return currenttip;
    }

    public static void buildCache() {
        LiquidStack liquid;
        for (GT_Recipe recipe : GT_Recipe.sDieselFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)recipe.mInput1);
            if (liquid == null) {
                sDieselFuels.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                tooltipRemover.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                continue;
            }
            sDieselFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sTurbineFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)recipe.mInput1);
            if (liquid == null) {
                sTurbineFuels.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                tooltipRemover.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                continue;
            }
            sTurbineFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sHotFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)recipe.mInput1);
            if (liquid == null) {
                tooltipRemover.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                sHotFuels.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                continue;
            }
            sHotFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sDenseLiquidFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)recipe.mInput1);
            if (liquid == null) {
                sDenseLiquidFuels.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                tooltipRemover.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                continue;
            }
            sDenseLiquidFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sPlasmaFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)recipe.mInput1);
            if (liquid == null) {
                sPlasmaFuels.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                tooltipRemover.put(Arrays.asList(recipe.mInput1.c, recipe.mInput1.j()), recipe);
                continue;
            }
            sPlasmaFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
    }
}

