/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.gates.Action;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.Trigger;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockSpring;
import buildcraft.core.BuildCraftConfiguration;
import buildcraft.core.CommandBuildCraft;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.EntityPowerLaser;
import buildcraft.core.EntityRobot;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ItemWrench;
import buildcraft.core.RedstonePowerFramework;
import buildcraft.core.SpringPopulate;
import buildcraft.core.TickHandlerCoreClient;
import buildcraft.core.Version;
import buildcraft.core.blueprints.BptItem;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.triggers.ActionRedstoneOutput;
import buildcraft.core.triggers.DefaultActionProvider;
import buildcraft.core.triggers.DefaultTriggerProvider;
import buildcraft.core.triggers.TriggerInventory;
import buildcraft.core.triggers.TriggerLiquidContainer;
import buildcraft.core.triggers.TriggerMachine;
import buildcraft.core.utils.Localization;
import buildcraft.transport.triggers.TriggerRedstoneInput;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@Mod(name="BuildCraft", version="3.4.3", useMetadata=false, modid="BuildCraft|Core", dependencies="required-after:Forge@[6.5.0.0,)")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftCore {
    public static RenderMode render = RenderMode.Full;
    public static boolean debugMode = false;
    public static boolean modifyWorld = false;
    public static boolean trackNetworkUsage = false;
    public static boolean dropBrokenBlocks = true;
    public static int itemLifespan = 1200;
    public static int updateFactor = 10;
    public static long longUpdateFactor = 40L;
    public static BuildCraftConfiguration mainConfiguration;
    public static TreeMap bufferedDescriptions;
    public static final int trackedPassiveEntityId = 156;
    public static boolean continuousCurrentModel;
    public static amq springBlock;
    public static up woodenGearItem;
    public static up stoneGearItem;
    public static up ironGearItem;
    public static up goldGearItem;
    public static up diamondGearItem;
    public static up wrenchItem;
    public static int redLaserTexture;
    public static int blueLaserTexture;
    public static int stripesLaserTexture;
    public static int transparentTexture;
    public static int blockByEntityModel;
    public static int legacyPipeModel;
    public static int markerModel;
    public static int oilModel;
    public static Trigger triggerMachineActive;
    public static Trigger triggerMachineInactive;
    public static Trigger triggerEmptyInventory;
    public static Trigger triggerContainsInventory;
    public static Trigger triggerSpaceInventory;
    public static Trigger triggerFullInventory;
    public static Trigger triggerEmptyLiquid;
    public static Trigger triggerContainsLiquid;
    public static Trigger triggerSpaceLiquid;
    public static Trigger triggerFullLiquid;
    public static Trigger triggerRedstoneActive;
    public static Trigger triggerRedstoneInactive;
    public static Action actionRedstone;
    public static Action actionOn;
    public static Action actionOff;
    public static Action actionLoop;
    public static boolean loadDefaultRecipes;
    public static boolean forcePneumaticPower;
    public static boolean consumeWaterSources;
    public static BptItem[] itemBptProps;
    public static Logger bcLog;
    @Mod.Instance(value="BuildCraft|Core")
    public static BuildCraftCore instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        Version.check();
        bcLog.setParent(FMLLog.getLogger());
        bcLog.info("Starting BuildCraft " + Version.getVersion());
        bcLog.info("Copyright (c) SpaceToad, 2011");
        bcLog.info("http://www.mod-buildcraft.com");
        mainConfiguration = new BuildCraftConfiguration(new File(evt.getModConfigurationDirectory(), "buildcraft/main.conf"));
        try {
            mainConfiguration.load();
            redLaserTexture = 2;
            blueLaserTexture = 1;
            stripesLaserTexture = 3;
            transparentTexture = 0;
            Property continuousCurrent = mainConfiguration.get("general", "current.continuous", DefaultProps.CURRENT_CONTINUOUS);
            continuousCurrent.comment = "set to true for allowing machines to be driven by continuous current";
            continuousCurrentModel = continuousCurrent.getBoolean(DefaultProps.CURRENT_CONTINUOUS);
            Property trackNetwork = mainConfiguration.get("general", "trackNetworkUsage", false);
            trackNetworkUsage = trackNetwork.getBoolean(false);
            Property dropBlock = mainConfiguration.get("general", "dropBrokenBlocks", true);
            dropBlock.comment = "set to false to prevent fillers from dropping blocks.";
            dropBrokenBlocks = dropBlock.getBoolean(true);
            Property lifespan = mainConfiguration.get("general", "itemLifespan", itemLifespan);
            lifespan.comment = "the lifespan in ticks of items dropped on the ground by pipes and machines, vanilla = 6000, default = 1200";
            itemLifespan = lifespan.getInt(itemLifespan);
            if (itemLifespan < 100) {
                itemLifespan = 100;
            }
            Property powerFrameworkClass = mainConfiguration.get("general", "power.framework", "buildcraft.energy.PneumaticPowerFramework");
            Property factor = mainConfiguration.get("general", "network.updateFactor", 10);
            factor.comment = "increasing this number will decrease network update frequency, useful for overloaded servers";
            updateFactor = factor.getInt(10);
            Property longFactor = mainConfiguration.get("general", "network.stateRefreshPeriod", 40);
            longFactor.comment = "delay between full client sync packets, increasing it saves bandwidth, decreasing makes for better client syncronization.";
            longUpdateFactor = longFactor.getInt(40);
            String powerFrameworkClassName = "buildcraft.energy.PneumaticPowerFramework";
            if (!forcePneumaticPower) {
                powerFrameworkClassName = powerFrameworkClass.value;
            }
            try {
                PowerFramework.currentFramework = (PowerFramework)Class.forName(powerFrameworkClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                bcLog.throwing("BuildCraftCore", "loadConfiguration", e);
                PowerFramework.currentFramework = new RedstonePowerFramework();
            }
            Property wrenchId = mainConfiguration.getItem("wrench.id", DefaultProps.WRENCH_ID);
            wrenchItem = new ItemWrench(wrenchId.getInt(DefaultProps.WRENCH_ID)).c(2).b("wrenchItem");
            LanguageRegistry.addName((Object)wrenchItem, (String)"Wrench");
            Property springId = mainConfiguration.getBlock("springBlock.id", DefaultProps.SPRING_ID);
            Property woodenGearId = mainConfiguration.getItem("woodenGearItem.id", DefaultProps.WOODEN_GEAR_ID);
            Property stoneGearId = mainConfiguration.getItem("stoneGearItem.id", DefaultProps.STONE_GEAR_ID);
            Property ironGearId = mainConfiguration.getItem("ironGearItem.id", DefaultProps.IRON_GEAR_ID);
            Property goldenGearId = mainConfiguration.getItem("goldenGearItem.id", DefaultProps.GOLDEN_GEAR_ID);
            Property diamondGearId = mainConfiguration.getItem("diamondGearItem.id", DefaultProps.DIAMOND_GEAR_ID);
            Property modifyWorld = mainConfiguration.get("general", "modifyWorld", true);
            modifyWorld.comment = "set to false if BuildCraft should not generate custom blocks (e.g. oil)";
            BuildCraftCore.modifyWorld = modifyWorld.getBoolean(true);
            if (BuildCraftCore.modifyWorld) {
                springBlock = new BlockSpring(Integer.parseInt(springId.value)).b("eternalSpring");
                GameRegistry.registerBlock((amq)springBlock, (String)"eternalSpring");
            }
            woodenGearItem = new ItemBuildCraft(Integer.parseInt(woodenGearId.value)).c(16).b("woodenGearItem");
            LanguageRegistry.addName((Object)woodenGearItem, (String)"Wooden Gear");
            stoneGearItem = new ItemBuildCraft(Integer.parseInt(stoneGearId.value)).c(17).b("stoneGearItem");
            LanguageRegistry.addName((Object)stoneGearItem, (String)"Stone Gear");
            ironGearItem = new ItemBuildCraft(Integer.parseInt(ironGearId.value)).c(18).b("ironGearItem");
            LanguageRegistry.addName((Object)ironGearItem, (String)"Iron Gear");
            goldGearItem = new ItemBuildCraft(Integer.parseInt(goldenGearId.value)).c(19).b("goldGearItem");
            LanguageRegistry.addName((Object)goldGearItem, (String)"Gold Gear");
            diamondGearItem = new ItemBuildCraft(Integer.parseInt(diamondGearId.value)).c(20).b("diamondGearItem");
            LanguageRegistry.addName((Object)diamondGearItem, (String)"Diamond Gear");
        }
        finally {
            mainConfiguration.save();
        }
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent evt) {
        ActionManager.registerTriggerProvider(new DefaultTriggerProvider());
        ActionManager.registerActionProvider(new DefaultActionProvider());
        if (modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)new SpringPopulate());
        }
        if (loadDefaultRecipes) {
            this.loadRecipes();
        }
        EntityRegistry.registerModEntity(EntityRobot.class, (String)"bcRobot", (int)10, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityPowerLaser.class, (String)"bcLaser", (int)30, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnergyLaser.class, (String)"bcEnergyLaser", (int)20, (Object)instance, (int)50, (int)1, (boolean)true);
        lv.c.remove(EntityRobot.class);
        lv.c.remove(EntityPowerLaser.class);
        lv.c.remove(EntityEnergyLaser.class);
        lv.b.remove("BuildCraft|Core.bcRobot");
        lv.b.remove("BuildCraft|Core.bcLaser");
        lv.b.remove("BuildCraft|Core.bcEnergyLaser");
        CoreProxy.proxy.initializeRendering();
        CoreProxy.proxy.initializeEntityRendering();
        Localization.addLocalization("/lang/buildcraft/", "en_US");
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        for (amq block : amq.p) {
            if (!(block instanceof akx) && !(block instanceof IPlantable)) continue;
            BuildCraftAPI.softBlocks[block.cm] = true;
        }
        BuildCraftAPI.softBlocks[amq.aV.cm] = true;
        BuildCraftAPI.softBlocks[amq.bx.cm] = true;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerCoreClient(), (Side)Side.CLIENT);
    }

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((y)new CommandBuildCraft());
    }

    public void loadRecipes() {
        GameRegistry.addRecipe((ur)new ur(wrenchItem), (Object[])new Object[]{"I I", " G ", " I ", Character.valueOf('I'), up.o, Character.valueOf('G'), stoneGearItem});
        GameRegistry.addRecipe((ur)new ur(woodenGearItem), (Object[])new Object[]{" S ", "S S", " S ", Character.valueOf('S'), up.D});
        GameRegistry.addRecipe((ur)new ur(stoneGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), amq.z, Character.valueOf('G'), woodenGearItem});
        GameRegistry.addRecipe((ur)new ur(ironGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), up.o, Character.valueOf('G'), stoneGearItem});
        GameRegistry.addRecipe((ur)new ur(goldGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), up.p, Character.valueOf('G'), ironGearItem});
        GameRegistry.addRecipe((ur)new ur(diamondGearItem), (Object[])new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), up.n, Character.valueOf('G'), goldGearItem});
    }

    static {
        bufferedDescriptions = new TreeMap();
        triggerMachineActive = new TriggerMachine(DefaultProps.TRIGGER_MACHINE_ACTIVE, true);
        triggerMachineInactive = new TriggerMachine(DefaultProps.TRIGGER_MACHINE_INACTIVE, false);
        triggerEmptyInventory = new TriggerInventory(DefaultProps.TRIGGER_EMPTY_INVENTORY, TriggerInventory.State.Empty);
        triggerContainsInventory = new TriggerInventory(DefaultProps.TRIGGER_CONTAINS_INVENTORY, TriggerInventory.State.Contains);
        triggerSpaceInventory = new TriggerInventory(DefaultProps.TRIGGER_SPACE_INVENTORY, TriggerInventory.State.Space);
        triggerFullInventory = new TriggerInventory(DefaultProps.TRIGGER_FULL_INVENTORY, TriggerInventory.State.Full);
        triggerEmptyLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_EMPTY_LIQUID, TriggerLiquidContainer.State.Empty);
        triggerContainsLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_CONTAINS_LIQUID, TriggerLiquidContainer.State.Contains);
        triggerSpaceLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_SPACE_LIQUID, TriggerLiquidContainer.State.Space);
        triggerFullLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_FULL_LIQUID, TriggerLiquidContainer.State.Full);
        triggerRedstoneActive = new TriggerRedstoneInput(DefaultProps.TRIGGER_REDSTONE_ACTIVE, true);
        triggerRedstoneInactive = new TriggerRedstoneInput(DefaultProps.TRIGGER_REDSTONE_INACTIVE, false);
        actionRedstone = new ActionRedstoneOutput(DefaultProps.ACTION_REDSTONE);
        actionOn = new ActionMachineControl(DefaultProps.ACTION_ON, ActionMachineControl.Mode.On);
        actionOff = new ActionMachineControl(DefaultProps.ACTION_OFF, ActionMachineControl.Mode.Off);
        actionLoop = new ActionMachineControl(DefaultProps.ACTION_LOOP, ActionMachineControl.Mode.Loop);
        loadDefaultRecipes = true;
        forcePneumaticPower = true;
        consumeWaterSources = true;
        itemBptProps = new BptItem[up.e.length];
        bcLog = Logger.getLogger("Buildcraft");
    }

    public static enum RenderMode {
        Full,
        NoDynamic;

    }
}

