/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.core.DefaultProps;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockFrame;
import buildcraft.factory.BlockHopper;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockQuarry;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.BptBlockAutoWorkbench;
import buildcraft.factory.BptBlockFrame;
import buildcraft.factory.BptBlockRefinery;
import buildcraft.factory.BptBlockTank;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.GuiHandler;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileQuarry;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.network.PacketHandlerFactory;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.Property;

@Mod(name="BuildCraft Factory", version="3.4.3", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@3.4.3")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerFactory.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftFactory {
    public static BlockQuarry quarryBlock;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockFrame frameBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockHopper hopperBlock;
    public static boolean hopperDisabled;
    public static int drillTexture;
    public static boolean allowMining;
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        FactoryProxy.proxy.initializeNEIIntegration();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new QuarryChunkloadCallback());
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileQuarry.class, "Machine");
        CoreProxy.proxy.registerTileEntity(TileMiningWell.class, "MiningWell");
        CoreProxy.proxy.registerTileEntity(TileAutoWorkbench.class, "AutoWorkbench");
        CoreProxy.proxy.registerTileEntity(TilePump.class, "net.minecraft.src.buildcraft.factory.TilePump");
        CoreProxy.proxy.registerTileEntity(TileTank.class, "net.minecraft.src.buildcraft.factory.TileTank");
        CoreProxy.proxy.registerTileEntity(TileRefinery.class, "net.minecraft.src.buildcraft.factory.Refinery");
        if (!hopperDisabled) {
            CoreProxy.proxy.registerTileEntity(TileHopper.class, "net.minecraft.src.buildcraft.factory.TileHopper");
        }
        FactoryProxy.proxy.initializeTileEntities();
        FactoryProxy.proxy.initializeEntityRenders();
        drillTexture = 33;
        new BptBlockAutoWorkbench(BuildCraftFactory.autoWorkbenchBlock.cm);
        new BptBlockFrame(BuildCraftFactory.frameBlock.cm);
        new BptBlockRefinery(BuildCraftFactory.refineryBlock.cm);
        new BptBlockTank(BuildCraftFactory.tankBlock.cm);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    @Mod.PreInit
    public void initialize(FMLPreInitializationEvent evt) {
        allowMining = Boolean.parseBoolean(BuildCraftCore.mainConfiguration.get((String)"general", (String)"mining.enabled", (boolean)true).value);
        Property minigWellId = BuildCraftCore.mainConfiguration.getBlock("miningWell.id", DefaultProps.MINING_WELL_ID);
        Property plainPipeId = BuildCraftCore.mainConfiguration.getBlock("drill.id", DefaultProps.DRILL_ID);
        Property autoWorkbenchId = BuildCraftCore.mainConfiguration.getBlock("autoWorkbench.id", DefaultProps.AUTO_WORKBENCH_ID);
        Property frameId = BuildCraftCore.mainConfiguration.getBlock("frame.id", DefaultProps.FRAME_ID);
        Property quarryId = BuildCraftCore.mainConfiguration.getBlock("quarry.id", DefaultProps.QUARRY_ID);
        Property pumpId = BuildCraftCore.mainConfiguration.getBlock("pump.id", DefaultProps.PUMP_ID);
        Property tankId = BuildCraftCore.mainConfiguration.getBlock("tank.id", DefaultProps.TANK_ID);
        Property refineryId = BuildCraftCore.mainConfiguration.getBlock("refinery.id", DefaultProps.REFINERY_ID);
        Property hopperId = BuildCraftCore.mainConfiguration.getBlock("hopper.id", DefaultProps.HOPPER_ID);
        Property hopperDisable = BuildCraftCore.mainConfiguration.get("Block Savers", "hopper.disabled", false);
        BuildCraftCore.mainConfiguration.save();
        miningWellBlock = new BlockMiningWell(Integer.parseInt(minigWellId.value));
        CoreProxy.proxy.registerBlock(miningWellBlock.b("miningWellBlock"));
        CoreProxy.proxy.addName((Object)miningWellBlock, "Mining Well");
        plainPipeBlock = new BlockPlainPipe(Integer.parseInt(plainPipeId.value));
        CoreProxy.proxy.registerBlock(plainPipeBlock.b("plainPipeBlock"));
        CoreProxy.proxy.addName(plainPipeBlock, "Mining Pipe");
        autoWorkbenchBlock = new BlockAutoWorkbench(Integer.parseInt(autoWorkbenchId.value));
        CoreProxy.proxy.registerBlock(autoWorkbenchBlock.b("autoWorkbenchBlock"));
        CoreProxy.proxy.addName((Object)autoWorkbenchBlock, "Automatic Crafting Table");
        frameBlock = new BlockFrame(Integer.parseInt(frameId.value));
        CoreProxy.proxy.registerBlock(frameBlock.b("frameBlock"));
        CoreProxy.proxy.addName(frameBlock, "Frame");
        quarryBlock = new BlockQuarry(Integer.parseInt(quarryId.value));
        CoreProxy.proxy.registerBlock(quarryBlock.b("machineBlock"));
        CoreProxy.proxy.addName((Object)quarryBlock, "Quarry");
        tankBlock = new BlockTank(Integer.parseInt(tankId.value));
        CoreProxy.proxy.registerBlock(tankBlock.b("tankBlock"));
        CoreProxy.proxy.addName((Object)tankBlock, "Tank");
        pumpBlock = new BlockPump(Integer.parseInt(pumpId.value));
        CoreProxy.proxy.registerBlock(pumpBlock.b("pumpBlock"));
        CoreProxy.proxy.addName((Object)pumpBlock, "Pump");
        refineryBlock = new BlockRefinery(Integer.parseInt(refineryId.value));
        CoreProxy.proxy.registerBlock(refineryBlock.b("refineryBlock"));
        CoreProxy.proxy.addName((Object)refineryBlock, "Refinery");
        hopperDisabled = Boolean.parseBoolean(hopperDisable.value);
        if (!hopperDisabled) {
            hopperBlock = new BlockHopper(Integer.parseInt(hopperId.value));
            CoreProxy.proxy.registerBlock(hopperBlock.b("blockHopper"));
            CoreProxy.proxy.addName((Object)hopperBlock, "Hopper");
        }
        BuildCraftCore.mainConfiguration.save();
    }

    public static void loadRecipes() {
        if (allowMining) {
            CoreProxy.proxy.addCraftingRecipe(new ur((amq)miningWellBlock, 1), new Object[]{"ipi", "igi", "iPi", Character.valueOf('p'), up.aC, Character.valueOf('i'), up.o, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('P'), up.g});
            CoreProxy.proxy.addCraftingRecipe(new ur((amq)quarryBlock), new Object[]{"ipi", "gig", "dDd", Character.valueOf('i'), BuildCraftCore.ironGearItem, Character.valueOf('p'), up.aC, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('D'), up.B});
            CoreProxy.proxy.addCraftingRecipe(new ur((amq)pumpBlock), new Object[]{"T ", "W ", Character.valueOf('T'), tankBlock, Character.valueOf('W'), miningWellBlock});
        } else {
            CoreProxy.proxy.addCraftingRecipe(new ur((amq)pumpBlock), new Object[]{"iri", "iTi", "gpg", Character.valueOf('r'), up.aC, Character.valueOf('i'), up.o, Character.valueOf('T'), tankBlock, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('p'), BuildCraftTransport.pipeLiquidsGold});
        }
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)autoWorkbenchBlock), new Object[]{" g ", "gwg", " g ", Character.valueOf('w'), amq.aB, Character.valueOf('g'), BuildCraftCore.woodenGearItem});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)tankBlock), new Object[]{"ggg", "g g", "ggg", Character.valueOf('g'), amq.P});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)refineryBlock), new Object[]{"   ", "RTR", "TGT", Character.valueOf('T'), tankBlock, Character.valueOf('G'), BuildCraftCore.diamondGearItem, Character.valueOf('R'), amq.aT});
        if (!hopperDisabled) {
            CoreProxy.proxy.addCraftingRecipe(new ur((amq)hopperBlock), new Object[]{"ICI", "IGI", " I ", Character.valueOf('I'), up.o, Character.valueOf('C'), amq.ax, Character.valueOf('G'), BuildCraftCore.stoneGearItem});
        }
    }

    static {
        allowMining = true;
    }

    public class QuarryChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List tickets, yc world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryX = ticket.getModData().e("quarryX");
                int quarryY = ticket.getModData().e("quarryY");
                int quarryZ = ticket.getModData().e("quarryZ");
                TileQuarry tq = (TileQuarry)world.q(quarryX, quarryY, quarryZ);
                tq.forceChunkLoading(ticket);
            }
        }

        public List ticketsLoaded(List tickets, yc world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().e("quarryX");
                int blId = world.a(quarryX, quarryY = ticket.getModData().e("quarryY"), quarryZ = ticket.getModData().e("quarryZ"));
                if (blId != BuildCraftFactory.quarryBlock.cm) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

