/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.transport.IPassiveItemContribution;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.proxy.CoreProxy;
import java.util.TreeMap;
import net.minecraftforge.common.ForgeDirection;

public class EntityPassiveItem
implements IPipedItem {
    private TreeMap contributions = new TreeMap();
    protected static int maxId = 0;
    protected yc worldObj;
    protected float speed = 0.01f;
    protected ur item;
    protected any container;
    @Deprecated
    protected SafeTimeTracker synchroTracker = new SafeTimeTracker();
    @Deprecated
    protected int deterministicRandomization = 0;
    protected Position position;
    protected int entityId;

    public EntityPassiveItem(yc world) {
        this(world, maxId < Short.MAX_VALUE ? (maxId = maxId + 1) : (maxId = Short.MIN_VALUE));
    }

    public EntityPassiveItem(yc world, int id) {
        this.setEntityId(id);
        this.worldObj = world;
    }

    public EntityPassiveItem(yc world, double d, double d1, double d2) {
        this(world);
        this.position = new Position(d, d1, d2);
        this.worldObj = world;
    }

    public EntityPassiveItem(yc world, double d, double d1, double d2, ur itemstack) {
        this(world, d, d1, d2);
        this.setItemStack(itemstack.l());
    }

    public static IPipedItem getOrCreate(yc world, int id) {
        return new EntityPassiveItem(world, id);
    }

    @Override
    public void remove() {
    }

    @Override
    public void setWorld(yc world) {
        this.worldObj = world;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(double x, double y2, double z) {
        this.position = new Position(x, y2, z);
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public ur getItemStack() {
        return this.item;
    }

    @Override
    public void setItemStack(ur item) {
        this.item = item;
    }

    @Override
    public any getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(any container) {
        this.container = container;
    }

    @Override
    @Deprecated
    public SafeTimeTracker getSynchroTracker() {
        return this.synchroTracker;
    }

    @Override
    @Deprecated
    public void setSynchroTracker(SafeTimeTracker synchroTracker) {
        this.synchroTracker = synchroTracker;
    }

    @Override
    @Deprecated
    public int getDeterministicRandomization() {
        return this.deterministicRandomization;
    }

    @Override
    @Deprecated
    public void setDeterministicRandomization(int deterministicRandomization) {
        this.deterministicRandomization = deterministicRandomization;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.setPosition(nbttagcompound.h("x"), nbttagcompound.h("y"), nbttagcompound.h("z"));
        this.setSpeed(nbttagcompound.g("speed"));
        this.setItemStack(ur.a((bq)nbttagcompound.l("Item")));
        by contribList = nbttagcompound.m("contribList");
        for (int i = 0; i < contribList.c(); ++i) {
            bq cpt = (bq)contribList.b(i);
            String key = cpt.i("key");
            String className = cpt.i("class");
            if (this.getClass().getName().startsWith("net.minecraft.src")) {
                className = "net.minecraft.src." + className;
            }
            try {
                IPassiveItemContribution contrib = (IPassiveItemContribution)Class.forName(className).newInstance();
                contrib.readFromNBT(cpt);
                this.contributions.put(key, contrib);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("x", this.position.x);
        nbttagcompound.a("y", this.position.y);
        nbttagcompound.a("z", this.position.z);
        nbttagcompound.a("speed", this.getSpeed());
        bq nbttagcompound2 = new bq();
        this.getItemStack().b(nbttagcompound2);
        nbttagcompound.a("Item", nbttagcompound2);
        by contribList = new by();
        for (String key : this.contributions.keySet()) {
            IPassiveItemContribution contrib = (IPassiveItemContribution)this.contributions.get(key);
            bq cpt = new bq();
            contrib.writeToNBT(cpt);
            cpt.a("key", key);
            String className = contrib.getClass().getName();
            if (className.startsWith("net.minecraft.src.")) {
                className = className.replace("net.minecraft.src.", "");
            }
            cpt.a("class", className);
            contribList.a((cd)cpt);
        }
        nbttagcompound.a("contribList", (cd)contribList);
    }

    @Override
    public px toEntityItem(ForgeDirection dir) {
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            if (this.getItemStack().a <= 0) {
                return null;
            }
            Position motion = new Position(0.0, 0.0, 0.0, dir);
            motion.moveForwards(0.1 + (double)(this.getSpeed() * 2.0f));
            px entityitem = new px(this.worldObj, this.position.x, this.position.y, this.position.z, this.getItemStack());
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.b = 10;
            float f3 = 0.0f + this.worldObj.t.nextFloat() * 0.04f - 0.02f;
            entityitem.w = (double)((float)this.worldObj.t.nextGaussian() * f3) + motion.x;
            entityitem.x = (double)((float)this.worldObj.t.nextGaussian() * f3) + motion.y;
            entityitem.y = (double)((float)this.worldObj.t.nextGaussian() * f3) + motion.z;
            this.worldObj.d((lq)entityitem);
            this.remove();
            return entityitem;
        }
        return null;
    }

    @Override
    public float getEntityBrightness(float f) {
        int i = ke.c((double)this.position.x);
        int j = ke.c((double)this.position.z);
        this.worldObj.getClass();
        if (this.worldObj.f(i, 64, j)) {
            double d = 0.66;
            int k = ke.c((double)(this.position.y + d));
            return this.worldObj.p(i, k, j);
        }
        return 0.0f;
    }

    @Override
    public boolean isCorrupted() {
        return this.getItemStack() == null || this.getItemStack().a <= 0 || up.e[this.getItemStack().c] == null;
    }

    @Override
    public void addContribution(String key, IPassiveItemContribution contribution) {
        this.contributions.put(key, contribution);
    }

    @Override
    public IPassiveItemContribution getContribution(String key) {
        return (IPassiveItemContribution)this.contributions.get(key);
    }

    @Override
    public boolean hasContributions() {
        return this.contributions.size() > 0;
    }
}

