/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptSlot;
import buildcraft.core.utils.BlockUtil;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class BptBuilderBlueprint
extends BptBuilderBase {
    LinkedList clearList = new LinkedList();
    LinkedList primaryList = new LinkedList();
    LinkedList secondaryList = new LinkedList();
    LinkedList postProcessingList = new LinkedList();
    public TreeSet neededItems = new TreeSet(new Comparator(){

        public int compare(ur o1, ur o2) {
            if (o1.a > o2.a) {
                return -1;
            }
            if (o1.a < o2.a) {
                return 1;
            }
            if (o1.c > o2.c) {
                return -1;
            }
            if (o1.c < o2.c) {
                return 1;
            }
            if (o1.j() > o2.j()) {
                return -1;
            }
            if (o1.j() < o2.j()) {
                return 1;
            }
            return 0;
        }
    });

    public BptBuilderBlueprint(BptBlueprint bluePrint, yc world, int x, int y2, int z) {
        super(bluePrint, world, x, y2, z);
        BptSlot slot;
        int zCoord;
        int yCoord;
        int xCoord;
        int k;
        int i;
        int j;
        for (j = bluePrint.sizeY - 1; j >= 0; --j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y2 - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.ClearIfInvalid;
                    this.clearList.add(slot);
                }
            }
        }
        for (j = 0; j < bluePrint.sizeY; ++j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y2 - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.Build;
                    if (slot.blockId != 0 && amq.p[slot.blockId].c()) {
                        this.primaryList.add(slot);
                    } else {
                        this.secondaryList.add(slot);
                    }
                    if (slot.blockId == 0) continue;
                    this.postProcessingList.add(slot.clone());
                }
            }
        }
        this.recomputeNeededItems();
    }

    private void checkDone() {
        this.recomputeNeededItems();
        this.done = this.clearList.size() == 0 && this.primaryList.size() == 0 && this.secondaryList.size() == 0;
    }

    @Override
    public BptSlot getNextBlock(yc world, IBuilderInventory inv) {
        if (this.clearList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.clearList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.primaryList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.primaryList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.secondaryList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.secondaryList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        this.checkDone();
        return null;
    }

    public BptSlot internalGetNextBlock(yc world, IBuilderInventory inv, LinkedList list) {
        LinkedList<BptSlot> failSlots = new LinkedList<BptSlot>();
        BptSlot result = null;
        while (list.size() > 0) {
            BptSlot slot = (BptSlot)list.removeFirst();
            boolean getNext = false;
            try {
                getNext = !slot.isValid(this.context) && !slot.ignoreBuilding();
            }
            catch (Throwable t) {
                t.printStackTrace();
                BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "internalGetBlock", t);
                getNext = false;
            }
            if (!getNext) continue;
            if (slot.mode == BptSlot.Mode.ClearIfInvalid) {
                if (BlockUtil.isSoftBlock(world, slot.x, slot.y, slot.z)) continue;
                result = slot;
                break;
            }
            if (world.K().r() == yl.c) {
                result = slot;
                break;
            }
            if (this.checkRequirements(inv, slot)) {
                this.useRequirements(inv, slot);
                result = slot;
                break;
            }
            failSlots.add(slot);
        }
        list.addAll(failSlots);
        return result;
    }

    public boolean checkRequirements(IBuilderInventory inv, BptSlot slot) {
        if (slot.blockId == 0) {
            return true;
        }
        LinkedList<ur> tmpReq = new LinkedList<ur>();
        LinkedList<ur> tmpInv = new LinkedList<ur>();
        try {
            for (ur stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "checkRequirements", t);
        }
        int size = inv.k_();
        for (int i = 0; i < size; ++i) {
            if (!inv.isBuildingMaterial(i) || inv.a(i) == null) continue;
            tmpInv.add(inv.a(i).l());
        }
        for (ur reqStk : tmpReq) {
            for (ur invStk : tmpInv) {
                if (invStk == null || reqStk.c != invStk.c || invStk.a <= 0 || !invStk.f() && reqStk.j() != invStk.j()) continue;
                try {
                    slot.useItem(this.context, reqStk, invStk);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "checkRequirements", t);
                }
                if (reqStk.a != 0) continue;
                break;
            }
            if (reqStk.a == 0) continue;
            return false;
        }
        return true;
    }

    public void useRequirements(IBuilderInventory inv, BptSlot slot) {
        if (slot.blockId == 0) {
            return;
        }
        LinkedList<ur> tmpReq = new LinkedList<ur>();
        try {
            for (ur stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "useRequirements", t);
        }
        ListIterator<ur> itr = tmpReq.listIterator();
        while (itr.hasNext()) {
            ur reqStk = (ur)itr.next();
            boolean smallStack = reqStk.a == 1;
            ur usedStack = reqStk;
            int size = inv.k_();
            for (int i = 0; i <= size; ++i) {
                ur invStk;
                if (!inv.isBuildingMaterial(i)) {
                    // empty if block
                }
                if ((invStk = inv.a(i)) == null || reqStk.c != invStk.c || invStk.a <= 0 || !invStk.f() && reqStk.j() != invStk.j()) continue;
                try {
                    usedStack = slot.useItem(this.context, reqStk, invStk);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "useRequirements", t);
                }
                if (invStk.a == 0) {
                    inv.a(i, null);
                } else {
                    inv.a(i, invStk);
                }
                if (reqStk.a == 0) break;
            }
            if (reqStk.a != 0) {
                return;
            }
            if (!smallStack) continue;
            itr.set(usedStack);
        }
    }

    public void recomputeNeededItems() {
        Integer num;
        LinkedList stacks;
        this.neededItems.clear();
        TreeMap<ur, Integer> computeStacks = new TreeMap<ur, Integer>(new Comparator(){

            public int compare(ur o1, ur o2) {
                if (o1.c > o2.c) {
                    return 1;
                }
                if (o1.c < o2.c) {
                    return -1;
                }
                if (o1.j() > o2.j()) {
                    return 1;
                }
                if (o1.j() < o2.j()) {
                    return -1;
                }
                return 0;
            }
        });
        for (BptSlot slot : this.primaryList) {
            stacks = new LinkedList();
            try {
                stacks = slot.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "recomputeIfNeeded", t);
            }
            for (ur stack : stacks) {
                if (stack == null || stack.c == 0) continue;
                if (!computeStacks.containsKey(stack)) {
                    computeStacks.put(stack.l(), stack.a);
                    continue;
                }
                num = (Integer)computeStacks.get(stack);
                num = num + stack.a;
                computeStacks.put(stack, num);
            }
        }
        for (BptSlot slot : this.secondaryList) {
            stacks = slot.getRequirements(this.context);
            for (ur stack : stacks) {
                if (stack == null || stack.c <= 0 || stack.c >= up.e.length || stack.a == 0 || stack.b() == null) continue;
                if (!computeStacks.containsKey(stack)) {
                    computeStacks.put(stack.l(), stack.a);
                    continue;
                }
                num = (Integer)computeStacks.get(stack);
                num = num + stack.a;
                computeStacks.put(stack, num);
            }
        }
        for (ur stack : computeStacks.keySet()) {
            if (stack.f()) {
                this.neededItems.add(new ur(stack.b()));
                continue;
            }
            this.neededItems.add(new ur(stack.c, ((Integer)computeStacks.get(stack)).intValue(), stack.j()));
        }
    }

    @Override
    public void postProcessing(yc world) {
        for (BptSlot s : this.postProcessingList) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BuildCraftCore.bcLog.throwing("BptBuilderBlueprint", "postProcessing", t);
            }
        }
    }
}

