/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.Box;
import buildcraft.core.DefaultAreaProvider;
import buildcraft.core.EntityRobot;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.IMachine;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.factory.EntityMechanicalArm;
import buildcraft.factory.TileMachine;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;

public class TileQuarry
extends TileMachine
implements IMachine,
IPowerReceptor,
IPipeConnection,
IBuilderInventory {
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public boolean inProcess = false;
    @TileNetworkData
    public int targetX;
    @TileNetworkData
    public int targetY;
    @TileNetworkData
    public int targetZ;
    @TileNetworkData
    public double headPosX;
    @TileNetworkData
    public double headPosY;
    @TileNetworkData
    public double headPosZ;
    @TileNetworkData
    public double speed = 0.03;
    @TileNetworkData
    public boolean builderDone = false;
    public EntityRobot builder;
    BptBuilderBase bluePrintBuilder;
    public EntityMechanicalArm arm;
    public IPowerProvider powerProvider;
    boolean isDigging = false;
    public static int MAX_ENERGY = 15000;
    private boolean loadDefaultBoundaries = false;
    private boolean movingHorizontally;
    private boolean movingVertically;
    private double headTrajectory;
    private ForgeChunkManager.Ticket chunkTicket;
    @TileNetworkData
    public boolean isAlive;
    public qx placedBy;
    private LinkedList visitList = Lists.newLinkedList();

    public TileQuarry() {
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(20, 25, 100, 25, MAX_ENERGY);
    }

    public void createUtilsIfNeeded() {
        if (this.bluePrintBuilder == null) {
            if (!this.box.isInitialized()) {
                this.setBoundaries(this.loadDefaultBoundaries);
            }
            this.initializeBluePrintBuilder();
        }
        if (this.builderDone) {
            this.box.deleteLasers();
            if (this.arm == null) {
                this.createArm();
            }
            if (this.findTarget(false)) {
                this.isDigging = true;
                if (this.box != null && (this.headPosX < (double)this.box.xMin || this.headPosX > (double)this.box.xMax || this.headPosZ < (double)this.box.zMin || this.headPosZ > (double)this.box.zMax)) {
                    this.setHead(this.box.xMin + 1, this.m + 2, this.box.zMin + 1);
                }
            }
        } else {
            this.box.createLasers(this.k, LaserKind.Stripes);
            this.isDigging = true;
        }
    }

    private void createArm() {
        this.k.d((lq)new EntityMechanicalArm(this.k, (float)this.box.xMin + 0.75f, (float)(this.m + this.bluePrintBuilder.bluePrint.sizeY - 1) + 0.25f, (float)this.box.zMin + 0.75f, (float)(this.bluePrintBuilder.bluePrint.sizeX - 2) + 0.5f, (float)(this.bluePrintBuilder.bluePrint.sizeZ - 2) + 0.5f, this));
    }

    public void setArm(EntityMechanicalArm arm) {
        this.arm = arm;
    }

    @Override
    public void g() {
        float energyToUse;
        float energy;
        if (!this.isAlive && CoreProxy.proxy.isSimulating(this.k)) {
            super.g();
            return;
        }
        if (!CoreProxy.proxy.isSimulating(this.k) && this.isAlive) {
            super.g();
            return;
        }
        super.g();
        if (this.inProcess && (energy = this.powerProvider.useEnergy(energyToUse = 2.0f + this.powerProvider.getEnergyStored() / 500.0f, energyToUse, true)) > 0.0f) {
            this.moveHead(0.1 + (double)(energy / 200.0f));
        }
        if (CoreProxy.proxy.isSimulating(this.k) && this.inProcess) {
            this.sendNetworkUpdate();
        }
        if (this.inProcess || !this.isDigging) {
            return;
        }
        this.createUtilsIfNeeded();
        if (this.bluePrintBuilder != null) {
            this.builderDone = this.bluePrintBuilder.done;
            if (!this.builderDone) {
                this.buildFrame();
                return;
            }
            if (this.builder != null && this.builder.done()) {
                this.box.deleteLasers();
                this.builder.x();
                this.builder = null;
            }
        }
        if (this.builder == null) {
            this.dig();
        }
    }

    @Override
    public void doWork() {
    }

    protected void buildFrame() {
        this.powerProvider.configure(20, 25, 100, 25, MAX_ENERGY);
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) != 25.0f) {
            return;
        }
        this.powerProvider.getTimeTracker().markTime(this.k);
        if (this.builder == null) {
            this.builder = new EntityRobot(this.k, this.box);
            this.k.d((lq)this.builder);
        }
        if (this.builder.readyToBuild()) {
            this.builder.scheduleContruction(this.bluePrintBuilder.getNextBlock(this.k, this), this.bluePrintBuilder.getContext());
        }
    }

    protected void dig() {
        this.powerProvider.configure(20, 30, 500, 50, MAX_ENERGY);
        if (this.powerProvider.useEnergy(60.0f, 60.0f, true) != 60.0f) {
            return;
        }
        if (!this.findTarget(true)) {
            if (this.arm != null && this.box != null) {
                this.setTarget(this.box.xMin + 1, this.m + 2, this.box.zMin + 1);
            }
            this.isDigging = false;
        }
        this.inProcess = true;
        this.movingHorizontally = true;
        this.movingVertically = true;
        double[] head = this.getHead();
        int[] target = this.getTarget();
        this.headTrajectory = Math.atan2((double)target[2] - head[2], (double)target[0] - head[0]);
    }

    public boolean findTarget(boolean doSet) {
        int[] target;
        boolean alternativeTarget;
        if (this.k.I) {
            return false;
        }
        if (this.visitList.isEmpty()) {
            this.createColumnVisitList();
        }
        if (!doSet) {
            return !this.visitList.isEmpty();
        }
        if (this.visitList.isEmpty()) {
            return false;
        }
        boolean foundTarget = false;
        block0: do {
            if (this.visitList.isEmpty()) {
                this.createColumnVisitList();
            }
            target = (int[])this.visitList.removeFirst();
            alternativeTarget = false;
            for (int y2 = target[1] + 1; y2 < this.m + 3; ++y2) {
                if (!BlockUtil.canChangeBlock(this.k, target[0], y2, target[2]) || BlockUtil.isSoftBlock(this.k, target[0], y2, target[2])) continue;
                this.createColumnVisitList();
                alternativeTarget = true;
                continue block0;
            }
        } while (!(foundTarget = !alternativeTarget));
        this.setTarget(target[0], target[1] + 1, target[2]);
        return true;
    }

    private void createColumnVisitList() {
        this.visitList.clear();
        boolean[][] blockedColumns = new boolean[this.bluePrintBuilder.bluePrint.sizeX - 2][this.bluePrintBuilder.bluePrint.sizeZ - 2];
        for (int searchY = this.m + 3; searchY >= 0; --searchY) {
            int incX;
            int endX;
            int startX;
            if (searchY % 2 == 0) {
                startX = 0;
                endX = this.bluePrintBuilder.bluePrint.sizeX - 2;
                incX = 1;
            } else {
                startX = this.bluePrintBuilder.bluePrint.sizeX - 3;
                endX = -1;
                incX = -1;
            }
            for (int searchX = startX; searchX != endX; searchX += incX) {
                int incZ;
                int endZ;
                int startZ;
                if (searchX % 2 == searchY % 2) {
                    startZ = 0;
                    endZ = this.bluePrintBuilder.bluePrint.sizeZ - 2;
                    incZ = 1;
                } else {
                    startZ = this.bluePrintBuilder.bluePrint.sizeZ - 3;
                    endZ = -1;
                    incZ = -1;
                }
                for (int searchZ = startZ; searchZ != endZ; searchZ += incZ) {
                    if (blockedColumns[searchX][searchZ]) continue;
                    int bx = this.box.xMin + searchX + 1;
                    int by2 = searchY;
                    int bz = this.box.zMin + searchZ + 1;
                    if (!BlockUtil.canChangeBlock(this.k, bx, by2, bz)) {
                        blockedColumns[searchX][searchZ] = true;
                    } else if (!BlockUtil.isSoftBlock(this.k, bx, by2, bz)) {
                        this.visitList.add(new int[]{bx, by2, bz});
                    }
                    if (this.visitList.size() <= this.bluePrintBuilder.bluePrint.sizeZ * this.bluePrintBuilder.bluePrint.sizeX * 2) continue;
                    return;
                }
            }
        }
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        if (nbttagcompound.b("box")) {
            this.box.initialize(nbttagcompound.l("box"));
            this.loadDefaultBoundaries = false;
        } else if (nbttagcompound.b("xSize")) {
            int xMin = nbttagcompound.e("xMin");
            int zMin = nbttagcompound.e("zMin");
            int xSize = nbttagcompound.e("xSize");
            int ySize = nbttagcompound.e("ySize");
            int zSize = nbttagcompound.e("zSize");
            this.box.initialize(xMin, this.m, zMin, xMin + xSize - 1, this.m + ySize - 1, zMin + zSize - 1);
            this.loadDefaultBoundaries = false;
        } else {
            this.loadDefaultBoundaries = true;
        }
        this.targetX = nbttagcompound.e("targetX");
        this.targetY = nbttagcompound.e("targetY");
        this.targetZ = nbttagcompound.e("targetZ");
        this.headPosX = nbttagcompound.h("headPosX");
        this.headPosY = nbttagcompound.h("headPosY");
        this.headPosZ = nbttagcompound.h("headPosZ");
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("targetX", this.targetX);
        nbttagcompound.a("targetY", this.targetY);
        nbttagcompound.a("targetZ", this.targetZ);
        nbttagcompound.a("headPosX", this.headPosX);
        nbttagcompound.a("headPosY", this.headPosY);
        nbttagcompound.a("headPosZ", this.headPosZ);
        bq boxTag = new bq();
        this.box.writeToNBT(boxTag);
        nbttagcompound.a("box", (cd)boxTag);
    }

    public void positionReached() {
        this.inProcess = false;
        if (this.k.I) {
            return;
        }
        int i = this.targetX;
        int j = this.targetY - 1;
        int k = this.targetZ;
        int blockId = this.k.a(i, j, k);
        if (this.isQuarriableBlock(i, j, k)) {
            this.powerProvider.getTimeTracker().markTime(this.k);
            List stacks = BlockUtil.getItemStackFromBlock(this.k, i, j, k);
            if (stacks != null) {
                for (ur s2 : stacks) {
                    if (s2 == null) continue;
                    this.mineStack(s2);
                }
            }
            this.k.a(null, 2001, i, j, k, blockId + (this.k.h(i, j, k) << 12));
            this.k.e(i, j, k, 0);
        }
        double[] head = this.getHead();
        aoe axis = aoe.a((double)(head[0] - 2.0), (double)(head[1] - 2.0), (double)(head[2] - 2.0), (double)(head[0] + 3.0), (double)(head[1] + 3.0), (double)(head[2] + 3.0));
        List result = this.k.a(px.class, axis);
        for (int ii = 0; ii < result.size(); ++ii) {
            if (!(result.get(ii) instanceof px)) continue;
            px entity = (px)result.get(ii);
            if (entity.L) continue;
            ur mineable = entity.d();
            if (mineable.a <= 0) continue;
            CoreProxy.proxy.removeEntity((lq)entity);
            this.mineStack(mineable);
        }
    }

    private void mineStack(ur stack) {
        ur added = Utils.addToRandomInventory(stack, this.k, this.l, this.m, this.n, ForgeDirection.UNKNOWN);
        stack.a -= added.a;
        if (stack.a > 0) {
            Utils.addToRandomPipeEntry(this, ForgeDirection.UNKNOWN, stack);
        }
        if (stack.a > 0) {
            float f = this.k.t.nextFloat() * 0.8f + 0.1f;
            float f1 = this.k.t.nextFloat() * 0.8f + 0.1f;
            float f2 = this.k.t.nextFloat() * 0.8f + 0.1f;
            px entityitem = new px(this.k, (double)((float)this.l + f), (double)((float)this.m + f1 + 0.5f), (double)((float)this.n + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.b = 10;
            float f3 = 0.05f;
            entityitem.w = (float)this.k.t.nextGaussian() * f3;
            entityitem.x = (float)this.k.t.nextGaussian() * f3 + 1.0f;
            entityitem.y = (float)this.k.t.nextGaussian() * f3;
            this.k.d((lq)entityitem);
        }
    }

    private boolean isQuarriableBlock(int bx, int by2, int bz) {
        return BlockUtil.canChangeBlock(this.k, bx, by2, bz) && !BlockUtil.isSoftBlock(this.k, bx, by2, bz);
    }

    @Override
    public void w_() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        super.w_();
        this.destroy();
    }

    public void onChunkUnload() {
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.arm != null) {
            this.arm.x();
        }
        if (this.builder != null) {
            this.builder.x();
        }
        this.box.deleteLasers();
        this.arm = null;
    }

    @Override
    public boolean isActive() {
        return this.isDigging;
    }

    private void setBoundaries(boolean useDefault) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)BuildCraftFactory.instance, (yc)this.k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.chunkTicket == null) {
            this.isAlive = false;
            if (this.placedBy != null && CoreProxy.proxy.isSimulating(this.k)) {
                PacketDispatcher.sendPacketToPlayer((ef)new cu(String.format("[BUILDCRAFT] The quarry at %d, %d, %d will not work because there are no more chunkloaders available", this.l, this.m, this.n)), (Player)((Player)this.placedBy));
            }
            this.sendNetworkUpdate();
            return;
        }
        this.chunkTicket.getModData().a("quarryX", this.l);
        this.chunkTicket.getModData().a("quarryY", this.m);
        this.chunkTicket.getModData().a("quarryZ", this.n);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (xv)new xv(this.l >> 4, this.n >> 4));
        IAreaProvider a = null;
        if (!useDefault) {
            a = Utils.getNearbyAreaProvider(this.k, this.l, this.m, this.n);
        }
        if (a == null) {
            a = new DefaultAreaProvider(this.l, this.m, this.n, this.l + 10, this.m + 4, this.n + 10);
            useDefault = true;
        }
        int xSize = a.xMax() - a.xMin() + 1;
        int ySize = a.yMax() - a.yMin() + 1;
        int zSize = a.zMax() - a.zMin() + 1;
        if (xSize < 3 || zSize < 3 || xSize * zSize >> 8 >= this.chunkTicket.getMaxChunkListDepth()) {
            if (this.placedBy != null) {
                PacketDispatcher.sendPacketToPlayer((ef)new cu(String.format("Quarry size is outside of chunkloading bounds or too small %d %d (%d)", xSize, zSize, this.chunkTicket.getMaxChunkListDepth())), (Player)((Player)this.placedBy));
            }
            a = new DefaultAreaProvider(this.l, this.m, this.n, this.l + 10, this.m + 4, this.n + 10);
            useDefault = true;
        }
        xSize = a.xMax() - a.xMin() + 1;
        ySize = a.yMax() - a.yMin() + 1;
        zSize = a.zMax() - a.zMin() + 1;
        this.box.initialize(a);
        if (ySize < 5) {
            ySize = 5;
            this.box.yMax = this.box.yMin + ySize - 1;
        }
        if (useDefault) {
            int xMin = 0;
            int zMin = 0;
            ForgeDirection o = ForgeDirection.values()[this.k.h(this.l, this.m, this.n)].getOpposite();
            switch (o) {
                case EAST: {
                    xMin = this.l + 1;
                    zMin = this.n - 4 - 1;
                    break;
                }
                case WEST: {
                    xMin = this.l - 9 - 2;
                    zMin = this.n - 4 - 1;
                    break;
                }
                case SOUTH: {
                    xMin = this.l - 4 - 1;
                    zMin = this.n + 1;
                    break;
                }
                default: {
                    xMin = this.l - 4 - 1;
                    zMin = this.n - 9 - 2;
                }
            }
            this.box.initialize(xMin, this.m, zMin, xMin + xSize - 1, this.m + ySize - 1, zMin + zSize - 1);
        }
        a.removeFromWorld();
        this.forceChunkLoading(this.chunkTicket);
    }

    private void initializeBluePrintBuilder() {
        BptBlueprint bluePrint = new BptBlueprint(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
        for (int i = 0; i < bluePrint.sizeX; ++i) {
            for (int j = 0; j < bluePrint.sizeY; ++j) {
                for (int k = 0; k < bluePrint.sizeZ; ++k) {
                    bluePrint.setBlockId(i, j, k, 0);
                }
            }
        }
        for (int it = 0; it < 2; ++it) {
            for (int i = 0; i < bluePrint.sizeX; ++i) {
                bluePrint.setBlockId(i, it * (this.box.sizeY() - 1), 0, BuildCraftFactory.frameBlock.cm);
                bluePrint.setBlockId(i, it * (this.box.sizeY() - 1), bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.cm);
            }
            for (int k = 0; k < bluePrint.sizeZ; ++k) {
                bluePrint.setBlockId(0, it * (this.box.sizeY() - 1), k, BuildCraftFactory.frameBlock.cm);
                bluePrint.setBlockId(bluePrint.sizeX - 1, it * (this.box.sizeY() - 1), k, BuildCraftFactory.frameBlock.cm);
            }
        }
        for (int h = 1; h < this.box.sizeY(); ++h) {
            bluePrint.setBlockId(0, h, 0, BuildCraftFactory.frameBlock.cm);
            bluePrint.setBlockId(0, h, bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.cm);
            bluePrint.setBlockId(bluePrint.sizeX - 1, h, 0, BuildCraftFactory.frameBlock.cm);
            bluePrint.setBlockId(bluePrint.sizeX - 1, h, bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.cm);
        }
        this.bluePrintBuilder = new BptBuilderBlueprint(bluePrint, this.k, this.box.xMin, this.m, this.box.zMin);
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
        super.postPacketHandling(packet);
        if (!this.isAlive) {
            this.box.deleteLasers();
            this.box.reset();
            return;
        }
        this.createUtilsIfNeeded();
        if (this.arm != null) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (CoreProxy.proxy.isSimulating(this.k) && !this.box.initialized) {
            this.setBoundaries(false);
        }
        this.createUtilsIfNeeded();
        this.sendNetworkUpdate();
    }

    public void reinitalize() {
        this.builderDone = false;
        this.initializeBluePrintBuilder();
        this.isDigging = true;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    public int k_() {
        return 0;
    }

    public ur a(int i) {
        return null;
    }

    public ur a(int i, int j) {
        return null;
    }

    public void a(int i, ur itemstack) {
    }

    public ur a_(int slot) {
        return null;
    }

    public String b() {
        return "";
    }

    public int c() {
        return 0;
    }

    public boolean a_(qx entityplayer) {
        return false;
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return true;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    public void moveHead(double instantSpeed) {
        int[] target = this.getTarget();
        double[] head = this.getHead();
        if (this.movingHorizontally) {
            if (Math.abs((double)target[0] - head[0]) < instantSpeed * 2.0 && Math.abs((double)target[2] - head[2]) < instantSpeed * 2.0) {
                head[0] = target[0];
                head[2] = target[2];
                this.movingHorizontally = false;
                if (!this.movingVertically) {
                    this.positionReached();
                    head[1] = target[1];
                }
            } else {
                head[0] = head[0] + Math.cos(this.headTrajectory) * instantSpeed;
                head[2] = head[2] + Math.sin(this.headTrajectory) * instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        if (this.movingVertically) {
            if (Math.abs((double)target[1] - head[1]) < instantSpeed * 2.0) {
                head[1] = target[1];
                this.movingVertically = false;
                if (!this.movingHorizontally) {
                    this.positionReached();
                    head[0] = target[0];
                    head[2] = target[2];
                }
            } else {
                head[1] = (double)target[1] > head[1] ? head[1] + instantSpeed : head[1] - instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        this.updatePosition();
    }

    private void updatePosition() {
        if (this.arm != null && this.k.I) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    private void setHead(double x, double y2, double z) {
        this.headPosX = x;
        this.headPosY = y2;
        this.headPosZ = z;
    }

    private double[] getHead() {
        return new double[]{this.headPosX, this.headPosY, this.headPosZ};
    }

    private int[] getTarget() {
        return new int[]{this.targetX, this.targetY, this.targetZ};
    }

    private void setTarget(int x, int y2, int z) {
        this.targetX = x;
        this.targetY = y2;
        this.targetZ = z;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        this.isAlive = true;
        xv quarryChunk = new xv(this.l >> 4, this.n >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (xv)quarryChunk);
        for (int chunkX = this.box.xMin >> 4; chunkX <= this.box.xMax >> 4; ++chunkX) {
            for (int chunkZ = this.box.zMin >> 4; chunkZ <= this.box.zMax >> 4; ++chunkZ) {
                xv chunk = new xv(chunkX, chunkZ);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (xv)chunk);
                chunks.add(chunk);
            }
        }
        if (this.placedBy != null) {
            PacketDispatcher.sendPacketToPlayer((ef)new cu(String.format("[BUILDCRAFT] The quarry at %d %d %d will keep %d chunks loaded", this.l, this.m, this.n, chunks.size())), (Player)((Player)this.placedBy));
        }
        this.sendNetworkUpdate();
    }
}

