/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.IAction;
import buildcraft.core.network.PacketPayload;
import buildcraft.transport.Pipe;
import java.util.LinkedList;

public abstract class Gate {
    protected Pipe pipe;
    public GateKind kind;

    public Gate(Pipe pipe) {
        this.pipe = pipe;
    }

    public Gate(Pipe pipe, ur stack) {
        this.pipe = pipe;
        this.kind = GateKind.getKindFromDamage(stack);
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("Kind", this.kind.ordinal());
    }

    public void readFromNBT(bq nbttagcompound) {
        this.kind = GateKind.values()[nbttagcompound.e("Kind")];
    }

    public PacketPayload toPayload() {
        PacketPayload payload = new PacketPayload(1, 0, 0);
        payload.intPayload[0] = this.kind.ordinal();
        return payload;
    }

    public abstract void openGui(qx var1);

    public abstract void update();

    public abstract void dropGate(yc var1, int var2, int var3, int var4);

    public abstract String getName();

    public abstract GateConditional getConditional();

    public abstract void addActions(LinkedList var1);

    public abstract void startResolution();

    public abstract boolean resolveAction(IAction var1);

    public abstract void addTrigger(LinkedList var1);

    public abstract int getTexture(boolean var1);

    public abstract String getGuiFile();

    public static boolean isGateItem(ur stack) {
        return stack.c == BuildCraftTransport.pipeGate.cj || stack.c == BuildCraftTransport.pipeGateAutarchic.cj;
    }

    public static enum GateConditional {
        None,
        AND,
        OR;

    }

    public static enum GateKind {
        None,
        Single,
        AND_2,
        OR_2,
        AND_3,
        OR_3,
        AND_4,
        OR_4;


        public static GateKind getKindFromDamage(ur itemstack) {
            switch (itemstack.j()) {
                case 0: {
                    return Single;
                }
                case 1: {
                    return AND_2;
                }
                case 2: {
                    return OR_2;
                }
                case 3: {
                    return AND_3;
                }
                case 4: {
                    return OR_3;
                }
                case 5: {
                    return AND_4;
                }
                case 6: {
                    return OR_4;
                }
            }
            return None;
        }
    }
}

