/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.IMachine;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPipeTransportContent;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportItems
extends PipeTransport {
    public boolean allowBouncing = false;
    public Map travelingEntities = new HashMap();
    private final List entitiesToLoad = new LinkedList();
    private final List delayedEntitiesToLoad = new LinkedList();
    private int delay = -1;
    public IItemTravelingHook travelHook;
    Set toRemove = new HashSet();

    public void readjustSpeed(IPipedItem item) {
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).readjustSpeed(item);
        } else {
            this.defaultReajustSpeed(item);
        }
    }

    public void defaultReajustSpeed(IPipedItem item) {
        float speed = item.getSpeed();
        if (speed > Utils.pipeNormalSpeed) {
            speed -= Utils.pipeNormalSpeed;
        }
        if (speed < Utils.pipeNormalSpeed) {
            speed = Utils.pipeNormalSpeed;
        }
        item.setSpeed(speed);
    }

    @Override
    public void entityEntering(IPipedItem item, ForgeDirection orientation) {
        if (item.isCorrupted()) {
            return;
        }
        this.readjustSpeed(item);
        EntityData data = (EntityData)this.travelingEntities.get(item.getEntityId());
        if (data == null) {
            data = new EntityData(item, orientation);
            this.travelingEntities.put(item.getEntityId(), data);
            if (item.getContainer() != null && item.getContainer() != this.container) {
                ((PipeTransportItems)((TileGenericPipe)item.getContainer()).pipe.transport).scheduleRemoval(item);
            }
            item.setContainer(this.container);
        }
        if (orientation != ForgeDirection.UP && orientation != ForgeDirection.DOWN) {
            item.setPosition(item.getPosition().x, (float)this.yCoord + Utils.getPipeFloorOf(item.getItemStack()), item.getPosition().z);
        }
        if (!this.worldObj.I) {
            data.output = this.resolveDestination(data);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(item, orientation);
        }
        if (!this.worldObj.I) {
            this.sendItemPacket(data);
        }
        if (this.travelingEntities.size() > BuildCraftTransport.groupItemsTrigger) {
            this.groupEntities();
            if (this.travelingEntities.size() > BuildCraftTransport.maxItemsInPipes) {
                this.worldObj.a(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 1.0f, false);
            }
        }
    }

    private void reverseItem(EntityData data) {
        if (data.item.isCorrupted()) {
            return;
        }
        this.unscheduleRemoval(data.item);
        data.toCenter = true;
        data.input = data.output.getOpposite();
        this.readjustSpeed(data.item);
        if (data.input != ForgeDirection.UP && data.input != ForgeDirection.DOWN) {
            data.item.setPosition(data.item.getPosition().x, (float)this.yCoord + Utils.getPipeFloorOf(data.item.getItemStack()), data.item.getPosition().z);
        }
        if (!this.worldObj.I) {
            data.output = this.resolveDestination(data);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(data.item, data.input);
        }
        if (!this.worldObj.I) {
            this.sendItemPacket(data);
        }
    }

    public ForgeDirection resolveDestination(EntityData data) {
        LinkedList listOfPossibleMovements = this.getPossibleMovements(data);
        if (listOfPossibleMovements.size() == 0) {
            return ForgeDirection.UNKNOWN;
        }
        int i = this.worldObj.t.nextInt(listOfPossibleMovements.size());
        return (ForgeDirection)listOfPossibleMovements.get(i);
    }

    public LinkedList getPossibleMovements(EntityData data) {
        LinkedList result = new LinkedList();
        data.blacklist.add(data.input.getOpposite());
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (data.blacklist.contains(o) || !this.container.pipe.outputOpen(o) || !this.canReceivePipeObjects(o, data.item)) continue;
            result.add(o);
        }
        if (result.size() == 0 && this.allowBouncing && this.canReceivePipeObjects(data.input.getOpposite(), data.item)) {
            result.add(data.input.getOpposite());
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, data.input);
            result = ((IPipeTransportItemsHook)((Object)this.container.pipe)).filterPossibleMovements(result, pos, data.item);
        }
        return result;
    }

    public boolean canReceivePipeObjects(ForgeDirection o, IPipedItem item) {
        any entity = this.container.getTile(o);
        if (!Utils.checkPipesConnections(entity, this.container)) {
            return false;
        }
        if (entity instanceof IPipeEntry) {
            return true;
        }
        if (entity instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)entity;
            return pipe.pipe.transport instanceof PipeTransportItems;
        }
        return entity instanceof la && Transactor.getTransactorFor((Object)entity).add((ur)item.getItemStack(), (ForgeDirection)o.getOpposite(), (boolean)false).a > 0;
    }

    @Override
    public void updateEntity() {
        this.moveSolids();
    }

    public void scheduleRemoval(IPipedItem item) {
        this.toRemove.add(item.getEntityId());
    }

    public void unscheduleRemoval(IPipedItem item) {
        this.toRemove.remove(item.getEntityId());
    }

    public void performRemoval() {
        this.travelingEntities.keySet().removeAll(this.toRemove);
        this.toRemove.clear();
    }

    private void moveSolids() {
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.entitiesToLoad.addAll(this.delayedEntitiesToLoad);
                this.delayedEntitiesToLoad.clear();
                this.delay = -1;
            }
        }
        if (!this.entitiesToLoad.isEmpty()) {
            for (EntityData data : this.entitiesToLoad) {
                data.item.setWorld(this.worldObj);
                this.travelingEntities.put(data.item.getEntityId(), data);
            }
            this.entitiesToLoad.clear();
        }
        this.performRemoval();
        for (EntityData data : this.travelingEntities.values()) {
            if (data.item.isCorrupted()) {
                this.scheduleRemoval(data.item);
                data.item.remove();
                continue;
            }
            Position motion = new Position(0.0, 0.0, 0.0, data.toCenter ? data.input : data.output);
            motion.moveForwards(data.item.getSpeed());
            Position pos = data.item.getPosition();
            data.item.setPosition(pos.x + motion.x, pos.y + motion.y, pos.z + motion.z);
            pos = data.item.getPosition();
            if (data.toCenter && this.middleReached(data, pos) || this.outOfBounds(pos)) {
                data.toCenter = false;
                data.item.setPosition((double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(data.item.getItemStack()), (double)this.zCoord + 0.5);
                if (data.output == ForgeDirection.UNKNOWN) {
                    if (this.travelHook != null) {
                        this.travelHook.drop(this, data);
                    }
                    px dropped = null;
                    if (!this.toRemove.contains(data.item.getEntityId())) {
                        dropped = data.item.toEntityItem(data.input);
                    }
                    this.scheduleRemoval(data.item);
                    if (dropped == null) continue;
                    this.onDropped(dropped);
                    continue;
                }
                if (this.travelHook == null) continue;
                this.travelHook.centerReached(this, data);
                continue;
            }
            if (data.toCenter || !this.endReached(pos)) continue;
            Position destPos = new Position(this.xCoord, this.yCoord, this.zCoord, data.output);
            destPos.moveForwards(1.0);
            any tile = this.worldObj.q((int)destPos.x, (int)destPos.y, (int)destPos.z);
            if (this.travelHook != null) {
                this.travelHook.endReached(this, data, tile);
            }
            if (this.toRemove.contains(data.item.getEntityId())) continue;
            this.scheduleRemoval(data.item);
            this.handleTileReached(data, tile);
        }
        this.performRemoval();
    }

    private void handleTileReached(EntityData data, any tile) {
        if (tile instanceof IPipeEntry) {
            ((IPipeEntry)tile).entityEntering(data.item, data.output);
        } else if (tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportItems) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            ((PipeTransportItems)pipe.pipe.transport).entityEntering(data.item, data.output);
        } else if (tile instanceof la) {
            if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
                ur added = Transactor.getTransactorFor(tile).add(data.item.getItemStack(), data.output.getOpposite(), true);
                data.item.getItemStack().a -= added.a;
                if (data.item.getItemStack().a > 0) {
                    this.reverseItem(data);
                }
            }
        } else {
            px dropped;
            if (this.travelHook != null) {
                this.travelHook.drop(this, data);
            }
            if ((dropped = data.item.toEntityItem(data.output)) != null) {
                this.onDropped(dropped);
            }
        }
    }

    protected boolean middleReached(EntityData entity, Position pos) {
        float middleLimit = entity.item.getSpeed() * 1.01f;
        return Math.abs((double)this.xCoord + 0.5 - pos.x) < (double)middleLimit && Math.abs((double)((float)this.yCoord + Utils.getPipeFloorOf(entity.item.getItemStack())) - pos.y) < (double)middleLimit && Math.abs((double)this.zCoord + 0.5 - pos.z) < (double)middleLimit;
    }

    protected boolean endReached(Position pos) {
        return pos.x > (double)(this.xCoord + 1) || pos.x < (double)this.xCoord || pos.y > (double)(this.yCoord + 1) || pos.y < (double)this.yCoord || pos.z > (double)(this.zCoord + 1) || pos.z < (double)this.zCoord;
    }

    protected boolean outOfBounds(Position pos) {
        return pos.x > (double)(this.xCoord + 2) || pos.x < (double)(this.xCoord - 1) || pos.y > (double)(this.yCoord + 2) || pos.y < (double)(this.yCoord - 1) || pos.z > (double)(this.zCoord + 2) || pos.z < (double)(this.zCoord - 1);
    }

    public Position getPosition() {
        return new Position(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(bq nbt) {
        super.readFromNBT(nbt);
        by nbttaglist = nbt.m("travelingEntities");
        for (int j = 0; j < nbttaglist.c(); ++j) {
            try {
                bq dataTag = (bq)nbttaglist.b(j);
                EntityPassiveItem entity = new EntityPassiveItem(null);
                entity.readFromNBT(dataTag);
                if (entity.isCorrupted()) {
                    entity.remove();
                    continue;
                }
                entity.setContainer(this.container);
                EntityData data = new EntityData(entity, ForgeDirection.getOrientation((int)dataTag.e("input")));
                data.output = ForgeDirection.getOrientation((int)dataTag.e("output"));
                data.toCenter = dataTag.n("toCenter");
                this.delayedEntitiesToLoad.add(data);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.delay = 2;
    }

    @Override
    public void writeToNBT(bq nbt) {
        super.writeToNBT(nbt);
        by nbttaglist = new by();
        for (EntityData data : this.travelingEntities.values()) {
            bq dataTag = new bq();
            nbttaglist.a((cd)dataTag);
            data.item.writeToNBT(dataTag);
            dataTag.a("toCenter", data.toCenter);
            dataTag.a("input", data.input.ordinal());
            dataTag.a("output", data.output.ordinal());
        }
        nbt.a("travelingEntities", (cd)nbttaglist);
    }

    protected void doWork() {
    }

    public void handleItemPacket(PacketPipeTransportContent packet) {
        if (packet.getID() != 2) {
            return;
        }
        EntityData data = (EntityData)this.travelingEntities.remove(packet.getEntityId());
        IPipedItem item = data == null ? EntityPassiveItem.getOrCreate(this.worldObj, packet.getEntityId()) : data.item;
        item.setItemStack(new ur(packet.getItemId(), packet.getStackSize(), packet.getItemDamage()));
        if (item.getPosition() == null) {
            item.setPosition(packet.getPosX(), packet.getPosY(), packet.getPosZ());
        }
        item.setSpeed(packet.getSpeed());
        if (item.getContainer() != null && item.getContainer() != this.container) {
            ((PipeTransportItems)((TileGenericPipe)item.getContainer()).pipe.transport).scheduleRemoval(item);
            item.setContainer(this.container);
        }
        data = new EntityData(item, packet.getInputOrientation());
        data.output = packet.getOutputOrientation();
        this.travelingEntities.put(item.getEntityId(), data);
    }

    public ef createItemPacket(EntityData data) {
        PacketPipeTransportContent packet = new PacketPipeTransportContent(data);
        return packet.getPacket();
    }

    private void sendItemPacket(EntityData data) {
        int dimension = this.worldObj.u.h;
        PacketDispatcher.sendPacketToAllAround((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)DefaultProps.PIPE_CONTENTS_RENDER_DIST, (int)dimension, (ef)this.createItemPacket(data));
    }

    public int getNumberOfItems() {
        return this.travelingEntities.size();
    }

    public void onDropped(px item) {
        this.container.pipe.onDropped(item);
    }

    protected void neighborChange() {
    }

    @Override
    public boolean isPipeConnected(any tile, ForgeDirection side) {
        return tile instanceof TileGenericPipe || tile instanceof IPipeEntry || tile instanceof ISpecialInventory || tile instanceof la && ((la)tile).k_() > 0 || tile instanceof IMachine && ((IMachine)tile).manageSolids();
    }

    @Override
    public boolean acceptItems() {
        return true;
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void groupEntities() {
        EntityData[] entities = this.travelingEntities.values().toArray(new EntityData[this.travelingEntities.size()]);
        TreeSet<Integer> remove = new TreeSet<Integer>();
        for (int i = 0; i < entities.length; ++i) {
            EntityData data1 = entities[i];
            for (int j = i + 1; j < entities.length; ++j) {
                EntityData data2 = entities[j];
                if (data1.item.getItemStack().c != data2.item.getItemStack().c || data1.item.getItemStack().j() != data2.item.getItemStack().j() || remove.contains(data1.item.getEntityId()) || remove.contains(data2.item.getEntityId()) || data1.item.hasContributions() || data2.item.hasContributions() || data1.item.getItemStack().a + data2.item.getItemStack().a >= data1.item.getItemStack().d()) continue;
                data1.item.getItemStack().a += data2.item.getItemStack().a;
                remove.add(data2.item.getEntityId());
            }
        }
        for (Integer i : remove) {
            ((EntityData)this.travelingEntities.get((Object)i)).item.remove();
            this.travelingEntities.remove(i);
        }
    }

    @Override
    public void dropContents() {
        this.groupEntities();
        for (EntityData data : this.travelingEntities.values()) {
            Utils.dropItems(this.worldObj, data.item.getItemStack(), this.xCoord, this.yCoord, this.zCoord);
        }
        this.travelingEntities.clear();
    }

    @Override
    public boolean allowsConnect(PipeTransport with) {
        return with instanceof PipeTransportItems;
    }
}

