/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPowerUpdate;
import java.util.Arrays;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportPower
extends PipeTransport {
    private static final int MAX_POWER_INTERNAL = 10000;
    private static final int OVERLOAD_LIMIT = 7500;
    private static final short MAX_DISPLAY = 100;
    private static final float DISPLAY_POWER_FACTOR = 0.1f;
    private boolean needsInit = true;
    private any[] tiles = new any[6];
    public short[] displayPower = new short[]{0, 0, 0, 0, 0, 0};
    public boolean overload;
    public int[] powerQuery = new int[6];
    public int[] nextPowerQuery = new int[6];
    public long currentDate;
    public double[] internalPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double[] internalNextPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double powerResistance = 0.05;
    SafeTimeTracker tracker = new SafeTimeTracker();

    public PipeTransportPower() {
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
        }
    }

    @Override
    public boolean isPipeConnected(any tile, ForgeDirection side) {
        return tile instanceof TileGenericPipe || tile instanceof IMachine || tile instanceof IPowerReceptor;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateTiles();
    }

    private void updateTiles() {
        for (int i = 0; i < 6; ++i) {
            any tile = this.container.getTile(ForgeDirection.VALID_DIRECTIONS[i]);
            this.tiles[i] = Utils.checkPipesConnections(tile, this.container) ? tile : null;
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            this.updateTiles();
        }
    }

    @Override
    public void updateEntity() {
        int i;
        int i2;
        if (CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            return;
        }
        this.step();
        this.init();
        Arrays.fill(this.displayPower, (short)0);
        for (int i3 = 0; i3 < 6; ++i3) {
            if (!(this.internalPower[i3] > 0.0)) continue;
            double div = 0.0;
            for (int j = 0; j < 6; ++j) {
                if (j == i3 || this.powerQuery[j] <= 0 || !(this.tiles[j] instanceof TileGenericPipe) && !(this.tiles[j] instanceof IPowerReceptor)) continue;
                div += (double)this.powerQuery[j];
            }
            double totalWatt = this.internalPower[i3];
            for (int j = 0; j < 6; ++j) {
                IPowerReceptor pow;
                IPowerProvider prov;
                if (j == i3 || this.powerQuery[j] <= 0) continue;
                double watts = totalWatt / div * (double)this.powerQuery[j];
                if (this.tiles[j] instanceof TileGenericPipe) {
                    TileGenericPipe nearbyTile = (TileGenericPipe)this.tiles[j];
                    PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
                    nearbyTransport.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite(), watts);
                    int n = j;
                    this.displayPower[n] = (short)(this.displayPower[n] + (short)Math.ceil(watts * (double)0.1f));
                    int n2 = i3;
                    this.displayPower[n2] = (short)(this.displayPower[n2] + (short)Math.ceil(watts * (double)0.1f));
                    int n3 = i3;
                    this.internalPower[n3] = this.internalPower[n3] - watts;
                    continue;
                }
                if (!(this.tiles[j] instanceof IPowerReceptor) || (prov = (pow = (IPowerReceptor)this.tiles[j]).getPowerProvider()) == null) continue;
                prov.receiveEnergy((float)watts, ForgeDirection.VALID_DIRECTIONS[j].getOpposite());
                int n = j;
                this.displayPower[n] = (short)(this.displayPower[n] + (short)Math.ceil(watts * (double)0.1f));
                int n4 = i3;
                this.displayPower[n4] = (short)(this.displayPower[n4] + (short)Math.ceil(watts * (double)0.1f));
                int n5 = i3;
                this.internalPower[n5] = this.internalPower[n5] - watts;
            }
        }
        double highestPower = 0.0;
        for (i2 = 0; i2 < 6; ++i2) {
            if (this.internalPower[i2] > highestPower) {
                highestPower = this.internalPower[i2];
            }
            this.displayPower[i2] = (short)Math.max((double)this.displayPower[i2], Math.ceil(this.internalPower[i2] * (double)0.1f));
            this.displayPower[i2] = (short)Math.min(this.displayPower[i2], 100);
        }
        this.overload = highestPower > 7500.0;
        for (i2 = 0; i2 < 6; ++i2) {
            IPowerReceptor receptor;
            int request;
            if (!(this.tiles[i2] instanceof IPowerReceptor) || this.tiles[i2] instanceof TileGenericPipe || (request = (receptor = (IPowerReceptor)this.tiles[i2]).powerRequest()) <= 0) continue;
            this.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i2], request);
        }
        int[] transferQuery = new int[]{0, 0, 0, 0, 0, 0};
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
        }
        for (i = 0; i < 6; ++i) {
            any entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof TileGenericPipe)) continue;
            TileGenericPipe nearbyTile = (TileGenericPipe)entity;
            if (nearbyTile.pipe == null) continue;
            PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
            nearbyTransport.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i].getOpposite(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.worldObj, 2 * BuildCraftCore.updateFactor)) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.xCoord, this.yCoord, this.zCoord);
            packet.displayPower = this.displayPower;
            packet.overload = this.overload;
            CoreProxy.proxy.sendToPlayers(packet.getPacket(), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
        }
    }

    public void step() {
        if (this.currentDate != this.worldObj.G()) {
            this.currentDate = this.worldObj.G();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[]{0, 0, 0, 0, 0, 0};
            double[] next = Arrays.copyOf(this.internalPower, 6);
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
            for (int i = 0; i < this.nextPowerQuery.length; ++i) {
                if ((double)this.powerQuery[i] != 0.0 || !(this.internalNextPower[i] > 0.0)) continue;
                int n = i;
                this.internalNextPower[n] = this.internalNextPower[n] - 1.0;
            }
        }
    }

    public void receiveEnergy(ForgeDirection from, double val) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val);
        } else {
            if (BuildCraftTransport.usePipeLoss) {
                int n = from.ordinal();
                this.internalNextPower[n] = this.internalNextPower[n] + val * (1.0 - this.powerResistance);
            } else {
                int n = from.ordinal();
                this.internalNextPower[n] = this.internalNextPower[n] + val;
            }
            if (this.internalNextPower[from.ordinal()] >= 10000.0) {
                this.worldObj.a(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 3.0f, false);
                this.worldObj.e(this.xCoord, this.yCoord, this.zCoord, 0);
            }
        }
    }

    public void requestEnergy(ForgeDirection from, int i) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, i);
        } else {
            this.step();
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + i;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.worldObj.G();
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.e("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.e("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbttagcompound.h("internalPower[" + i + "]");
            this.internalNextPower[i] = nbttagcompound.h("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    @Override
    public boolean allowsConnect(PipeTransport with) {
        return with instanceof PipeTransportPower;
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.displayPower = packetPower.displayPower;
        this.overload = packetPower.overload;
    }
}

