/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.inventory.ISelectiveInventory;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.core.network.IClientState;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.SimpleInventory;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicEmerald;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsEmerald
extends PipeItemsWood
implements ISpecialInventory,
IClientState {
    private SimpleInventory filters = new SimpleInventory(9, "items", 1);
    private int currentFilter = 0;

    protected PipeItemsEmerald(int itemID, PipeTransportItems transport) {
        super(transport, (PipeLogic)new PipeLogicEmerald(), itemID);
        this.baseTexture = 109;
        this.plainTexture = this.baseTexture + 1;
    }

    public PipeItemsEmerald(int itemID) {
        this(itemID, new PipeTransportItems());
    }

    @Override
    public boolean blockActivated(yc world, int x, int y2, int z, qx entityplayer) {
        if (entityplayer.bS() != null && entityplayer.bS().c < amq.p.length && amq.p[entityplayer.bS().c] instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(this.worldObj, x, y2, z, entityplayer)) {
            return true;
        }
        if (!CoreProxy.proxy.isRenderWorld(this.container.k)) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 52, this.worldObj, x, y2, z);
        }
        return true;
    }

    @Override
    public ur[] checkExtract(la inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISelectiveInventory) {
            ur[] stacks = ((ISelectiveInventory)inventory).extractItem(new ur[]{this.getCurrentFilter()}, false, doRemove, from, (int)this.getPowerProvider().getEnergyStored());
            if (doRemove) {
                for (ur stack : stacks) {
                    if (stack == null) continue;
                    this.getPowerProvider().useEnergy(stack.a, stack.a, true);
                }
                this.incrementFilter();
            }
            return stacks;
        }
        if (inventory instanceof ISpecialInventory) {
            ur[] stacks = ((ISpecialInventory)inventory).extractItem(false, from, (int)this.getPowerProvider().getEnergyStored());
            if (stacks != null) {
                for (ur stack : stacks) {
                    if (stack == null) continue;
                    boolean matches = false;
                    for (int i = 0; i < this.filters.k_(); ++i) {
                        ur filter = this.filters.a(i);
                        if (filter == null || !filter.a(stack)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    return null;
                }
                if (doRemove) {
                    for (ur stack : stacks = ((ISpecialInventory)inventory).extractItem(true, from, (int)this.getPowerProvider().getEnergyStored())) {
                        if (stack == null) continue;
                        this.getPowerProvider().useEnergy(stack.a, stack.a, true);
                    }
                }
            }
            return stacks;
        }
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int first = sidedInv.getStartInventorySide(from);
            int last = first + sidedInv.getSizeInventorySide(from) - 1;
            la inv = Utils.getInventory(inventory);
            ur result = this.checkExtractGeneric(inv, doRemove, from, first, last);
            if (result != null) {
                return new ur[]{result};
            }
        } else {
            la inv = Utils.getInventory(inventory);
            ur result = this.checkExtractGeneric(inv, doRemove, from, 0, inv.k_() - 1);
            if (result != null) {
                return new ur[]{result};
            }
        }
        return null;
    }

    private void incrementFilter() {
        ++this.currentFilter;
        for (int count = 0; this.filters.a(this.currentFilter % this.filters.k_()) == null && count < this.filters.k_(); ++count) {
            ++this.currentFilter;
        }
    }

    private ur getCurrentFilter() {
        ur filter = this.filters.a(this.currentFilter % this.filters.k_());
        if (filter == null) {
            this.incrementFilter();
        }
        return this.filters.a(this.currentFilter % this.filters.k_());
    }

    @Override
    public ur checkExtractGeneric(la inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int i = start; i <= stop; ++i) {
            ur stack = inventory.a(i);
            if (stack == null || stack.a <= 0) continue;
            ur filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!filter.a(stack)) continue;
            if (doRemove) {
                this.incrementFilter();
                return inventory.a(i, (int)this.getPowerProvider().useEnergy(1.0f, stack.a, true));
            }
            return stack;
        }
        return null;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.filters.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.filters.writeToNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        bq nbt = new bq();
        this.writeToNBT(nbt);
        cd.a((cd)nbt, (DataOutput)data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        cd nbt = cd.b((DataInput)data);
        if (nbt instanceof bq) {
            this.readFromNBT((bq)nbt);
        }
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return new ur[0];
    }

    public int k_() {
        return this.filters.k_();
    }

    public ur a(int i) {
        return this.filters.a(i);
    }

    public String b() {
        return "Filters";
    }

    public int c() {
        return this.filters.c();
    }

    public ur a_(int i) {
        return this.filters.a_(i);
    }

    public void d() {
        this.filters.d();
    }

    public boolean a_(qx var1) {
        return this.worldObj.q(this.xCoord, this.yCoord, this.zCoord) == this.container;
    }

    public void l_() {
    }

    public void f() {
    }

    public ur a(int i, int j) {
        ur stack = this.filters.a(i, j);
        if (CoreProxy.proxy.isSimulating(this.worldObj)) {
            this.worldObj.i(this.xCoord, this.yCoord, this.zCoord);
        }
        return stack;
    }

    public void a(int i, ur itemstack) {
        this.filters.a(i, itemstack);
        if (CoreProxy.proxy.isSimulating(this.worldObj)) {
            this.worldObj.i(this.xCoord, this.yCoord, this.zCoord);
        }
    }
}

