/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;

public class PipeLogicIron
extends PipeLogic {
    boolean lastPower = false;

    public void switchPower() {
        boolean currentPower = this.worldObj.B(this.xCoord, this.yCoord, this.zCoord);
        if (currentPower != this.lastPower) {
            this.switchPosition();
            this.lastPower = currentPower;
        }
    }

    public void switchPosition() {
        int metadata;
        int nextMetadata = metadata = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        for (int l = 0; l < 6; ++l) {
            any tile;
            if (++nextMetadata > 5) {
                nextMetadata = 0;
            }
            if ((tile = this.container.getTile(ForgeDirection.values()[nextMetadata])) instanceof TileGenericPipe) {
                Pipe pipe = ((TileGenericPipe)tile).pipe;
                if (pipe.logic instanceof PipeLogicWood || pipe instanceof PipeStructureCobblestone) continue;
            }
            if (!(tile instanceof IPipeEntry) && !(tile instanceof la) && !(tile instanceof ITankContainer) && !(tile instanceof TileGenericPipe)) continue;
            this.worldObj.d(this.xCoord, this.yCoord, this.zCoord, nextMetadata);
            this.container.scheduleRenderUpdate();
            return;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.lastPower = this.worldObj.B(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        this.worldObj.d(this.xCoord, this.yCoord, this.zCoord, 1);
        this.switchPosition();
    }

    @Override
    public boolean blockActivated(qx entityplayer) {
        up equipped;
        super.blockActivated(entityplayer);
        up up2 = equipped = entityplayer.bS() != null ? entityplayer.bS().b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.xCoord, this.yCoord, this.zCoord)) {
            this.switchPosition();
            this.worldObj.i(this.xCoord, this.yCoord, this.zCoord);
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.switchPower();
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        return to.ordinal() == this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
    }
}

