/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.DefaultProps;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogicWood;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerWood
extends Pipe
implements IPowerReceptor {
    private static final int MAX_OVERHEAT_TICKS = 100;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private int baseTexture = 118;
    private int plainTexture = 31;
    private int overheatTicks;

    public PipePowerWood(int itemID) {
        super(new PipeTransportPower(), new PipeLogicWood(), itemID);
        this.powerProvider.configure(50, 2, 1000, 1, 1000);
        this.powerProvider.configurePowerPerdition(1, 100);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.baseTexture;
        }
        int metadata = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.plainTexture;
        }
        return this.baseTexture;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        if (this.overheatTicks > 0) {
            return null;
        }
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.I) {
            return;
        }
        this.overheatTicks = this.powerProvider.getEnergyStored() == (float)this.powerProvider.getMaxEnergyStored() ? (this.overheatTicks += this.overheatTicks < 100 ? 1 : 0) : (this.overheatTicks -= this.overheatTicks > 0 ? 1 : 0);
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            any tile;
            if (!Utils.checkPipesConnections(this.container, this.container.getTile(o)) || !((tile = this.container.getTile(o)) instanceof TileGenericPipe) || ((TileGenericPipe)tile).pipe == null) continue;
            PipeTransportPower trans = (PipeTransportPower)((TileGenericPipe)tile).pipe.transport;
            float energyToRemove = this.powerProvider.getEnergyStored() > 40.0f ? this.powerProvider.getEnergyStored() / 40.0f + 4.0f : (this.powerProvider.getEnergyStored() > 10.0f ? this.powerProvider.getEnergyStored() / 10.0f : 1.0f);
            float energyUsed = this.powerProvider.useEnergy(1.0f, energyToRemove, true);
            trans.receiveEnergy(o.getOpposite(), energyUsed);
        }
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

