/*
 * Decompiled with CFR 0.152.
 */
package server;

import console.SystemConsole;
import dbms.DBMS;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;
import shared.ExtendedClassLoader;

public class DatabaseServer {
    private boolean m_initialized;
    public static String dbmsListFileName;
    public static Properties DBMSList;
    public static DBMS database;
    public static SystemConsole console;
    public static ExtendedClassLoader classLoader;
    private Registry m_registry;
    public static final String DEFAULT_DBMS_LIST_FILENAME = "dbms.cfg";
    public static final String DATABASE_REGISTRY_NAME = "ConnectFourDatabase";
    public static final int DEFAULT_REGISTRY_PORT = 1099;

    public DatabaseServer() {
        console = new SystemConsole();
        classLoader = new ExtendedClassLoader();
        DBMSList = new Properties();
        this.m_initialized = false;
    }

    public boolean initialize() {
        return this.initialize(null, null, true, 1099);
    }

    public boolean initialize(boolean integratedRegistry, int registryPort) {
        return this.initialize(null, null, integratedRegistry, registryPort);
    }

    public boolean initialize(String dbmsName, boolean integratedRegistry, int registryPort) {
        return this.initialize(null, dbmsName, integratedRegistry, registryPort);
    }

    public boolean initialize(String databaseConfigFileName, String dbmsName, boolean integratedRegistry, int registryPort) {
        String dbmsClassName;
        Class<?> databaseClass;
        block21: {
            block20: {
                FileInputStream in;
                if (this.m_initialized) {
                    return false;
                }
                if (registryPort < 1 || registryPort > 65535) {
                    registryPort = 1099;
                }
                dbmsListFileName = databaseConfigFileName == null ? DEFAULT_DBMS_LIST_FILENAME : databaseConfigFileName;
                try {
                    in = new FileInputStream(dbmsListFileName);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Error opening database management system list \"" + dbmsListFileName + "\": " + e.getMessage());
                    return false;
                }
                try {
                    DBMSList.load(in);
                }
                catch (IOException e) {
                    System.err.println("Error loading database management system list: " + e.getMessage());
                    return false;
                }
                if (DBMSList.size() == 0) {
                    System.err.println("No database management systems specified in list \"" + dbmsListFileName + ".");
                    return false;
                }
                databaseClass = null;
                try {
                    if (dbmsName == null || DBMSList.getProperty(dbmsName) == null) {
                        dbmsName = DBMSList.size() == 1 ? (String)DBMSList.keys().nextElement() : this.chooseDBMS();
                    }
                    if (dbmsName != null) break block20;
                    return false;
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Error loading selected database management system: " + e.getMessage());
                    return false;
                }
            }
            dbmsClassName = DBMSList.getProperty(dbmsName);
            if (dbmsClassName != null) break block21;
            return false;
        }
        databaseClass = classLoader.loadClass(dbmsClassName);
        if (databaseClass == null) {
            return false;
        }
        try {
            database = (DBMS)databaseClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Error instantiating selected database management system: " + e.getMessage());
            return false;
        }
        try {
            if (!database.initialize()) {
                return false;
            }
        }
        catch (RemoteException e) {
            System.err.println("Error initializing selected database management system: " + e.getMessage());
            return false;
        }
        try {
            this.m_registry = integratedRegistry ? LocateRegistry.createRegistry(registryPort) : LocateRegistry.getRegistry(registryPort);
            this.m_registry.rebind(DATABASE_REGISTRY_NAME, database);
        }
        catch (Exception e) {
            System.err.println("Error setting up database management system on rmi registry: " + e.getMessage());
            return false;
        }
        this.m_initialized = true;
        return true;
    }

    public String chooseDBMS() {
        if (DBMSList.size() == 0) {
            return null;
        }
        Object[] choices = new Object[DBMSList.size()];
        Enumeration<Object> keys = DBMSList.keys();
        int j = 0;
        while (keys.hasMoreElements()) {
            choices[j++] = keys.nextElement();
        }
        return (String)JOptionPane.showInputDialog(null, "Choose a database management system to use:", "DBMS Selection", 3, null, choices, choices[0]);
    }

    public void stop() {
        this.m_initialized = false;
        try {
            this.m_registry.unbind(DATABASE_REGISTRY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            database.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

