/*
 * Decompiled with CFR 0.152.
 */
package server;

import gui.DatabaseWindow;
import java.rmi.RMISecurityManager;
import javax.swing.JOptionPane;

public class Main {
    private static final String helpMessage = "Executes the Connect Four Database Server with the specified input parameters.\n\nusage: java server.Main [-rmi ext/int] [-rmiport 1099] [-dblist \"dbms.cfg\"]\n\n -rmi :: specifies how to run rmi, either [ext]ernal or [int]ernal; e.g., -rmi int\n         (if left unspecified, will default to internal)\n -rmiport :: specifies which port to use for rmi; e.g., -rmiport 1099\n             (if no port is specified, defaults to 1099)\n -dblist :: indicates which config file the database should use; e.g., -dblist \"dbms.cfg\"\n        (if left unspecified, will default to \"dbms.cfg\")\n -dbms :: indicates which dbms should be used; e.g., -dbms \"SQLite\"\n        (if left unspecified, will prompt for dbms or load dbms if only 1 in list)";

    public static void main(String[] args) {
        System.setProperty("java.security.policy", "all.policy");
        System.setSecurityManager(new RMISecurityManager());
        Main.parseParameters(args);
    }

    public static void displayHelp() {
        JOptionPane.showMessageDialog(null, helpMessage, "Help", 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parseParameters(String[] args) {
        if (args != null && args.length % 2 != 0) {
            Main.displayHelp();
            return;
        }
        boolean integratedRegistry = true;
        int registryPort = 1099;
        String databaseConfigFileName = null;
        String dbmsName = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String temp;
                if (args[i].equalsIgnoreCase("-rmi")) {
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Registry type cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    if (temp.startsWith("int")) {
                        integratedRegistry = true;
                    } else {
                        if (!temp.startsWith("ext")) {
                            JOptionPane.showMessageDialog(null, "Registry type can only be either int or ext.", "Invalid Argument", 0);
                            Main.displayHelp();
                            return;
                        }
                        integratedRegistry = false;
                    }
                } else if (args[i].equalsIgnoreCase("-rmiport")) {
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Registry port cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    int port = -1;
                    try {
                        port = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (port < 1 || port > 65535) {
                        JOptionPane.showMessageDialog(null, "Registry port must be between 1 and 65535.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    registryPort = port;
                } else if (args[i].equalsIgnoreCase("-dblist")) {
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Database configuration filename cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    databaseConfigFileName = temp.trim();
                    if (databaseConfigFileName.length() == 0) {
                        JOptionPane.showMessageDialog(null, "Database configuration filename cannot be empty.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                } else {
                    if (!args[i].equalsIgnoreCase("-dbms")) {
                        JOptionPane.showMessageDialog(null, "Invalid argument: " + args[i], "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Database management system name cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    dbmsName = temp.trim();
                    if (dbmsName.length() == 0) {
                        JOptionPane.showMessageDialog(null, "Database managment system name cannot be empty.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                }
                i += 2;
            }
        }
        DatabaseWindow window = new DatabaseWindow();
        window.initialize(databaseConfigFileName, dbmsName, integratedRegistry, registryPort);
    }
}

