/*
 * Decompiled with CFR 0.152.
 */
package server;

import gui.ServerWindow;
import java.rmi.RMISecurityManager;
import javax.swing.JOptionPane;

public class Main {
    private static final String helpMessage = "Executes the Connect Four Matchmaking Server with the specified input parameters.\n\nusage: java server.Main [-q \"Server Queue Name\"] [-rmiport 1099] [-b \"127.0.0.1\"]\n\n -q :: specifies the name of the server's queue; e.g., -q \"Matchmaking Server Queue\"\n       (if no port is specified, defaults to \"Matchmaking Server Queue\")\n -rmiport :: specifies which port to use for rmi; e.g., -rmiport 1099\n             (if no port is specified, defaults to 1099)\n -b :: specifies the host name of the broker; e.g., -b \"127.0.0.1\"\n       (if no host name is specified, default is used)";

    public static void main(String[] args) {
        System.setProperty("java.security.policy", "all.policy");
        System.setSecurityManager(new RMISecurityManager());
        Main.parseParameters(args);
    }

    public static void displayHelp() {
        JOptionPane.showMessageDialog(null, helpMessage, "Help", 1);
    }

    public static void parseParameters(String[] args) {
        if (args != null && args.length % 2 != 0) {
            Main.displayHelp();
            return;
        }
        int registryPort = 1099;
        String serverQueueName = null;
        String brokerHostName = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String temp;
                if (args[i].equalsIgnoreCase("-q")) {
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Server queue name cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    serverQueueName = temp.trim();
                    if (serverQueueName.length() == 0) {
                        JOptionPane.showMessageDialog(null, "Server queue name cannot be empty.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                } else if (args[i].equalsIgnoreCase("-rmiport")) {
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Registry port cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    int port = -1;
                    try {
                        port = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (port < 1 || port > 65535) {
                        JOptionPane.showMessageDialog(null, "Registry port must be between 1 and 65535.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    registryPort = port;
                } else if (args[i].equalsIgnoreCase("-b")) {
                    temp = args[i + 1];
                    if (temp == null) {
                        JOptionPane.showMessageDialog(null, "Broker host name cannot be null.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                    brokerHostName = temp.trim();
                    if (brokerHostName.length() == 0) {
                        JOptionPane.showMessageDialog(null, "Broker host name cannot be empty.", "Invalid Argument", 0);
                        Main.displayHelp();
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Invalid argument: " + args[i], "Invalid Argument", 0);
                    Main.displayHelp();
                    return;
                }
                i += 2;
            }
        }
        ServerWindow window = new ServerWindow();
        window.initialize(serverQueueName, registryPort, brokerHostName);
    }
}

