/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import connectfour.GameSession;
import console.SystemConsole;
import dbms.DBMS;
import dbms.DBMSListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import server.User;
import shared.ExtendedClassLoader;
import shared.Message;

public class Server
extends UnicastRemoteObject
implements DBMSListener,
Runnable {
    private String m_serverQueueName;
    private Vector<User> m_users;
    private Vector<GameSession> m_sessions;
    private int m_registryPort;
    private Registry m_registry;
    private String m_brokerHostName;
    private ConnectionFactory m_factory;
    private Connection m_connection;
    private Channel m_channel;
    private QueueingConsumer m_consumer;
    public static DBMS database;
    public static SystemConsole console;
    public static ExtendedClassLoader classLoader;
    private boolean m_initialized;
    private boolean m_running;
    private boolean m_disconnectHandlerRunning;
    private Thread m_serverThread;
    private Thread m_disconnectHandlerThread;
    public static Server instance;
    public static final String DEFAULT_SERVER_QUEUE_NAME = "Matchmaking Server Queue";
    public static final String DATABASE_REGISTRY_NAME = "ConnectFourDatabase";
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final String DEFAULT_BROKER_HOSTNAME = "nitro404.dyndns.org";
    private static final long serialVersionUID = -206969195865338931L;

    public Server() throws RemoteException {
        instance = this;
        console = new SystemConsole();
        classLoader = new ExtendedClassLoader();
        this.m_users = new Vector();
        this.m_sessions = new Vector();
        this.m_initialized = false;
        this.m_running = false;
    }

    public boolean initialize() {
        return this.initialize(DEFAULT_SERVER_QUEUE_NAME, 1099, DEFAULT_BROKER_HOSTNAME);
    }

    public boolean initialize(String serverName) {
        return this.initialize(serverName, 1099, DEFAULT_BROKER_HOSTNAME);
    }

    public boolean initialize(String serverName, int registrtPort) {
        return this.initialize(serverName, registrtPort, DEFAULT_BROKER_HOSTNAME);
    }

    public boolean initialize(String serverQueueName, int registryPort, String brokerHostName) {
        this.m_serverQueueName = serverQueueName == null || serverQueueName.trim().length() == 0 ? DEFAULT_SERVER_QUEUE_NAME : serverQueueName.trim();
        this.m_brokerHostName = brokerHostName == null || brokerHostName.trim().length() == 0 ? DEFAULT_BROKER_HOSTNAME : brokerHostName.trim();
        this.m_registryPort = registryPort < 1 || registryPort > 65535 ? 1099 : registryPort;
        try {
            this.m_registry = LocateRegistry.getRegistry(this.m_registryPort);
        }
        catch (Exception e) {
            System.err.println("Error locating registry: " + e.getMessage());
            return false;
        }
        try {
            database = (DBMS)this.m_registry.lookup(DATABASE_REGISTRY_NAME);
        }
        catch (Exception e) {
            System.err.println("Error retrieving database: " + e.getMessage());
            return false;
        }
        try {
            database.addListener(this);
        }
        catch (RemoteException e) {
            console.writeLine("Failed to add server as database listener: " + e.getMessage());
        }
        try {
            this.m_factory = new ConnectionFactory();
            this.m_factory.setHost(this.m_brokerHostName);
            this.m_connection = this.m_factory.newConnection();
            this.m_channel = this.m_connection.createChannel();
            this.m_channel.queueDeclare(this.m_serverQueueName, false, false, false, null);
            this.m_consumer = new QueueingConsumer(this.m_channel);
            this.m_channel.basicConsume(this.m_serverQueueName, true, this.m_consumer);
        }
        catch (IOException e) {
            System.err.println("Error initializing messaging service: " + e.getMessage());
            return false;
        }
        this.m_initialized = true;
        this.m_serverThread = new Thread(this);
        this.m_serverThread.start();
        this.m_disconnectHandlerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!Server.this.m_initialized) {
                    return;
                }
                Server.this.m_disconnectHandlerRunning = true;
                while (Server.this.m_disconnectHandlerRunning) {
                    Server.this.checkForDisconnects();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_disconnectHandlerThread.start();
        return true;
    }

    public int numberOfUsers() {
        return this.m_users.size();
    }

    public User getUser(int index) {
        if (index < 0 || index >= this.m_users.size()) {
            return null;
        }
        return this.m_users.elementAt(index);
    }

    public User getUserByQueueName(String queueName) {
        if (queueName == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_users.size()) {
            if (queueName.equals(this.m_users.elementAt(i).getQueueName())) {
                return this.m_users.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public User getUserByName(String userName) {
        if (userName == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_users.size()) {
            if (this.m_users.elementAt(i).getUserName() != null && userName.equals(this.m_users.elementAt(i).getUserName())) {
                return this.m_users.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean removeUser(int index) {
        if (index < 0 || index >= this.m_users.size()) {
            return false;
        }
        String userName = this.m_users.elementAt(index).getUserName();
        if (userName != null) {
            GameSession s = null;
            int i = 0;
            while (i < this.m_sessions.size()) {
                s = this.m_sessions.elementAt(i);
                if (s.contains(userName) && s.playerLeft(userName) && s.isFull()) {
                    Message playerLeft = new Message("Player Left");
                    playerLeft.setAttribute("User Name", userName);
                    this.sendMessageToClient(playerLeft, s.getOpponentPlayerQueueName(userName));
                    console.writeLine("Removing player \"" + userName + "\" from session #" + s.getID());
                }
                ++i;
            }
        }
        this.m_users.remove(index);
        return true;
    }

    public synchronized boolean removeUserByQueueName(String queueName) {
        if (queueName == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_users.size()) {
            if (queueName.equals(this.m_users.elementAt(i).getQueueName())) {
                return this.removeUser(i);
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean removeUserByName(String userName) {
        if (userName == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_users.size()) {
            if (this.m_users.elementAt(i).getUserName() != null && userName.equals(this.m_users.elementAt(i).getUserName())) {
                return this.removeUser(i);
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean removeUser(User u) {
        if (u == null) {
            return false;
        }
        return this.removeUser(this.m_users.indexOf(u));
    }

    public int numberOfSessions() {
        return this.m_sessions.size();
    }

    public GameSession getSession(int index) {
        if (index < 0 || index >= this.m_sessions.size()) {
            return null;
        }
        return this.m_sessions.elementAt(index);
    }

    public synchronized boolean removeSession(GameSession session) {
        if (session == null || !session.isFinished()) {
            return false;
        }
        boolean sessionRemoved = this.m_sessions.remove(session);
        if (sessionRemoved) {
            console.writeLine("Removing session #" + session.getID());
            session.stop();
        }
        return sessionRemoved;
    }

    public boolean sendMessageToClient(Message message, String clientQueueName) {
        if (message == null || clientQueueName == null) {
            return false;
        }
        try {
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
            AMQP.BasicProperties properties = builder.contentType("text/plain").replyTo(this.m_serverQueueName).build();
            this.m_channel.basicPublish("", clientQueueName, properties, Message.serializeMessage(message));
        }
        catch (Exception e) {
            console.writeLine("Error sending message to client \"" + clientQueueName + "\": " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(QueueingConsumer.Delivery delivery) {
        block36: {
            if (delivery == null) {
                return;
            }
            Message message = null;
            try {
                message = Message.deserializeMessage(delivery.getBody());
            }
            catch (Exception e) {
                return;
            }
            if (message == null) {
                return;
            }
            if (this.getUserByQueueName(delivery.getProperties().getReplyTo()) == null) {
                this.m_users.add(new User(delivery.getProperties().getReplyTo()));
            }
            if (message.getType().equalsIgnoreCase("Ping")) {
                this.sendMessageToClient(new Message("Pong"), delivery.getProperties().getReplyTo());
            } else if (message.getType().equalsIgnoreCase("Pong")) {
                this.getUserByQueueName(delivery.getProperties().getReplyTo()).pong();
            } else if (message.getType().equalsIgnoreCase("Create Account")) {
                String userName = (String)message.getAttribute("User Name");
                String password = (String)message.getAttribute("Password");
                try {
                    if (database.createUser(userName, password)) {
                        Message reply = new Message("Account Created");
                        reply.setAttribute("User Name", userName);
                        this.sendMessageToClient(reply, delivery.getProperties().getReplyTo());
                        console.writeLine("Created account for user: \"" + userName + "\"");
                        break block36;
                    }
                    Message reply = new Message("Account Not Created");
                    reply.setAttribute("User Name", userName);
                    this.sendMessageToClient(reply, delivery.getProperties().getReplyTo());
                    console.writeLine("Unable to create account for user: \"" + userName + "\"");
                }
                catch (RemoteException e) {
                    console.writeLine("Error creating account for user: \"" + userName + "\"");
                }
            } else if (message.getType().equalsIgnoreCase("Login")) {
                String userName = (String)message.getAttribute("User Name");
                String password = (String)message.getAttribute("Password");
                try {
                    if (database.userLogin(userName, password)) {
                        Message reply = new Message("Logged In");
                        reply.setAttribute("User Name", userName);
                        this.sendMessageToClient(reply, delivery.getProperties().getReplyTo());
                        this.getUserByQueueName(delivery.getProperties().getReplyTo()).setUserName(userName);
                        console.writeLine("User \"" + userName + "\" logged in");
                        int[] statsData = database.getPlayerStats(userName);
                        if (statsData == null) {
                            console.writeLine("Failed to retrieve stats for user \"" + userName + "\"");
                            return;
                        }
                        Message stats = new Message("Player Stats");
                        stats.setAttribute("User Name", userName);
                        stats.setAttribute("Wins", Integer.toString(statsData[0]));
                        stats.setAttribute("Losses", Integer.toString(statsData[1]));
                        stats.setAttribute("Draws", Integer.toString(statsData[2]));
                        this.sendMessageToClient(stats, delivery.getProperties().getReplyTo());
                        console.writeLine("Sending stats to user \"" + userName + "\"");
                        break block36;
                    }
                    Message reply = new Message("Not Logged In");
                    reply.setAttribute("User Name", userName);
                    this.sendMessageToClient(reply, delivery.getProperties().getReplyTo());
                    console.writeLine("User \"" + userName + "\" failed to log in with valid credentials");
                }
                catch (RemoteException e) {
                    console.writeLine("Error authenticating user: " + userName);
                }
            } else if (message.getType().equalsIgnoreCase("Find Game")) {
                String userName = (String)message.getAttribute("User Name");
                Server password = this;
                synchronized (password) {
                    console.writeLine("User \"" + userName + "\" is requesting a match");
                    GameSession session = null;
                    int i = 0;
                    while (i < this.m_sessions.size()) {
                        if (!this.m_sessions.elementAt(i).isFull()) {
                            session = this.m_sessions.elementAt(i);
                        }
                        ++i;
                    }
                    boolean sessionWithSelf = false;
                    int i2 = 0;
                    while (i2 < this.m_sessions.size()) {
                        if (this.m_sessions.elementAt(i2).contains(userName) && !this.m_sessions.elementAt(i2).isFull()) {
                            sessionWithSelf = true;
                        }
                        ++i2;
                    }
                    if (session == null || sessionWithSelf) {
                        session = new GameSession();
                        if (!session.initialize(this.m_brokerHostName)) {
                            console.writeLine("Failed to create session for user \"" + userName + "\"");
                            return;
                        }
                        session.addPlayer(userName, delivery.getProperties().getReplyTo());
                        this.m_sessions.add(session);
                        console.writeLine("Created session #" + session.getID() + " for user \"" + userName + "\"");
                    } else {
                        session.addPlayer(userName, delivery.getProperties().getReplyTo());
                        console.writeLine("User \"" + userName + "\" added to session #" + session.getID());
                        if (session.isFull()) {
                            console.writeLine("Starting session #" + session.getID());
                            session.startGame();
                        }
                    }
                }
            } else if (message.getType().equalsIgnoreCase("Left Session")) {
                String userName = (String)message.getAttribute("User Name");
                GameSession s = null;
                int i = 0;
                while (i < this.m_sessions.size()) {
                    s = this.m_sessions.elementAt(i);
                    if (s.contains(userName)) {
                        Message playerLeft = new Message("Player Left");
                        playerLeft.setAttribute("User Name", userName);
                        this.sendMessageToClient(playerLeft, s.getOpponentPlayerQueueName(userName));
                        console.writeLine("Player \"" + userName + "\" left session #" + s.getID());
                        s.stop();
                        this.removeSession(s);
                        --i;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void statsUpdated(String userName, int wins, int losses, int draws) {
        User u = this.getUserByName(userName);
        if (u == null) {
            return;
        }
        Message stats = new Message("Player Stats");
        stats.setAttribute("User Name", userName);
        stats.setAttribute("Wins", Integer.toString(wins));
        stats.setAttribute("Losses", Integer.toString(losses));
        stats.setAttribute("Draws", Integer.toString(draws));
        this.sendMessageToClient(stats, u.getQueueName());
        console.writeLine("Sending updated stats to user \"" + userName + "\"");
    }

    @Override
    public void userLogin(String userName) throws RemoteException {
    }

    @Override
    public void userLogout(String userName) throws RemoteException {
    }

    public void stop() {
        this.m_initialized = false;
        this.m_running = false;
        this.m_disconnectHandlerRunning = false;
        try {
            database.removeListener(this);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        int i = 0;
        while (i < this.m_sessions.size()) {
            this.m_sessions.elementAt(i).stop();
            ++i;
        }
        try {
            this.m_disconnectHandlerThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_serverThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkForDisconnects() {
        User u = null;
        int i = 0;
        while (i < this.m_users.size()) {
            u = this.m_users.elementAt(i);
            if (u.ping()) {
                this.sendMessageToClient(new Message("Ping"), u.getQueueName());
            }
            if (u.checkTimeout()) {
                if (u.getUserName() == null) {
                    console.writeLine("Client with queue name \"" + u.getQueueName() + "\" timed out.");
                } else {
                    console.writeLine("User \"" + u.getUserName() + "\" timed out.");
                }
                this.removeUser(i);
                --i;
            }
            ++i;
        }
        GameSession s = null;
        int i2 = 0;
        while (i2 < this.m_sessions.size()) {
            if (this.m_sessions.elementAt(i2).isFinished()) {
                console.writeLine("Removing finished session #" + this.m_sessions.elementAt(i2).getID());
                s = this.m_sessions.elementAt(i2);
                if (this.m_sessions.contains(s)) {
                    this.m_sessions.remove(i2);
                    s.stop();
                    --i2;
                }
            }
            ++i2;
        }
    }

    @Override
    public void run() {
        if (!this.m_initialized) {
            return;
        }
        this.m_running = true;
        while (this.m_running) {
            try {
                this.handleMessage(this.m_consumer.nextDelivery());
            }
            catch (InterruptedException e) {
                this.stop();
            }
            catch (ShutdownSignalException e) {
                this.stop();
            }
            catch (Exception e) {
                console.writeLine("Critical error, server shutting down.");
                e.printStackTrace();
                this.stop();
            }
        }
    }
}

