/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.util.concurrent.TimeUnit;

public class User {
    private String m_queueName;
    private String m_userName;
    private long m_lastTime;
    private boolean m_awaitingResponse;
    public static final long PING_INTERVAL = 5000L;
    public static final long CONNECTION_TIMEOUT = 7500L;
    public static final String[] TABLE_HEADERS = new String[]{"Queue Name", "User Name", "Last Response"};

    public User(String queueName) {
        this(queueName, null);
    }

    public User(String queueName, String userName) {
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name cannot be null for User");
        }
        this.m_queueName = queueName;
        this.m_userName = userName;
        this.m_lastTime = System.currentTimeMillis();
        this.m_awaitingResponse = false;
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public boolean isAwaitingResponse() {
        return this.m_awaitingResponse;
    }

    public boolean ping() {
        if (!this.m_awaitingResponse && System.currentTimeMillis() > this.m_lastTime + 5000L) {
            this.m_lastTime = System.currentTimeMillis();
            this.m_awaitingResponse = true;
            return true;
        }
        return false;
    }

    public void pong() {
        this.m_lastTime = System.currentTimeMillis();
        this.m_awaitingResponse = false;
    }

    public boolean checkTimeout() {
        return this.m_awaitingResponse && System.currentTimeMillis() > this.m_lastTime + 7500L;
    }

    public String getLastResponseTimeInSecondsAsString() {
        long time = this.m_awaitingResponse ? System.currentTimeMillis() - this.m_lastTime : 0L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(time);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time));
        return String.format(String.valueOf(minutes < 10L ? "0" : "") + "%d:" + (minutes < 10L ? "0" : "") + "%d", minutes, seconds);
    }

    public String[] getAsTableEntry() {
        return new String[]{this.m_queueName, this.m_userName, this.getLastResponseTimeInSecondsAsString()};
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof User)) {
            return false;
        }
        return ((User)o).m_queueName.equals(this.m_queueName);
    }

    public String toString() {
        return String.valueOf(this.m_queueName) + " " + this.m_userName;
    }
}

