/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import shared.Serializer;

public class Message
implements Serializable {
    private static final long serialVersionUID = -2815116531203592121L;
    protected String m_type;
    protected Hashtable<String, Object> m_attributes;

    public Message(String type) {
        this.m_type = type == null ? "" : type;
        this.m_attributes = new Hashtable();
    }

    public void setType(String type) {
        this.m_type = type == null ? "" : type;
    }

    public String getType() {
        return this.m_type;
    }

    public int numberOfAttributes() {
        return this.m_attributes.size();
    }

    public Enumeration<String> getKeys() {
        return this.m_attributes.keys();
    }

    public Object getAttribute(String key) {
        if (key == null) {
            return null;
        }
        return this.m_attributes.get(key);
    }

    public void setAttribute(String key, Object attribute) {
        if (key == null || key.length() == 0 || attribute == null) {
            return;
        }
        this.m_attributes.put(key, attribute);
    }

    public void clearAttributes() {
        this.m_attributes.clear();
    }

    public void copyAttributesFrom(Message m) {
        if (m == null) {
            return;
        }
        Enumeration<String> enumeration = m.m_attributes.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            Object value = m.m_attributes.get(key);
            this.setAttribute(key, value);
        }
    }

    public static byte[] serializeMessage(Message m) throws IOException {
        if (m == null) {
            return null;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] typeData = Serializer.serializeString(m.getType());
        byteStream.write(Serializer.serializeInteger(typeData.length));
        byteStream.write(typeData);
        Enumeration<String> keys = m.getKeys();
        byteStream.write(Serializer.serializeInteger(m.numberOfAttributes()));
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            byte[] keyData = Serializer.serializeString(key);
            byteStream.write(Serializer.serializeInteger(keyData.length));
            byteStream.write(keyData);
            Object value = m.getAttribute(key);
            byte[] valueData = Serializer.serializeObject(value);
            byteStream.write(Serializer.serializeInteger(valueData.length));
            byteStream.write(valueData);
        }
        return byteStream.toByteArray();
    }

    public static Message deserializeMessage(byte[] data) throws IOException {
        String type;
        if (data == null) {
            return null;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        byte[] temp = new byte[4];
        byteStream.read(temp);
        int length = Serializer.deserializeInteger(temp);
        if (length == 0) {
            type = "";
        } else {
            byte[] typeData = new byte[length];
            byteStream.read(typeData);
            type = Serializer.deserializeString(typeData);
        }
        temp = new byte[4];
        byteStream.read(temp);
        int numberOfAttributes = Serializer.deserializeInteger(temp);
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        int i = 0;
        while (i < numberOfAttributes) {
            Object value;
            String key;
            temp = new byte[4];
            byteStream.read(temp);
            length = Serializer.deserializeInteger(temp);
            if (length == 0) {
                key = "";
            } else {
                byte[] keyData = new byte[length];
                byteStream.read(keyData);
                key = Serializer.deserializeString(keyData);
            }
            temp = new byte[4];
            byteStream.read(temp);
            length = Serializer.deserializeInteger(temp);
            if (length == 0) {
                value = null;
            } else {
                byte[] valueData = new byte[length];
                byteStream.read(valueData);
                value = Serializer.deserializeObject(valueData);
            }
            if (key != null && value != null && key.length() != 0) {
                attributes.put(key, value);
            }
            ++i;
        }
        Message m = new Message(type);
        m.m_attributes = attributes;
        return m;
    }
}

