/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;

public class Utilities {
    private Utilities() {
    }

    public static Point parsePoint(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String[] stringArray = string.replaceAll("^[^-0-9]+", "").replaceAll("[^-0-9]+$", "").split("[^-0-9]+");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Point(n2, n);
    }

    public static Dimension parseDimension(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String[] stringArray = string.replaceAll("^[^-0-9]+", "").replaceAll("[^-0-9]+$", "").split("[^-0-9]+");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Dimension(n2, n);
    }

    public static Color parseColour(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.replaceAll("^[^-0-9.]+", "").replaceAll("[^-0-9.]+$", "").split("[^-0-9.]+");
        if (stringArray.length != 3) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contains(".")) continue;
            bl = true;
        }
        if (bl) {
            float[] fArray = new float[3];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    fArray[i] = Float.parseFloat(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (!(fArray[i] < 0.0f) && !(fArray[i] > 1.0f)) continue;
                return null;
            }
            return new Color(fArray[0], fArray[1], fArray[2]);
        }
        int[] nArray = new int[3];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (nArray[i] >= 0 && nArray[i] <= 255) continue;
            return null;
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public static int compareCasePercentage(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= 'a' && string.charAt(i) <= 'z') {
                ++n2;
            }
            if (string.charAt(i) < 'A' || string.charAt(i) > 'Z') continue;
            ++n;
        }
        return n - n2;
    }

    public static String getFileNameNoExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1, string.length());
        }
        return null;
    }

    public static boolean fileHasExtension(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = Utilities.getFileExtension(string);
        return string3 != null && string3.equalsIgnoreCase(string2);
    }

    public static String getFilePath(File file) {
        String string;
        if (file == null) {
            return null;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        int n = -1;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != '/' && string.charAt(i) != '\\') continue;
            n = i;
            break;
        }
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        if (string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            string = string + "/";
        }
        return string;
    }

    public static String appendSlash(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return string2;
        }
        if (string2.charAt(string2.length() - 1) != '/' && string2.charAt(string2.length() - 1) != '\\') {
            string2 = string2 + "/";
        }
        return string2;
    }

    public static int compareVersions(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Cannot compare to a null version.");
        }
        String string3 = string.trim();
        String string4 = string2.trim();
        if (string3.length() == 0 || string4.length() == 0) {
            throw new IllegalArgumentException("Cannot compare empty versions.");
        }
        String string5 = "([0-9]\\.?)+";
        if (!string3.matches(string5) || !string4.matches(string5)) {
            throw new IllegalArgumentException("Cannot compare improperly formatted versions.");
        }
        String string6 = "[\\. \\t]+";
        String[] stringArray = string3.split(string6);
        String[] stringArray2 = string4.split(string6);
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if (n >= stringArray.length) {
                if (stringArray.length == stringArray2.length) {
                    return 0;
                }
                n3 = Integer.parseInt(stringArray2[n]);
                if (n3 == 0) {
                    return 0;
                }
                return -1;
            }
            if (n >= stringArray2.length) {
                if (stringArray2.length == stringArray.length) {
                    return 0;
                }
                n2 = Integer.parseInt(stringArray[n]);
                if (n2 == 0) {
                    return 0;
                }
                return 1;
            }
            n2 = Integer.parseInt(stringArray[n]);
            if (n2 > (n3 = Integer.parseInt(stringArray2[n]))) {
                return 1;
            }
            if (n2 < n3) {
                return -1;
            }
            ++n;
        }
    }
}

