/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Client;
import client.ConversationWindow;
import client.Message;
import client.User;
import java.util.Vector;
import shared.UserNetworkData;

public class Conversation {
    private Vector<Message> m_messages;
    private User m_user;
    private Vector<UserNetworkData> m_participants;
    private Client m_client;
    private ConversationWindow m_conversationWindow;

    public Conversation(User user, UserNetworkData contact, Client client, ConversationWindow conversationWindow) {
        this.m_client = client;
        this.m_conversationWindow = conversationWindow;
        this.m_messages = new Vector();
        this.m_participants = new Vector();
        this.m_user = user;
        this.m_participants.add(contact);
    }

    public int numberOfMessages() {
        return this.m_messages.size();
    }

    public Message getMessage(int index) {
        if (index < 0 || index >= this.m_messages.size()) {
            return null;
        }
        return this.m_messages.elementAt(index);
    }

    public int numberOfParticipants() {
        return this.m_participants.size();
    }

    public boolean hasParticipant(String userName) {
        if (userName == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_participants.size()) {
            if (this.m_participants.elementAt(i).getUserName().equalsIgnoreCase(userName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public UserNetworkData getParticipant(String userName) {
        if (userName == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_participants.size()) {
            if (this.m_participants.elementAt(i).getUserName().equalsIgnoreCase(userName)) {
                return this.m_participants.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public UserNetworkData getParticipant(int index) {
        if (index < 0 || index >= this.m_participants.size()) {
            return null;
        }
        return this.m_participants.elementAt(index);
    }

    public boolean addParticipant(UserNetworkData c) {
        if (c == null || this.m_participants.contains(c)) {
            return false;
        }
        return this.m_participants.add(c);
    }

    public boolean removeParticipant(String userName) {
        if (userName == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_participants.size()) {
            if (this.m_participants.elementAt(i).getUserName().equalsIgnoreCase(userName)) {
                this.m_participants.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeParticipant(UserNetworkData c) {
        if (c == null || this.m_participants.contains(c)) {
            return false;
        }
        return this.m_participants.remove(c);
    }

    public boolean removeParticipant(int index) {
        if (index < 0 || index >= this.m_participants.size()) {
            return false;
        }
        this.m_participants.remove(index);
        return true;
    }

    public boolean sendMessage(String message) {
        Message m = new Message(message, this.m_user);
        this.m_messages.add(m);
        int i = 0;
        while (i < this.m_participants.size()) {
            this.m_client.sendMessage(message, m.getID(), this.m_client.getUserName(), this.m_participants.elementAt(i).getUserName());
            ++i;
        }
        return true;
    }

    public boolean receiveMessage(String message, long messageID, String contactUserName) {
        if (contactUserName == null || message == null) {
            return false;
        }
        return this.receiveMessage(message, messageID, this.getParticipant(contactUserName));
    }

    public boolean receiveMessage(String message, long messageID, UserNetworkData contact) {
        if (contact == null || message == null) {
            return false;
        }
        Message m = new Message(message, messageID, contact);
        this.m_messages.add(m);
        this.m_conversationWindow.addMessage(m.getText(), m.getUserName());
        return true;
    }
}

