/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.User;
import java.util.Calendar;
import shared.FontStyle;
import shared.Globals;
import shared.UserNetworkData;

public class Message {
    private long m_id;
    private String m_userName;
    private String m_nickName;
    private String m_text;
    private FontStyle m_font;
    private Calendar m_timeStamp;
    private static long m_idCounter = 0L;

    public Message(String text, long messageID, UserNetworkData contact) {
        this(text, messageID, contact.getUserName(), contact.getNickName(), contact.getFont());
    }

    public Message(String text, User user) {
        this(text, m_idCounter++, user.getUserName(), user.getNickName(), user.getFont());
    }

    private Message(String text, long id, String userName, String nickName, FontStyle font) {
        this.m_id = id;
        this.m_userName = userName == null ? "" : userName;
        this.m_nickName = nickName == null ? "" : nickName;
        this.m_text = text == null ? "" : text;
        this.m_font = font == null ? Globals.DEFAULT_FONTSTYLE : font;
        this.m_timeStamp = Calendar.getInstance();
    }

    public static long nextID() {
        return m_idCounter++;
    }

    public long getID() {
        return this.m_id;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getNickName() {
        return this.m_nickName;
    }

    public String getText() {
        return this.m_text;
    }

    public FontStyle getFont() {
        return this.m_font;
    }

    public Calendar getTimeStamp() {
        return this.m_timeStamp;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Message)) {
            return false;
        }
        Message m = (Message)o;
        return m.m_userName.equalsIgnoreCase(this.m_userName) && m.m_text.equals(this.m_text) && m.m_timeStamp.equals(this.m_timeStamp);
    }

    public String toString() {
        return String.valueOf(this.m_userName) + ": " + this.m_text;
    }
}

