/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Client;
import shared.MessageBoxSystem;

public class ServerDisconnectHandler
extends Thread {
    private Client m_client;
    private MessageBoxSystem m_messageBoxSystem;

    public void initialize(Client client, MessageBoxSystem messageBoxSystem) {
        this.m_client = client;
        this.m_messageBoxSystem = messageBoxSystem;
        if (this.m_client == null) {
            return;
        }
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            this.m_client.addTime(100L);
            this.m_client.ping();
            if (!this.m_client.isConnected()) {
                this.m_client.disconnect();
                if (this.m_client.timeout()) {
                    this.m_messageBoxSystem.show(null, "Connection to server timed out.", "Lost Connection", 2);
                }
            }
            try {
                ServerDisconnectHandler.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

