/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import shared.FontStyle;
import shared.Globals;
import shared.UserData;
import shared.UserNetworkData;

public class User
extends UserData {
    protected String m_password;
    protected Vector<UserNetworkData> m_contacts;

    public User() {
        super(null, null, null, (byte)0, null, null);
        this.m_password = null;
        this.m_contacts = new Vector();
    }

    public User(String userName, String password, String nickName, String personalMessage, byte status, Font font, Color textColour) {
        super(userName, nickName, personalMessage, status, font, textColour);
        this.m_password = password;
        this.m_contacts = new Vector();
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public int numberOfContacts() {
        return this.m_contacts.size();
    }

    public int getContactIndex(String userName) {
        if (userName == null || userName.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.m_contacts.size()) {
            if (userName.equalsIgnoreCase(this.m_contacts.elementAt(i).getUserName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getContactIndex(UserNetworkData c) {
        if (c == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_contacts.size()) {
            if (c.equals(this.m_contacts.elementAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasContact(String userName) {
        if (userName == null || userName.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_contacts.size()) {
            if (userName.equalsIgnoreCase(this.m_contacts.elementAt(i).getUserName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasContact(UserNetworkData c) {
        if (c == null) {
            return false;
        }
        return this.m_contacts.contains(c);
    }

    public UserNetworkData getContact(String userName) {
        if (userName == null || userName.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.m_contacts.size()) {
            if (userName.equalsIgnoreCase(this.m_contacts.elementAt(i).getUserName())) {
                return this.m_contacts.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public UserNetworkData getContact(int index) {
        if (index < 0 || index >= this.m_contacts.size()) {
            return null;
        }
        return this.m_contacts.elementAt(index);
    }

    public boolean addContact(UserNetworkData c) {
        if (c == null || this.m_contacts.contains(c)) {
            return false;
        }
        this.m_contacts.add(c);
        return true;
    }

    public boolean removeContact(UserNetworkData c) {
        if (c == null) {
            return false;
        }
        return this.m_contacts.remove(c);
    }

    public boolean removeContact(int index) {
        if (index < 0 || index >= this.m_contacts.size()) {
            return false;
        }
        this.m_contacts.remove(index);
        return true;
    }

    public boolean removeContact(String userName) {
        if (userName == null || userName.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_contacts.size()) {
            if (userName.equalsIgnoreCase(this.m_contacts.elementAt(i).getUserName())) {
                this.m_contacts.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getContactNickName(String userName) {
        UserNetworkData c = this.getContact(userName);
        return c == null ? null : c.getNickName();
    }

    public String getContactNickName(int index) {
        return index < 0 || index >= this.m_contacts.size() ? null : this.m_contacts.elementAt(index).getNickName();
    }

    public String getContactPersonalMessage(String userName) {
        UserNetworkData c = this.getContact(userName);
        return c == null ? null : c.getPersonalMessage();
    }

    public String getContactPersonalMessage(int index) {
        return index < 0 || index >= this.m_contacts.size() ? null : this.m_contacts.elementAt(index).getPersonalMessage();
    }

    public int getContactStatus(String userName) {
        UserNetworkData c = this.getContact(userName);
        return c == null ? (byte)0 : c.getStatus();
    }

    public int getContactStatus(int index) {
        return index < 0 || index >= this.m_contacts.size() ? 0 : (int)this.m_contacts.elementAt(index).getStatus();
    }

    public FontStyle getContactFont(String userName) {
        UserNetworkData c = this.getContact(userName);
        return c == null ? Globals.DEFAULT_FONTSTYLE : c.getFont();
    }

    public FontStyle getContactFont(int index) {
        return index < 0 || index >= this.m_contacts.size() ? Globals.DEFAULT_FONTSTYLE : this.m_contacts.elementAt(index).getFont();
    }

    public Color getContactTextColour(String userName) {
        UserNetworkData c = this.getContact(userName);
        return c == null ? Globals.DEFAULT_TEXT_COLOUR : c.getFont().getColour();
    }

    public Color getContactTextColour(int index) {
        return index < 0 || index >= this.m_contacts.size() ? Globals.DEFAULT_TEXT_COLOUR : this.m_contacts.elementAt(index).getFont().getColour();
    }

    public void updateContact(UserNetworkData data) {
        if (data == null) {
            return;
        }
        int contactIndex = this.getContactIndex(data.getUserName());
        if (contactIndex >= 0) {
            this.m_contacts.elementAt(contactIndex).setUserName(data.getUserName());
            this.m_contacts.elementAt(contactIndex).setNickName(data.getNickName());
            this.m_contacts.elementAt(contactIndex).setPersonalMessage(data.getPersonalMessage());
            this.m_contacts.elementAt(contactIndex).setStatus(data.getStatus());
            this.m_contacts.elementAt(contactIndex).setFont(data.getFont());
            this.m_contacts.elementAt(contactIndex).setBlocked(data.isBlocked());
            this.m_contacts.elementAt(contactIndex).setIPAddress(data.getIPAddress());
            this.m_contacts.elementAt(contactIndex).setPort(data.getPort());
        } else {
            this.m_contacts.add(new UserNetworkData(data));
        }
    }

    public void updateContacts(Vector<UserNetworkData> data) {
        if (data == null) {
            return;
        }
        int i = 0;
        while (i < data.size()) {
            this.updateContact(data.elementAt(i));
            ++i;
        }
    }

    public void setContactNickName(String userName, String nickName) {
        UserNetworkData c = this.getContact(userName);
        if (c != null) {
            c.setNickName(nickName);
        }
    }

    public void setContactNickName(int index, String nickName) {
        if (index < 0 || index >= this.m_contacts.size()) {
            this.m_contacts.elementAt(index).setNickName(nickName);
        }
    }

    public void setContactPersonalMessage(String userName, String personalMessage) {
        UserNetworkData c = this.getContact(userName);
        if (c != null) {
            c.setPersonalMessage(personalMessage);
        }
    }

    public void setContactPersonalMessage(int index, String personalMessage) {
        if (index < 0 || index >= this.m_contacts.size()) {
            this.m_contacts.elementAt(index).setPersonalMessage(personalMessage);
        }
    }

    public void setContactStatus(String userName, byte status) {
        UserNetworkData c = this.getContact(userName);
        if (c != null) {
            c.setStatus(status);
        }
    }

    public void setContactStatus(int index, byte status) {
        if (index < 0 || index >= this.m_contacts.size()) {
            this.m_contacts.elementAt(index).setStatus(status);
        }
    }

    public void setContactFont(String userName, FontStyle font) {
        UserNetworkData c = this.getContact(userName);
        if (c != null) {
            c.setFont(font);
        }
    }

    public void setContactFont(int index, FontStyle font) {
        if (index < 0 || index >= this.m_contacts.size()) {
            this.m_contacts.elementAt(index).setFont(font);
        }
    }

    public void setContactTextColour(String userName, Color textColour) {
        UserNetworkData c = this.getContact(userName);
        if (c != null) {
            c.getFont().setColour(textColour);
        }
    }

    public void setContactTextColour(int index, Color textColour) {
        if (index < 0 || index >= this.m_contacts.size()) {
            this.m_contacts.elementAt(index).getFont().setColour(textColour);
        }
    }

    public void clearContacts() {
        this.m_contacts.clear();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof User)) {
            return false;
        }
        return ((User)o).m_userName.equalsIgnoreCase(this.m_userName);
    }

    public String toString() {
        return this.m_userName;
    }
}

