/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Color;
import java.awt.Font;
import shared.ByteStream;
import shared.Globals;

public class FontStyle {
    protected Font m_font;
    protected String m_face;
    protected int m_size;
    protected boolean m_bold;
    protected boolean m_italic;
    protected Color m_colour;
    public static final int LENGTH = 82;

    public FontStyle(Font font) {
        this.m_colour = Globals.DEFAULT_TEXT_COLOUR;
        this.setFont(font);
    }

    public FontStyle(Font font, Color colour) {
        this.m_colour = colour == null ? Globals.DEFAULT_TEXT_COLOUR : colour;
        this.setFont(font);
    }

    public FontStyle(String face, int size, boolean bold, boolean italic, Color colour) {
        this.m_face = face == null ? "Arial" : face;
        this.m_size = size < 2 ? 2 : size;
        this.m_bold = bold;
        this.m_italic = italic;
        this.m_colour = colour == null ? Globals.DEFAULT_TEXT_COLOUR : colour;
        this.initializeFont();
    }

    private void initializeFont() {
        this.m_font = new Font(this.m_face, this.getStyle(), this.m_size);
    }

    public Font getFont() {
        return this.m_font;
    }

    public int getSize() {
        return this.m_size;
    }

    public Color getColour() {
        return this.m_colour;
    }

    public int[] getColourData() {
        int[] colourData = new int[]{this.m_colour.getRed(), this.m_colour.getGreen(), this.m_colour.getBlue()};
        return colourData;
    }

    public boolean isPlain() {
        return !this.m_bold && !this.m_italic;
    }

    public boolean isBold() {
        return this.m_bold;
    }

    public boolean isItalic() {
        return this.m_italic;
    }

    public boolean isBoldItalic() {
        return this.m_bold && this.m_italic;
    }

    public int getStyle() {
        return 0 + (this.m_bold ? 1 : 0) + (this.m_italic ? 2 : 0);
    }

    public void setFont(Font font) {
        if (font == null) {
            this.m_face = "Arial";
            this.m_size = 12;
            this.m_bold = false;
            this.m_italic = false;
            this.initializeFont();
        } else {
            this.m_face = font.getFontName();
            this.m_size = font.getSize();
            this.m_bold = font.isBold();
            this.m_italic = font.isItalic();
            this.m_font = font;
        }
    }

    public void setSize(int size) {
        if (size >= 2) {
            this.m_size = size;
        }
        this.initializeFont();
    }

    public void setColour(Color colour) {
        if (colour != null) {
            this.m_colour = colour;
        }
    }

    public void setColour(int[] colourData) {
        if (colourData == null || colourData.length != 3) {
            return;
        }
        int i = 0;
        while (i < 3) {
            if (colourData[i] < 0 || colourData[i] > 255) {
                return;
            }
            ++i;
        }
        this.m_colour = new Color(colourData[0], colourData[1], colourData[2]);
    }

    public void setBold(boolean bold) {
        this.m_bold = bold;
        this.initializeFont();
    }

    public void setItalic(boolean italic) {
        this.m_italic = italic;
        this.initializeFont();
    }

    public void setBoldItalic(boolean boldItalic) {
        this.m_bold = boldItalic;
        this.m_italic = boldItalic;
        this.initializeFont();
    }

    public void setPlain(boolean plain) {
        if (plain) {
            this.m_bold = false;
            this.m_italic = false;
            this.initializeFont();
        }
    }

    public void setStyle(int style) {
        if (style < 0 || style > 2) {
            return;
        }
        if (style == 0) {
            this.setPlain(true);
        } else if (style == 1) {
            this.setBold(true);
        } else if (style == 2) {
            this.setItalic(true);
        } else if (style == 3) {
            this.setBoldItalic(true);
        }
    }

    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_face, 32);
        checksum += ByteStream.getChecksum(this.m_size);
        checksum += ByteStream.getChecksum(this.m_bold);
        checksum += ByteStream.getChecksum(this.m_italic);
        checksum += ByteStream.getChecksum(this.m_colour.getRed());
        checksum += ByteStream.getChecksum(this.m_colour.getGreen());
        return checksum += ByteStream.getChecksum(this.m_colour.getBlue());
    }

    public static FontStyle readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        String face = byteStream.nextString(32);
        int size = byteStream.nextInteger();
        boolean bold = byteStream.nextBoolean();
        boolean italic = byteStream.nextBoolean();
        int[] colourData = new int[]{byteStream.nextInteger(), byteStream.nextInteger(), byteStream.nextInteger()};
        Color colour = new Color(colourData[0], colourData[1], colourData[2]);
        return new FontStyle(face, size, bold, italic, colour);
    }

    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        byteStream.addStringFixedLength(this.m_face, 32);
        byteStream.addInteger(this.m_size);
        byteStream.addBoolean(this.m_bold);
        byteStream.addBoolean(this.m_italic);
        byteStream.addInteger(this.m_colour.getRed());
        byteStream.addInteger(this.m_colour.getGreen());
        byteStream.addInteger(this.m_colour.getBlue());
    }
}

