/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.net.InetAddress;
import java.net.UnknownHostException;
import shared.ByteStream;
import shared.FontStyle;
import shared.UserData;

public class UserNetworkData
extends UserData {
    protected boolean m_blocked;
    protected InetAddress m_ipAddress;
    protected int m_port;
    public static final int LENGTH = 924;

    public UserNetworkData(String userName, String nickName, String personalMessage, byte status, FontStyle font, boolean blocked, InetAddress ipAddress, int port) {
        super(userName, nickName, personalMessage, status, font);
        this.m_blocked = blocked;
        this.m_ipAddress = ipAddress;
        this.m_port = port < 0 || port > 65535 ? 0 : port;
    }

    public UserNetworkData(String userName, String nickName, String personalMessage, byte status, FontStyle font) {
        this(userName, nickName, personalMessage, status, font, false, null, 0);
    }

    public UserNetworkData(UserData userData, boolean blocked, InetAddress ipAddress, int port) {
        super(userData.m_userName, userData.m_nickName, userData.m_personalMessage, userData.m_status, userData.m_font);
        this.m_blocked = blocked;
        this.m_ipAddress = ipAddress;
        this.m_port = port < 0 || port > 65535 ? 0 : port;
    }

    public UserNetworkData(UserData userData) {
        this(userData, false, null, 0);
    }

    public boolean isBlocked() {
        return this.m_blocked;
    }

    public InetAddress getIPAddress() {
        return this.m_ipAddress;
    }

    public String getIPAddressString() {
        return this.m_ipAddress == null ? "" : this.m_ipAddress.getHostAddress();
    }

    public int getPort() {
        return this.m_port;
    }

    public void setBlocked(boolean blocked) {
        this.m_blocked = blocked;
    }

    public void setIPAddress(InetAddress ipAddress) {
        if (ipAddress != null) {
            this.m_ipAddress = ipAddress;
        }
    }

    public void setIPAddress(String ipAddress) {
        this.setIPAddress(UserNetworkData.parseIPAddress(ipAddress));
    }

    public void setPort(int port) {
        if (port >= 0 && port <= 65535) {
            this.m_port = port;
        }
    }

    public static InetAddress parseIPAddress(String ipAddress) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += super.checksum();
        checksum += ByteStream.getChecksum(this.m_blocked);
        if (this.m_ipAddress != null) {
            byte[] ipData = this.m_ipAddress.getAddress();
            int i = 0;
            while (i < 4) {
                checksum += ByteStream.getChecksum(ipData[i]);
                ++i;
            }
        }
        return checksum += ByteStream.getChecksum(this.m_port);
    }

    public static UserNetworkData readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        UserData userData = UserData.readFrom(byteStream);
        boolean blocked = byteStream.nextBoolean();
        InetAddress ipAddress = null;
        byte[] ipData = new byte[4];
        int i22 = 0;
        while (i22 < 4) {
            ipData[i22] = byteStream.nextByte();
            ++i22;
        }
        try {
            ipAddress = InetAddress.getByAddress(ipData);
        }
        catch (UnknownHostException i22) {
            // empty catch block
        }
        int port = byteStream.nextInteger();
        return new UserNetworkData(userData, blocked, ipAddress, port);
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addBoolean(this.m_blocked);
        byte[] ipData = null;
        if (this.m_ipAddress != null) {
            ipData = this.m_ipAddress.getAddress();
        }
        int i = 0;
        while (i < 4) {
            byteStream.addByte(ipData == null ? (byte)0 : ipData[i]);
            ++i;
        }
        byteStream.addInteger(this.m_port);
    }

    public static /* bridge */ /* synthetic */ UserData readFrom(ByteStream byteStream) {
        return UserNetworkData.readFrom(byteStream);
    }
}

