/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ChangeNicknameSignal
extends Signal {
    private String m_userName;
    private String m_nickName;
    public static final int LENGTH = 328;

    private ChangeNicknameSignal() {
        super(18);
    }

    public ChangeNicknameSignal(String userName, String nickName) {
        super(18);
        this.m_userName = userName;
        this.m_nickName = nickName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getNickName() {
        return this.m_nickName;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_nickName, 128);
    }

    public static ChangeNicknameSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ChangeNicknameSignal s2 = new ChangeNicknameSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_nickName = byteStream.nextString(128);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_nickName, 128);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ChangeNicknameSignal.readFrom(byteStream);
    }
}

