/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.io.DataInputStream;
import java.util.Vector;
import shared.ByteStream;
import shared.UserNetworkData;
import signal.Signal;

public class ContactListSignal
extends Signal {
    private Vector<UserNetworkData> m_contacts;
    public static final int LENGTH = 12;

    private ContactListSignal() {
        super(23);
        this.m_contacts = new Vector();
    }

    public ContactListSignal(Vector<UserNetworkData> contacts) {
        super(23);
        this.m_contacts = contacts == null ? new Vector() : contacts;
    }

    public int numberOfContacts() {
        return this.m_contacts.size();
    }

    public UserNetworkData getContact(int index) {
        if (index < 0 || index >= this.m_contacts.size()) {
            return null;
        }
        return this.m_contacts.elementAt(index);
    }

    public Vector<UserNetworkData> getContacts() {
        return this.m_contacts;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_contacts.size());
        int i = 0;
        while (i < this.m_contacts.size()) {
            checksum += this.m_contacts.elementAt(i).checksum();
            ++i;
        }
        return checksum;
    }

    public static ContactListSignal readFrom(ByteStream byteStream, DataInputStream in) {
        if (byteStream == null || in == null) {
            return null;
        }
        ContactListSignal s2 = new ContactListSignal();
        int numberOfContacts = byteStream.nextInteger();
        long checksum = byteStream.nextLong();
        int i = 0;
        while (i < numberOfContacts) {
            UserNetworkData d = UserNetworkData.readFrom(ByteStream.readFrom(in, 924));
            if (d != null) {
                s2.m_contacts.add(d);
            }
            ++i;
        }
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addInteger(this.m_contacts.size());
        byteStream.addLong(this.checksum());
        int i = 0;
        while (i < this.m_contacts.size()) {
            this.m_contacts.elementAt(i).writeTo(byteStream);
            ++i;
        }
    }
}

