/*
 * Decompiled with CFR 0.152.
 */
package logger;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import logger.SystemLogEntryType;

public class SystemLogEntry {
    private Calendar m_time = Calendar.getInstance();
    private int m_type;
    private String m_text;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-d hh:mm:ss a");

    public SystemLogEntry(int type, String text) {
        this.m_type = SystemLogEntryType.isValid(type) ? type : 0;
        this.m_text = text;
    }

    public Calendar getTime() {
        return this.m_time;
    }

    public String getTimeString() {
        return dateFormat.format(this.m_time.getTime());
    }

    public int getType() {
        return this.m_type;
    }

    public String getTypeString() {
        return SystemLogEntryType.getString(this.m_type);
    }

    public String getText() {
        return this.m_text;
    }
}

