/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import logger.Logger;
import server.ClientInputSignalQueue;
import server.ClientOutputSignalQueue;
import server.ClientThread;
import server.Server;
import shared.Globals;
import shared.UserNetworkData;
import signal.Signal;

public class Client
extends UserNetworkData {
    private int m_clientNumber;
    private String m_password;
    private Socket m_connection;
    private boolean m_connected = false;
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private ClientInputSignalQueue m_inSignalQueue;
    private ClientOutputSignalQueue m_outSignalQueue;
    private ClientThread m_clientThread = null;
    private int m_timeElapsed = 0;
    private boolean m_awaitingResponse = false;
    private Logger m_logger;
    private Server m_server;
    public static int currentPort = 25502;

    public Client(Socket connection, int clientNumber) {
        super(null, null, null, (byte)0, Globals.DEFAULT_FONTSTYLE, false, connection.getInetAddress(), currentPort++);
        this.m_clientNumber = clientNumber;
        this.m_connection = connection;
        this.m_inSignalQueue = new ClientInputSignalQueue();
        this.m_outSignalQueue = new ClientOutputSignalQueue();
    }

    public void initialize(Server server, Logger logger) {
        this.m_server = server;
        this.m_connected = true;
        try {
            this.m_logger = logger;
            this.m_out = new DataOutputStream(this.m_connection.getOutputStream());
            this.m_in = new DataInputStream(this.m_connection.getInputStream());
            this.m_inSignalQueue.initialize(server, this, this.m_in, this.m_outSignalQueue, this.m_logger);
            this.m_outSignalQueue.initialize(this, this.m_out, this.m_logger);
            if (this.m_clientThread == null || this.m_clientThread.isTerminated()) {
                this.m_clientThread = new ClientThread();
                this.m_clientThread.initialize(this);
            }
        }
        catch (IOException e) {
            this.m_connected = false;
            this.m_logger.addError("Unable to initalize connection to client #" + this.m_clientNumber);
        }
    }

    public Socket getConnection() {
        return this.m_connection;
    }

    public boolean isConnected() {
        return this.m_connected && !this.timeout();
    }

    public boolean ping() {
        if (!this.m_awaitingResponse && (long)this.m_timeElapsed >= 5000L) {
            this.m_timeElapsed = 0;
            this.m_awaitingResponse = true;
            this.m_outSignalQueue.addSignal(new Signal(1));
            return true;
        }
        return false;
    }

    public void pong() {
        this.m_timeElapsed = 0;
        this.m_awaitingResponse = false;
    }

    public boolean awaitingResponse() {
        return this.m_awaitingResponse;
    }

    public int timeElapsed() {
        return this.m_timeElapsed;
    }

    public void addTime(long time) {
        if (time <= 0L) {
            return;
        }
        this.m_timeElapsed = (int)((long)this.m_timeElapsed + time);
    }

    public boolean timeout() {
        return this.m_awaitingResponse && (long)this.m_timeElapsed >= 7500L;
    }

    public void disconnect() {
        if (this.m_server != null) {
            this.m_server.updateUserStatus(this, (byte)0);
        }
        this.m_connected = false;
        try {
            if (this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_out = null;
        this.m_in = null;
        this.m_connection = null;
    }

    public void sendSignal(Signal s) {
        this.m_outSignalQueue.addSignal(s);
    }

    public DataInputStream getInputStream() {
        return this.m_in;
    }

    public DataOutputStream getOutputStream() {
        return this.m_out;
    }

    public int getClientNumber() {
        return this.m_clientNumber;
    }

    public boolean checkUserName(String userName) {
        return this.m_userName != null && userName != null && this.m_userName.equalsIgnoreCase(userName);
    }

    public boolean checkPassword(String password) {
        return this.m_password != null && password != null && this.m_password.equals(password);
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void readSignal() {
        this.m_inSignalQueue.readSignal();
    }
}

