/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.DataInputStream;
import java.util.ArrayDeque;
import java.util.Vector;
import logger.Logger;
import server.Client;
import server.ClientOutputSignalQueue;
import server.Server;
import shared.ByteStream;
import shared.Globals;
import shared.UserNetworkData;
import signal.AddContactSignal;
import signal.BlockContactSignal;
import signal.BroadcastLoginSignal;
import signal.ChangeNicknameSignal;
import signal.ChangePasswordSignal;
import signal.ChangePersonalMessageSignal;
import signal.ChangeStatusSignal;
import signal.ContactAddedSignal;
import signal.ContactBlockedSignal;
import signal.ContactDeletedSignal;
import signal.ContactListSignal;
import signal.CreateUserSignal;
import signal.DeleteContactSignal;
import signal.LoginAuthenticatedSignal;
import signal.LoginRequestSignal;
import signal.LogoutSignal;
import signal.MessageSignal;
import signal.PasswordChangedSignal;
import signal.Signal;
import signal.UserCreatedSignal;

public class ClientInputSignalQueue
extends Thread {
    private ArrayDeque<Signal> m_inSignalQueue = new ArrayDeque();
    private DataInputStream m_in;
    private ClientOutputSignalQueue m_outSignalQueue;
    private Server m_server;
    private Client m_client;
    private Logger m_logger;

    public void initialize(Server server, Client client, DataInputStream in, ClientOutputSignalQueue out, Logger logger) {
        this.m_server = server;
        this.m_client = client;
        this.m_in = in;
        this.m_outSignalQueue = out;
        this.m_logger = logger;
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void addSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_inSignalQueue.add(s);
    }

    private void sendSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(s);
    }

    public void readSignal() {
        if (!this.m_client.isConnected()) {
            return;
        }
        Signal s = Signal.readFrom(ByteStream.readFrom(this.m_in, 12));
        Signal s2 = null;
        if (s == null) {
            return;
        }
        if (s.getSignalType() == 1) {
            s2 = s;
        } else if (s.getSignalType() == 2) {
            s2 = s;
        } else if (s.getSignalType() == 3) {
            s2 = LoginRequestSignal.readFrom(ByteStream.readFrom(this.m_in, 136));
        } else if (s.getSignalType() == 5) {
            s2 = LogoutSignal.readFrom(ByteStream.readFrom(this.m_in, 72));
        } else if (s.getSignalType() == 6) {
            s2 = BroadcastLoginSignal.readFrom(ByteStream.readFrom(this.m_in, 932));
        } else if (s.getSignalType() == 7) {
            s2 = MessageSignal.readFrom(ByteStream.readFrom(this.m_in, 148), this.m_in);
        } else if (s.getSignalType() == 10) {
            s2 = ChangePasswordSignal.readFrom(ByteStream.readFrom(this.m_in, 200));
        } else if (s.getSignalType() == 12) {
            s2 = AddContactSignal.readFrom(ByteStream.readFrom(this.m_in, 72));
        } else if (s.getSignalType() == 14) {
            s2 = DeleteContactSignal.readFrom(ByteStream.readFrom(this.m_in, 72));
        } else if (s.getSignalType() == 16) {
            s2 = BlockContactSignal.readFrom(ByteStream.readFrom(this.m_in, 73));
        } else if (s.getSignalType() == 18) {
            s2 = ChangeNicknameSignal.readFrom(ByteStream.readFrom(this.m_in, 328));
        } else if (s.getSignalType() == 19) {
            s2 = ChangePersonalMessageSignal.readFrom(ByteStream.readFrom(this.m_in, 584));
        } else if (s.getSignalType() == 20) {
            s2 = ChangeStatusSignal.readFrom(ByteStream.readFrom(this.m_in, 73));
        } else if (s.getSignalType() == 21) {
            s2 = CreateUserSignal.readFrom(ByteStream.readFrom(this.m_in, 200));
        } else {
            this.m_logger.addWarning("Unexpected input signal of type: " + s.getSignalType());
        }
        this.addSignal(s2);
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            if (!this.m_inSignalQueue.isEmpty()) {
                Signal s2;
                Signal s = this.m_inSignalQueue.remove();
                if (s.getSignalType() == 1) {
                    this.sendSignal(new Signal(2));
                } else if (s.getSignalType() == 2) {
                    this.m_client.pong();
                } else if (s.getSignalType() == 3) {
                    s2 = (LoginRequestSignal)s;
                    boolean authenticated = this.m_server.userLogin(this.m_client, ((LoginRequestSignal)s2).getUserName(), ((LoginRequestSignal)s2).getPassword());
                    this.sendSignal(new LoginAuthenticatedSignal(this.m_client.getUserName(), this.m_client.getNickName(), this.m_client.getPersonalMessage(), authenticated, this.m_client.getPort()));
                    this.m_logger.addCommand(((LoginRequestSignal)s2).getUserName(), "Login Request: " + (authenticated ? "Accepted" : "Rejected"));
                } else if (s.getSignalType() == 5) {
                    s2 = (LogoutSignal)s;
                    this.m_client.disconnect();
                    this.m_logger.addCommand(((LogoutSignal)s2).getUserName(), "Logged Out");
                    this.m_logger.addInfo("Client #" + this.m_client.getClientNumber() + " (" + ((LogoutSignal)s2).getUserName() + ") logged out");
                } else if (s.getSignalType() == 6) {
                    s2 = (BroadcastLoginSignal)s;
                    if (this.m_client.getUserName() != null) {
                        ((BroadcastLoginSignal)s2).getData().setUserName(this.m_client.getUserName());
                        ((BroadcastLoginSignal)s2).getData().setIPAddress(this.m_client.getIPAddress());
                        ((BroadcastLoginSignal)s2).getData().setPort(this.m_client.getPort());
                    }
                    Vector<UserNetworkData> contacts = this.m_server.getUserContacts(this.m_client.getUserName());
                    this.m_server.broadcastUserLogin((BroadcastLoginSignal)s2, contacts);
                    this.sendSignal(new ContactListSignal(contacts));
                } else if (s.getSignalType() == 7) {
                    s2 = (MessageSignal)s;
                    if (this.m_client.getUserName() != null && this.m_client.getUserName().equalsIgnoreCase(((MessageSignal)s2).getUserName())) {
                        this.m_server.forwardMessage((MessageSignal)s2);
                    }
                } else if (s.getSignalType() == 10) {
                    s2 = (ChangePasswordSignal)s;
                    boolean passwordChanged = this.m_server.changeUserPassword(this.m_client, ((ChangePasswordSignal)s2).getUserName(), ((ChangePasswordSignal)s2).getOldPassword(), ((ChangePasswordSignal)s2).getNewPassword());
                    this.sendSignal(new PasswordChangedSignal(passwordChanged));
                    this.m_logger.addCommand(((ChangePasswordSignal)s2).getUserName(), "Password Change Request: " + (passwordChanged ? "Succeeded" : "Failed"));
                } else if (s.getSignalType() == 12) {
                    s2 = (AddContactSignal)s;
                    UserNetworkData contactData = this.m_server.addUserContact(this.m_client, ((AddContactSignal)s2).getUserName());
                    boolean added = contactData != null;
                    UserNetworkData newData = contactData;
                    if (newData == null) {
                        newData = new UserNetworkData(((AddContactSignal)s2).getUserName(), null, null, 0, Globals.DEFAULT_FONTSTYLE);
                    }
                    this.sendSignal(new ContactAddedSignal(newData, added));
                    this.m_logger.addCommand(((AddContactSignal)s2).getUserName(), "Added Contact: " + ((AddContactSignal)s2).getUserName() + " (" + (added ? "Succeeded" : "Failed") + ")");
                } else if (s.getSignalType() == 14) {
                    s2 = (DeleteContactSignal)s;
                    boolean contactDeleted = this.m_server.deleteUserContact(this.m_client, ((DeleteContactSignal)s2).getUserName());
                    this.sendSignal(new ContactDeletedSignal(((DeleteContactSignal)s2).getUserName(), contactDeleted));
                    this.m_logger.addCommand(((DeleteContactSignal)s2).getUserName(), "Deleted Contact: " + ((DeleteContactSignal)s2).getUserName() + " (" + (contactDeleted ? "Succeeded" : "Failed") + ")");
                } else if (s.getSignalType() == 16) {
                    s2 = (BlockContactSignal)s;
                    int result = this.m_server.blockUserContact(this.m_client, ((BlockContactSignal)s2).getUserName(), ((BlockContactSignal)s2).getBlocked());
                    boolean contactBlocked = result == 1;
                    boolean succeeded = result != 2;
                    this.sendSignal(new ContactBlockedSignal(((BlockContactSignal)s2).getUserName(), contactBlocked, succeeded));
                    if (succeeded) {
                        this.m_logger.addCommand(((BlockContactSignal)s2).getUserName(), String.valueOf(contactBlocked ? "Blocked" : "Unblocked") + " Contact: " + ((BlockContactSignal)s2).getUserName());
                    }
                } else if (s.getSignalType() == 18) {
                    s2 = (ChangeNicknameSignal)s;
                    if (this.m_client.getUserName() != null && this.m_client.getUserName().equalsIgnoreCase(((ChangeNicknameSignal)s2).getUserName())) {
                        this.m_server.updateUserNickName(this.m_client, ((ChangeNicknameSignal)s2).getNickName());
                    }
                } else if (s.getSignalType() == 19) {
                    s2 = (ChangePersonalMessageSignal)s;
                    if (this.m_client.getUserName() != null && this.m_client.getUserName().equalsIgnoreCase(((ChangePersonalMessageSignal)s2).getUserName())) {
                        this.m_server.updateUserPersonalMessage(this.m_client, ((ChangePersonalMessageSignal)s2).getPersonalMessage());
                    }
                } else if (s.getSignalType() == 20) {
                    s2 = (ChangeStatusSignal)s;
                    if (this.m_client.getUserName() != null && this.m_client.getUserName().equalsIgnoreCase(((ChangeStatusSignal)s2).getUserName())) {
                        this.m_server.updateUserStatus(this.m_client, ((ChangeStatusSignal)s2).getStatus());
                    }
                } else if (s.getSignalType() == 21) {
                    s2 = (CreateUserSignal)s;
                    boolean userCreated = this.m_server.createUser(this.m_client, ((CreateUserSignal)s2).getUserName(), ((CreateUserSignal)s2).getPassword());
                    this.sendSignal(new UserCreatedSignal(userCreated));
                    if (userCreated) {
                        this.m_logger.addCommand(((CreateUserSignal)s2).getUserName(), "Created Account");
                    }
                } else {
                    this.m_logger.addWarning("Unexpected input signal of type: " + s.getSignalType());
                }
            }
            try {
                ClientInputSignalQueue.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

